/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula;

import csheets.core.Cell;
import csheets.core.IllegalValueTypeException;
import csheets.core.Value;
import csheets.core.formula.Expression;
import csheets.core.formula.Reference;
import csheets.core.formula.util.CircularReferenceException;
import csheets.core.formula.util.CircularReferenceFinder;
import csheets.core.formula.util.ExpressionVisitor;
import csheets.core.formula.util.ExpressionVisitorException;
import csheets.core.formula.util.ReferenceFetcher;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formula
implements Expression {
    private static final long serialVersionUID = 7127589370042533160L;
    private Cell cell;
    private Expression expression;
    private SortedSet<Reference> references;

    public Formula(Cell cell, Expression expression) {
        this.cell = cell;
        this.expression = expression;
    }

    @Override
    public Value evaluate() throws IllegalValueTypeException {
        if (!this.hasCircularReference()) {
            return this.expression.evaluate();
        }
        return new Value(new CircularReferenceException(this));
    }

    @Override
    public Object accept(ExpressionVisitor expressionVisitor) {
        return this.expression.accept(expressionVisitor);
    }

    public Cell getCell() {
        return this.cell;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public SortedSet<Reference> getReferences() {
        if (this.references == null) {
            this.references = new ReferenceFetcher().getReferences(this.expression);
        }
        return new TreeSet<Reference>(this.references);
    }

    public boolean hasCircularReference() {
        try {
            new CircularReferenceFinder().check(this);
        }
        catch (ExpressionVisitorException expressionVisitorException) {
            return true;
        }
        return false;
    }

    public String toString() {
        return this.expression.toString();
    }
}

