/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula;

import csheets.core.IllegalValueTypeException;
import csheets.core.Value;
import csheets.core.formula.Expression;
import csheets.core.formula.Function;
import csheets.core.formula.FunctionParameter;
import csheets.core.formula.compiler.IllegalFunctionCallException;
import csheets.core.formula.lang.Language;
import csheets.core.formula.lang.UnknownElementException;
import csheets.core.formula.util.ExpressionVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class FunctionCall
implements Expression {
    private static final long serialVersionUID = 1666675675246822233L;
    private transient Function function;
    private Expression[] args;

    public FunctionCall(Function function, Expression ... expressionArray) throws IllegalFunctionCallException {
        int n;
        this.function = function;
        this.args = expressionArray;
        FunctionParameter[] functionParameterArray = function.getParameters();
        for (n = 0; n < expressionArray.length; ++n) {
            if (functionParameterArray.length > n || function.isVarArg()) continue;
            throw new IllegalFunctionCallException(function, null, expressionArray[n]);
        }
        for (n = functionParameterArray.length - 1; n >= 0; --n) {
            if (n < expressionArray.length || functionParameterArray[n].isOptional()) continue;
            throw new IllegalFunctionCallException(function, functionParameterArray[n], null);
        }
    }

    public Value evaluate() throws IllegalValueTypeException {
        return this.function.applyTo(this.args);
    }

    public Function getFunction() {
        return this.function;
    }

    public Expression[] getArguments() {
        return this.args;
    }

    public Object accept(ExpressionVisitor expressionVisitor) {
        return expressionVisitor.visitFunctionCall(this);
    }

    public String toString() {
        String string = this.function.getIdentifier().toUpperCase() + "(";
        for (int i = 0; i < this.args.length; ++i) {
            string = string + this.args[i];
            if (i + 1 >= this.args.length) continue;
            string = string + "; ";
        }
        string = string + ")";
        return string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        try {
            this.function = Language.getInstance().getFunction(string);
        }
        catch (UnknownElementException unknownElementException) {
            throw new IOException(unknownElementException.toString());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.function.getIdentifier());
    }
}

