/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.compiler;

import csheets.CleanSheets;
import csheets.core.Cell;
import csheets.core.formula.Expression;
import csheets.core.formula.Formula;
import csheets.core.formula.compiler.ExpressionCompiler;
import csheets.core.formula.compiler.FormulaCompilationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class FormulaCompiler {
    private static final FormulaCompiler instance = new FormulaCompiler();
    private static final String PROPERTIES_FILENAME = "res/compilers.props";
    private List<ExpressionCompiler> compilers = new ArrayList<ExpressionCompiler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FormulaCompiler() {
        Properties properties = new Properties();
        InputStream inputStream = CleanSheets.class.getResourceAsStream(PROPERTIES_FILENAME);
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                System.err.println("An I/O error occurred when loading compiler properties file (res/compilers.props).");
                return;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            for (Object object : properties.keySet()) {
                Object obj;
                Class<?> clazz;
                try {
                    clazz = Class.forName(this.getClass().getPackage().getName() + "." + (String)object);
                    obj = clazz.newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                if (!ExpressionCompiler.class.isAssignableFrom(clazz)) continue;
                this.compilers.add((ExpressionCompiler)ExpressionCompiler.class.cast(obj));
            }
        } else {
            System.err.println("Could not find compiler properties file (res/compilers.props).");
        }
    }

    public static FormulaCompiler getInstance() {
        return instance;
    }

    public Formula compile(Cell cell, String string) throws FormulaCompilationException {
        for (ExpressionCompiler expressionCompiler : this.compilers) {
            if (string.charAt(0) != expressionCompiler.getStarter()) continue;
            Expression expression = expressionCompiler.compile(cell, string);
            return new Formula(cell, expression);
        }
        return null;
    }
}

