/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.lang;

import csheets.core.IllegalValueTypeException;
import csheets.core.Value;
import csheets.core.formula.Expression;
import csheets.core.formula.Function;
import csheets.core.formula.FunctionParameter;

public class Average
implements Function {
    public static final FunctionParameter[] parameters = new FunctionParameter[]{new FunctionParameter(Value.Type.NUMERIC, "Term", false, "A number to be included in the average")};

    public String getIdentifier() {
        return "AVERAGE";
    }

    public Value applyTo(Expression[] expressionArray) throws IllegalValueTypeException {
        double d = 0.0;
        double d2 = 0.0;
        for (Expression expression : expressionArray) {
            Value value = expression.evaluate();
            if (value.getType() == Value.Type.NUMERIC) {
                d += 1.0;
                d2 += value.toDouble();
                continue;
            }
            if (value.getType() == Value.Type.MATRIX) {
                Value[][] valueArray = value.toMatrix();
                int n = valueArray.length;
                for (int i = 0; i < n; ++i) {
                    Value[] valueArray2;
                    for (Value value2 : valueArray2 = valueArray[i]) {
                        if (value2.getType() == Value.Type.NUMERIC) {
                            d += 1.0;
                            d2 += value2.toDouble();
                            continue;
                        }
                        throw new IllegalValueTypeException(value2, Value.Type.NUMERIC);
                    }
                }
                continue;
            }
            throw new IllegalValueTypeException(value, Value.Type.NUMERIC);
        }
        return new Value(d2 / d);
    }

    public FunctionParameter[] getParameters() {
        return parameters;
    }

    public boolean isVarArg() {
        return true;
    }
}

