/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.lang;

import csheets.core.Address;
import csheets.core.Cell;
import csheets.core.Spreadsheet;
import csheets.core.Value;
import csheets.core.formula.Reference;
import csheets.core.formula.util.ExpressionVisitor;
import csheets.core.formula.util.ExpressionVisitorException;
import java.text.ParseException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellReference
implements Reference {
    private static final long serialVersionUID = -6600693551615086696L;
    private static final Pattern PATTERN = Pattern.compile("(\\$??)([a-zA-Z]+)(\\$??)(\\d+)$");
    private static final String ABSOLUTE_OPERATOR = "$";
    private Cell cell;
    private boolean columnAbsolute;
    private boolean rowAbsolute;

    public CellReference(Cell cell) {
        this(cell, false, false);
    }

    public CellReference(Cell cell, boolean bl, boolean bl2) {
        this.cell = cell;
        this.columnAbsolute = bl;
        this.rowAbsolute = bl2;
    }

    public CellReference(Spreadsheet spreadsheet, String string) throws ParseException {
        int n;
        int n2;
        Matcher matcher = PATTERN.matcher(string);
        if (matcher.matches()) {
            n2 = Integer.parseInt(matcher.group(4)) - 1;
            n = -1;
            String string2 = matcher.group(2).toUpperCase();
            for (int i = string2.length() - 1; i >= 0; --i) {
                n = (int)((double)n + (double)(string2.charAt(i) - 65 + 1) * Math.pow(26.0, string2.length() - (i + 1)));
            }
        } else {
            throw new ParseException(string, 0);
        }
        this.cell = spreadsheet.getCell(new Address(n, n2));
        this.columnAbsolute = matcher.group(1).equals(ABSOLUTE_OPERATOR);
        this.rowAbsolute = matcher.group(3).equals(ABSOLUTE_OPERATOR);
    }

    @Override
    public Value evaluate() {
        return this.cell.getValue();
    }

    @Override
    public Object accept(ExpressionVisitor expressionVisitor) throws ExpressionVisitorException {
        return expressionVisitor.visitReference(this);
    }

    public Cell getCell() {
        return this.cell;
    }

    @Override
    public SortedSet<Cell> getCells() {
        TreeSet<Cell> treeSet = new TreeSet<Cell>();
        treeSet.add(this.cell);
        return treeSet;
    }

    public boolean isColumnAbsolute() {
        return this.columnAbsolute;
    }

    public boolean isRowAbsolute() {
        return this.rowAbsolute;
    }

    @Override
    public int compareTo(Reference reference) {
        Cell cell = reference.getCells().first();
        int n = this.cell.compareTo(cell);
        if (n != 0) {
            return n;
        }
        if (reference instanceof CellReference) {
            return -1;
        }
        return -1;
    }

    public String toString() {
        String string = "";
        int n = this.cell.getAddress().getColumn();
        while (n >= 0) {
            string = (char)((char)(n % 26) + 65) + string;
            n = n / 26 - 1;
        }
        if (this.columnAbsolute) {
            string = ABSOLUTE_OPERATOR + string;
        }
        String string2 = (this.rowAbsolute ? ABSOLUTE_OPERATOR : "") + (this.cell.getAddress().getRow() + 1);
        return string + string2;
    }
}

