/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.lang;

import csheets.core.IllegalValueTypeException;
import csheets.core.Value;
import csheets.core.formula.Expression;
import csheets.core.formula.Function;
import csheets.core.formula.FunctionParameter;

public class Count
implements Function {
    public static final FunctionParameter[] parameters = new FunctionParameter[]{new FunctionParameter(Value.Type.UNDEFINED, "Expression", false, "An expression whose value is checked for type compliance")};

    public String getIdentifier() {
        return "COUNT";
    }

    public Value applyTo(Expression[] expressionArray) throws IllegalValueTypeException {
        double d = 0.0;
        for (Expression expression : expressionArray) {
            Value value = expression.evaluate();
            if (value.getType() != Value.Type.NUMERIC) continue;
            d += 1.0;
        }
        return new Value(d);
    }

    public FunctionParameter[] getParameters() {
        return parameters;
    }

    public boolean isVarArg() {
        return true;
    }
}

