/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.lang;

import csheets.core.IllegalValueTypeException;
import csheets.core.Value;
import csheets.core.formula.BinaryOperator;
import csheets.core.formula.Expression;
import csheets.core.formula.lang.DivisionByZeroException;

public class Divider
implements BinaryOperator {
    private static final long serialVersionUID = -1518353526200870461L;

    public Value applyTo(Expression expression, Expression expression2) throws IllegalValueTypeException {
        double d = expression2.evaluate().toDouble();
        if (d != 0.0) {
            return new Value(expression.evaluate().toDouble() / d);
        }
        return new Value(new DivisionByZeroException(expression2));
    }

    public String getIdentifier() {
        return "/";
    }

    public Value.Type getOperandValueType() {
        return Value.Type.NUMERIC;
    }

    public String toString() {
        return this.getIdentifier();
    }
}

