/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.lang;

import csheets.core.IllegalValueTypeException;
import csheets.core.Value;
import csheets.core.formula.Expression;
import csheets.core.formula.Function;
import csheets.core.formula.FunctionParameter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NumericFunction
implements Function {
    private Method method;

    public NumericFunction(Method method) {
        this.method = method;
    }

    public String getIdentifier() {
        return this.method.getName().toUpperCase();
    }

    public Value applyTo(Expression[] expressionArray) throws IllegalValueTypeException {
        double[] dArray = new double[expressionArray.length];
        for (int i = 0; i < expressionArray.length; ++i) {
            dArray[i] = expressionArray[i].evaluate().toDouble();
        }
        try {
            if (dArray.length == 0) {
                return new Value((Number)this.method.invoke(null, new Object[0]));
            }
            if (dArray.length == 1) {
                return new Value((Number)this.method.invoke(null, dArray[0]));
            }
            if (dArray.length == 2) {
                return new Value((Number)this.method.invoke(null, dArray[0], dArray[1]));
            }
            return new Value((Number)this.method.invoke(null, dArray[0], dArray[1], dArray[2]));
        }
        catch (IllegalAccessException illegalAccessException) {
            return new Value(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new Value(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            return new Value(invocationTargetException);
        }
    }

    public FunctionParameter[] getParameters() {
        Class<?>[] classArray = this.method.getParameterTypes();
        FunctionParameter[] functionParameterArray = new FunctionParameter[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            functionParameterArray[i] = new FunctionParameter(Value.Type.NUMERIC, "Parameter " + i, false, "Unknown");
        }
        return functionParameterArray;
    }

    public boolean isVarArg() {
        return this.method.isVarArgs();
    }
}

