/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.lang;

import csheets.core.Cell;
import csheets.core.Spreadsheet;
import csheets.core.Value;
import csheets.core.formula.BinaryOperator;
import csheets.core.formula.Expression;
import csheets.core.formula.Reference;
import csheets.core.formula.lang.CellReference;

public class RangeReference
implements BinaryOperator {
    private static final long serialVersionUID = 8527083457981256682L;

    public Value applyTo(Expression expression, Expression expression2) {
        Cell[][] cellArray;
        if (!(expression instanceof CellReference) || !(expression2 instanceof CellReference)) {
            return new Value(new IllegalArgumentException("#OPERAND!"));
        }
        CellReference cellReference = (CellReference)expression;
        CellReference cellReference2 = (CellReference)expression2;
        try {
            cellArray = this.getCells(cellReference, cellReference2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new Value(illegalArgumentException);
        }
        Value[][] valueArray = new Value[cellArray.length][cellArray[0].length];
        for (int i = 0; i < cellArray.length; ++i) {
            for (int j = 0; j < cellArray[i].length; ++j) {
                valueArray[i][j] = cellArray[i][j].getValue();
            }
        }
        return new Value(valueArray);
    }

    public Cell[][] getCells(Reference reference, Reference reference2) {
        if (!(reference instanceof CellReference) || !(reference2 instanceof CellReference)) {
            throw new IllegalArgumentException("#OPERAND!");
        }
        CellReference cellReference = (CellReference)reference;
        CellReference cellReference2 = (CellReference)reference2;
        Spreadsheet spreadsheet = cellReference.getCell().getSpreadsheet();
        if (spreadsheet != cellReference2.getCell().getSpreadsheet()) {
            throw new IllegalArgumentException("#3DREF!");
        }
        int n = cellReference.getCell().getAddress().getColumn();
        int n2 = cellReference2.getCell().getAddress().getColumn();
        int n3 = cellReference.getCell().getAddress().getRow();
        int n4 = cellReference2.getCell().getAddress().getRow();
        int n5 = n <= n2 ? n : n2;
        int n6 = n <= n2 ? n2 : n;
        int n7 = n3 <= n4 ? n3 : n4;
        int n8 = n3 <= n4 ? n4 : n3;
        Cell[][] cellArray = new Cell[n8 - n7 + 1][n6 - n5 + 1];
        for (int i = 0; i < cellArray.length; ++i) {
            for (int j = 0; j < cellArray[i].length; ++j) {
                cellArray[i][j] = spreadsheet.getCell(j + n5, i + n7);
            }
        }
        return cellArray;
    }

    public String getIdentifier() {
        return ":";
    }

    public Value.Type getOperandValueType() {
        return Value.Type.NUMERIC;
    }

    public String toString() {
        return this.getIdentifier();
    }
}

