/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.util;

import csheets.core.formula.BinaryOperation;
import csheets.core.formula.Expression;
import csheets.core.formula.FunctionCall;
import csheets.core.formula.Literal;
import csheets.core.formula.Reference;
import csheets.core.formula.UnaryOperation;
import csheets.core.formula.util.ExpressionVisitor;

public abstract class AbstractExpressionVisitor
implements ExpressionVisitor {
    public Object visitLiteral(Literal literal) {
        return literal;
    }

    public Object visitUnaryOperation(UnaryOperation unaryOperation) {
        unaryOperation.getOperand().accept(this);
        return unaryOperation;
    }

    public Object visitBinaryOperation(BinaryOperation binaryOperation) {
        binaryOperation.getLeftOperand().accept(this);
        binaryOperation.getRightOperand().accept(this);
        return binaryOperation;
    }

    public Object visitReference(Reference reference) {
        return reference;
    }

    public Object visitFunctionCall(FunctionCall functionCall) {
        for (Expression expression : functionCall.getArguments()) {
            expression.accept(this);
        }
        return functionCall;
    }
}

