/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext;

import csheets.CleanSheets;
import csheets.ext.Extension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public class ExtensionManager {
    private static final ExtensionManager instance = new ExtensionManager();
    private static final String PROPERTIES_FILENAME = "extensions.props";
    private SortedMap<String, Extension> extensionMap = new TreeMap<String, Extension>();
    private Loader loader = new Loader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtensionManager() {
        File file;
        Properties properties = new Properties();
        InputStream inputStream = CleanSheets.class.getResourceAsStream("res/extensions.props");
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                System.err.println("Could not load default extension properties from: extensions.props");
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if ((file = new File(PROPERTIES_FILENAME)).exists()) {
            inputStream = null;
        }
        try {
            inputStream = new FileInputStream(file);
            properties.load(inputStream);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object object;
            String string = (String)entry.getValue();
            URL uRL = null;
            if (string.length() > 0 && (uRL = ExtensionManager.class.getResource(string)) == null && ((File)(object = new File(string))).exists()) {
                try {
                    uRL = ((File)object).toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            object = (String)entry.getKey();
            if (uRL == null) {
                this.load((String)object);
                continue;
            }
            this.load((String)object, uRL);
        }
    }

    public static ExtensionManager getInstance() {
        return instance;
    }

    public Extension[] getExtensions() {
        Collection<Extension> collection = this.extensionMap.values();
        return collection.toArray(new Extension[collection.size()]);
    }

    public Extension getExtension(String string) {
        return (Extension)this.extensionMap.get(string);
    }

    public Extension load(String string, URL uRL) {
        this.loader.addURL(uRL);
        try {
            Class<?> clazz = Class.forName(string, true, this.loader);
            return this.load(clazz);
        }
        catch (Exception exception) {
            System.err.println("Failed to load extension class " + string + ".");
            return null;
        }
    }

    public Extension load(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return this.load(clazz);
        }
        catch (Exception exception) {
            System.err.println("Failed to load extension class " + string + ".");
            return null;
        }
    }

    public Extension load(Class clazz) {
        try {
            Extension extension = (Extension)clazz.newInstance();
            this.extensionMap.put(extension.getName(), extension);
            return extension;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Could not access extension " + clazz.getName() + ".");
            return null;
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not load extension from " + clazz.getName() + ".");
            instantiationException.printStackTrace();
            return null;
        }
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public static class Loader
    extends URLClassLoader {
        public Loader() {
            super(new URL[0], Loader.class.getClassLoader());
        }

        protected void addURL(URL uRL) {
            super.addURL(uRL);
        }
    }
}

