/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.assertion;

import csheets.core.Cell;
import csheets.core.IllegalValueTypeException;
import csheets.core.formula.BinaryOperation;
import csheets.core.formula.Expression;
import csheets.core.formula.FunctionCall;
import csheets.core.formula.Literal;
import csheets.core.formula.Reference;
import csheets.core.formula.UnaryOperation;
import csheets.core.formula.lang.Adder;
import csheets.core.formula.lang.Divider;
import csheets.core.formula.lang.Exponentiator;
import csheets.core.formula.lang.Multiplier;
import csheets.core.formula.lang.Negator;
import csheets.core.formula.lang.Subtracter;
import csheets.core.formula.util.ExpressionVisitor;
import csheets.ext.assertion.AssertableCell;
import csheets.ext.assertion.Assertion;
import csheets.ext.assertion.AssertionArithmeticException;
import csheets.ext.assertion.Interval;
import csheets.ext.assertion.MathException;
import csheets.ext.assertion.MultiInterval;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class AssertionArithmeticVisitor
implements ExpressionVisitor {
    private Stack<List<MultiInterval>> intervalStack = new Stack();
    private Set<Cell> referencedCells = new TreeSet<Cell>();

    public MultiInterval getResult(Expression expression) throws AssertionArithmeticException, MathException {
        this.intervalStack.clear();
        this.referencedCells.clear();
        expression.accept(this);
        if (this.intervalStack == null || this.intervalStack.size() != 1) {
            throw new AssertionArithmeticException("Result from assertion arithmetics was errenous. Multiple results found. Error in formula?");
        }
        List<MultiInterval> list = this.intervalStack.peek();
        if (list.size() != 1) {
            throw new AssertionArithmeticException("Result from assertion arithmetics was errenous. Single result with multiple intervals. Error in formula?");
        }
        return list.get(0);
    }

    public Object visitBinaryOperation(BinaryOperation binaryOperation) throws AssertionArithmeticException, MathException {
        Object o = binaryOperation.getOperator();
        binaryOperation.getLeftOperand().accept(this);
        List<MultiInterval> list = this.intervalStack.pop();
        binaryOperation.getRightOperand().accept(this);
        List<MultiInterval> list2 = this.intervalStack.pop();
        if (list.size() != 1 || list2.size() != 1) {
            throw new AssertionArithmeticException("No supported binary operator exist for ranges.");
        }
        MultiInterval multiInterval = list.get(0);
        MultiInterval multiInterval2 = list2.get(0);
        ArrayList<MultiInterval> arrayList = new ArrayList<MultiInterval>(1);
        if (o instanceof Multiplier) {
            arrayList.add(MultiInterval.mul(multiInterval, multiInterval2));
            this.intervalStack.push(arrayList);
        } else if (o instanceof Adder) {
            arrayList.add(MultiInterval.add(multiInterval, multiInterval2));
            this.intervalStack.push(arrayList);
        } else if (o instanceof Subtracter) {
            arrayList.add(MultiInterval.sub(multiInterval, multiInterval2));
            this.intervalStack.push(arrayList);
        } else if (o instanceof Divider) {
            arrayList.add(MultiInterval.div(multiInterval, multiInterval2));
            this.intervalStack.push(arrayList);
        } else if (o instanceof Exponentiator) {
            arrayList.add(MultiInterval.pow(multiInterval, multiInterval2));
            this.intervalStack.push(arrayList);
        } else {
            throw new AssertionArithmeticException("Unsupported binary operator " + o + " found.");
        }
        return binaryOperation;
    }

    public Object visitFunctionCall(FunctionCall functionCall) throws AssertionArithmeticException {
        ArrayList<MultiInterval> arrayList = new ArrayList<MultiInterval>();
        for (Expression expression : functionCall.getArguments()) {
            expression.accept(this);
            List<MultiInterval> list = this.intervalStack.pop();
            arrayList.addAll(list);
        }
        ArrayList arrayList2 = new ArrayList(1);
        String string = functionCall.getFunction().getIdentifier().toUpperCase();
        if (string.equals("RAND")) {
            arrayList2.add(MultiInterval.rand());
        } else if (string.equals("COS")) {
            arrayList2.add(MultiInterval.cos((MultiInterval)arrayList.get(0)));
        } else if (string.equals("SIN")) {
            arrayList2.add(MultiInterval.sin((MultiInterval)arrayList.get(0)));
        } else if (string.equals("TAN")) {
            arrayList2.add(MultiInterval.tan((MultiInterval)arrayList.get(0)));
        } else if (string.equals("ABS")) {
            arrayList2.add(MultiInterval.abs((MultiInterval)arrayList.get(0)));
        } else if (string.equals("INTEGER")) {
            arrayList2.add(MultiInterval.toInt((MultiInterval)arrayList.get(0)));
        } else if (string.equals("SQRT")) {
            arrayList2.add(MultiInterval.sqrt((MultiInterval)arrayList.get(0)));
        } else if (string.equals("EXP")) {
            arrayList2.add(MultiInterval.exp((MultiInterval)arrayList.get(0)));
        } else if (string.equals("LOG")) {
            arrayList2.add(MultiInterval.log10((MultiInterval)arrayList.get(0)));
        } else if (string.equals("LN")) {
            arrayList2.add(MultiInterval.ln((MultiInterval)arrayList.get(0)));
        } else if (string.equals("FACT")) {
            arrayList2.add(MultiInterval.fact((MultiInterval)arrayList.get(0)));
        } else if (string.equals("SUM")) {
            arrayList2.add(MultiInterval.sum(arrayList));
        } else if (string.equals("AVG")) {
            arrayList2.add(MultiInterval.avg(arrayList));
        } else {
            throw new AssertionArithmeticException("Call to unsupported function " + functionCall.getFunction() + " found.");
        }
        this.intervalStack.push(arrayList2);
        return functionCall;
    }

    public Object visitLiteral(Literal literal) throws AssertionArithmeticException {
        try {
            double d = literal.getValue().toDouble();
            MultiInterval multiInterval = new MultiInterval();
            multiInterval.include(new Interval(d));
            ArrayList<MultiInterval> arrayList = new ArrayList<MultiInterval>(1);
            arrayList.add(multiInterval);
            this.intervalStack.push(arrayList);
        }
        catch (IllegalValueTypeException illegalValueTypeException) {
            throw new AssertionArithmeticException("Non-numeric value found in formula.");
        }
        return literal;
    }

    public Object visitReference(Reference reference) throws AssertionArithmeticException {
        ArrayList<MultiInterval> arrayList = new ArrayList<MultiInterval>(1);
        for (Cell cell : reference.getCells()) {
            AssertableCell assertableCell = (AssertableCell)cell.getExtension("Assertions");
            this.checkReference(assertableCell);
            if (!assertableCell.isAsserted()) {
                throw new AssertionArithmeticException("Referenced cell " + assertableCell + " does not have an assertion associated with it.");
            }
            Assertion assertion = assertableCell.getSGAssertion();
            if (assertion == null) {
                assertion = assertableCell.getUSAssertion();
            }
            arrayList.add(assertion.getMultiInterval());
        }
        this.intervalStack.push(arrayList);
        return reference;
    }

    public Object visitUnaryOperation(UnaryOperation unaryOperation) throws AssertionArithmeticException {
        unaryOperation.getOperand().accept(this);
        List<MultiInterval> list = this.intervalStack.pop();
        if (list.size() != 1) {
            throw new AssertionArithmeticException("No supported unary operator exist for ranges.");
        }
        MultiInterval multiInterval = list.get(0);
        Object o = unaryOperation.getOperator();
        if (!(o instanceof Negator)) {
            throw new AssertionArithmeticException("Unsupported unary operator " + o + " found.");
        }
        ArrayList<MultiInterval> arrayList = new ArrayList<MultiInterval>(1);
        arrayList.add(MultiInterval.negate(multiInterval));
        this.intervalStack.push(arrayList);
        return unaryOperation;
    }

    private void checkReference(Cell cell) {
        if (this.referencedCells.contains(cell)) {
            throw new AssertionArithmeticException("Multiple references to the same cell found in formula. Cannot generate assertion.");
        }
        this.referencedCells.add(cell);
        for (Cell cell2 : cell.getPrecedents()) {
            this.checkReference(cell2);
        }
    }
}

