/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.assertion;

import antlr.CharStreamException;
import antlr.MismatchedCharException;
import antlr.MismatchedTokenException;
import antlr.NoViableAltException;
import antlr.NoViableAltForCharException;
import antlr.RecognitionException;
import antlr.TokenStreamException;

public class AssertionException
extends Exception {
    static final long serialVersionUID = 2950555036431465919L;
    private int line;
    private int column;
    private String errorMsg;

    public AssertionException(int n, int n2, String string) {
        this.line = n;
        this.column = n2;
        this.errorMsg = string;
    }

    public AssertionException(String string) {
        this.column = -1;
        this.line = -1;
        this.errorMsg = string;
    }

    public AssertionException(RecognitionException recognitionException) {
        this.line = recognitionException.getLine();
        this.column = recognitionException.getColumn();
        this.errorMsg = recognitionException.toString();
    }

    public AssertionException(TokenStreamException tokenStreamException) {
        this.line = -1;
        this.column = -1;
        this.errorMsg = tokenStreamException.toString();
    }

    public AssertionException(CharStreamException charStreamException) {
        this.line = -1;
        this.column = -1;
        this.errorMsg = charStreamException.toString();
    }

    public AssertionException(MismatchedCharException mismatchedCharException) {
        this.line = mismatchedCharException.getLine();
        this.column = mismatchedCharException.getColumn();
        this.errorMsg = mismatchedCharException.getMessage();
    }

    public AssertionException(MismatchedTokenException mismatchedTokenException) {
        this.line = mismatchedTokenException.getLine();
        this.column = mismatchedTokenException.getColumn();
        this.errorMsg = mismatchedTokenException.getMessage();
    }

    public AssertionException(NoViableAltException noViableAltException) {
        this.line = noViableAltException.getLine();
        this.column = noViableAltException.getColumn();
        this.errorMsg = noViableAltException.getMessage();
    }

    public AssertionException(NoViableAltForCharException noViableAltForCharException) {
        this.line = noViableAltForCharException.getLine();
        this.column = noViableAltForCharException.getColumn();
        this.errorMsg = noViableAltForCharException.getMessage();
    }

    public boolean hasLocationInfo() {
        return this.column != -1;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getMessage() {
        return this.errorMsg;
    }

    public String toString() {
        String string = "Error parsing assertion:\n";
        if (this.hasLocationInfo()) {
            string = string + "col " + this.getColumn() + ": ";
        }
        string = string + this.getMessage();
        return string;
    }
}

