/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.assertion;

import csheets.ext.assertion.ConstMultiIntervalIterator;
import csheets.ext.assertion.Interval;
import csheets.ext.assertion.MathException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiInterval
implements Iterable<Interval>,
Serializable {
    private static final long serialVersionUID = 3311313307922046224L;
    private TreeSet<Interval> intervalSet = new TreeSet();

    public void include(Interval interval) {
        if (this.intervalSet.isEmpty()) {
            this.intervalSet.add(interval);
            return;
        }
        Iterator<Interval> iterator = this.intervalSet.iterator();
        while (iterator.hasNext()) {
            Interval interval2 = iterator.next();
            Interval interval3 = Interval.union(interval2, interval);
            if (interval3 == null) continue;
            iterator.remove();
            this.include(interval3);
            return;
        }
        this.intervalSet.add(interval);
    }

    public void exclude(Interval interval) {
        if (this.intervalSet.isEmpty()) {
            this.intervalSet.add(new Interval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, false, false));
        }
        TreeSet<Interval> treeSet = new TreeSet<Interval>();
        for (Interval interval2 : this.intervalSet) {
            if (interval2.intersects(interval)) {
                if (interval2.getLowerLimit() < interval.getLowerLimit() || interval2.getLowerLimit() == interval.getLowerLimit() && interval2.isLowerLimitClosed() && !interval.isLowerLimitClosed()) {
                    treeSet.add(new Interval(interval2.getLowerLimit(), interval.getLowerLimit(), interval2.isLowerLimitClosed(), !interval.isLowerLimitClosed()));
                }
                if (!(interval2.getUpperLimit() > interval.getUpperLimit()) && (interval2.getUpperLimit() != interval.getUpperLimit() || !interval2.isUpperLimitClosed() || interval.isUpperLimitClosed())) continue;
                treeSet.add(new Interval(interval.getUpperLimit(), interval2.getUpperLimit(), !interval.isUpperLimitClosed(), interval2.isUpperLimitClosed()));
                continue;
            }
            treeSet.add(interval2);
        }
        this.intervalSet = treeSet;
    }

    public boolean contains(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return false;
        }
        for (Interval interval : this.intervalSet) {
            if (interval.contains(d)) {
                return true;
            }
            if (!(interval.getUpperLimit() > d)) continue;
            return false;
        }
        return false;
    }

    public static MultiInterval negate(MultiInterval multiInterval) {
        MultiInterval multiInterval2 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            multiInterval2.include(Interval.negate(interval));
        }
        return multiInterval2;
    }

    public static MultiInterval add(MultiInterval multiInterval, MultiInterval multiInterval2) {
        MultiInterval multiInterval3 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            for (Interval interval2 : multiInterval2.intervalSet) {
                multiInterval3.include(Interval.add(interval, interval2));
            }
        }
        return multiInterval3;
    }

    public static MultiInterval sub(MultiInterval multiInterval, MultiInterval multiInterval2) {
        MultiInterval multiInterval3 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            for (Interval interval2 : multiInterval2.intervalSet) {
                multiInterval3.include(Interval.sub(interval, interval2));
            }
        }
        return multiInterval3;
    }

    public static MultiInterval mul(MultiInterval multiInterval, MultiInterval multiInterval2) {
        MultiInterval multiInterval3 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            for (Interval interval2 : multiInterval2.intervalSet) {
                multiInterval3.include(Interval.mul(interval, interval2));
            }
        }
        return multiInterval3;
    }

    public static MultiInterval div(MultiInterval multiInterval, MultiInterval multiInterval2) throws MathException {
        MultiInterval multiInterval3 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            for (Interval interval2 : multiInterval2.intervalSet) {
                multiInterval3.include(Interval.div(interval, interval2));
            }
        }
        return multiInterval3;
    }

    public static MultiInterval pow(MultiInterval multiInterval, MultiInterval multiInterval2) throws MathException {
        MultiInterval multiInterval3 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            for (Interval interval2 : multiInterval2.intervalSet) {
                multiInterval3.include(Interval.pow(interval, interval2));
            }
        }
        return multiInterval3;
    }

    public static MultiInterval cos(MultiInterval multiInterval) {
        MultiInterval multiInterval2 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            multiInterval2.include(Interval.cos(interval));
        }
        return multiInterval2;
    }

    public static MultiInterval sin(MultiInterval multiInterval) {
        MultiInterval multiInterval2 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            multiInterval2.include(Interval.sin(interval));
        }
        return multiInterval2;
    }

    public static MultiInterval tan(MultiInterval multiInterval) {
        MultiInterval multiInterval2 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            multiInterval2.include(Interval.tan(interval));
        }
        return multiInterval2;
    }

    public static MultiInterval ln(MultiInterval multiInterval) throws MathException {
        MultiInterval multiInterval2 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            multiInterval2.include(Interval.ln(interval));
        }
        return multiInterval2;
    }

    public static MultiInterval log10(MultiInterval multiInterval) throws MathException {
        MultiInterval multiInterval2 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            multiInterval2.include(Interval.log10(interval));
        }
        return multiInterval2;
    }

    public static MultiInterval exp(MultiInterval multiInterval) {
        MultiInterval multiInterval2 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            multiInterval2.include(Interval.exp(interval));
        }
        return multiInterval2;
    }

    public static MultiInterval sqrt(MultiInterval multiInterval) throws MathException {
        MultiInterval multiInterval2 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            multiInterval2.include(Interval.sqrt(interval));
        }
        return multiInterval2;
    }

    public static MultiInterval toInt(MultiInterval multiInterval) {
        MultiInterval multiInterval2 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            multiInterval2.include(Interval.toInt(interval));
        }
        return multiInterval2;
    }

    public static MultiInterval abs(MultiInterval multiInterval) {
        MultiInterval multiInterval2 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            multiInterval2.include(Interval.abs(interval));
        }
        return multiInterval2;
    }

    public static MultiInterval rand() {
        MultiInterval multiInterval = new MultiInterval();
        multiInterval.include(Interval.rand());
        return multiInterval;
    }

    public static MultiInterval fact(MultiInterval multiInterval) throws MathException {
        MultiInterval multiInterval2 = new MultiInterval();
        for (Interval interval : multiInterval.intervalSet) {
            multiInterval2.include(Interval.fact(interval));
        }
        return multiInterval2;
    }

    public static MultiInterval sum(List<MultiInterval> list) {
        MultiInterval multiInterval = new MultiInterval();
        Iterator<MultiInterval> iterator = list.iterator();
        if (iterator.hasNext()) {
            multiInterval = iterator.next().clone();
        }
        while (iterator.hasNext()) {
            multiInterval = MultiInterval.add(multiInterval, iterator.next());
        }
        return multiInterval;
    }

    public static MultiInterval avg(List<MultiInterval> list) {
        MultiInterval multiInterval = new MultiInterval();
        multiInterval.include(new Interval(list.size()));
        MultiInterval multiInterval2 = MultiInterval.sum(list);
        MultiInterval multiInterval3 = new MultiInterval();
        try {
            multiInterval3 = MultiInterval.div(multiInterval2, multiInterval);
        }
        catch (MathException mathException) {
            mathException.printStackTrace();
        }
        return multiInterval3;
    }

    @Override
    public Iterator<Interval> iterator() {
        return new ConstMultiIntervalIterator(this.intervalSet.iterator());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof MultiInterval)) {
            return false;
        }
        MultiInterval multiInterval = (MultiInterval)object;
        return this.intervalSet.equals(multiInterval.intervalSet);
    }

    public MultiInterval clone() {
        MultiInterval multiInterval = new MultiInterval();
        for (Interval interval : this.intervalSet) {
            multiInterval.include(interval);
        }
        return multiInterval;
    }

    public String toString() {
        String string = "";
        Iterator<Interval> iterator = this.intervalSet.iterator();
        while (iterator.hasNext()) {
            Interval interval = iterator.next();
            string = string + interval.toString();
            if (!iterator.hasNext()) continue;
            string = string + " or ";
        }
        return string;
    }
}

