/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.assertion.ui;

import csheets.core.Cell;
import csheets.ext.assertion.AssertableCell;
import csheets.ext.assertion.AssertableCellListener;
import csheets.ext.assertion.Assertion;
import csheets.ext.assertion.AssertionExtension;
import csheets.ext.assertion.SGAssertion;
import csheets.ext.assertion.USAssertion;
import csheets.ui.ctrl.SelectionEvent;
import csheets.ui.ctrl.SelectionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class AssertionToolBar
extends JToolBar
implements SelectionListener,
AssertableCellListener {
    private JTextField usAssertion;
    private JTextField sgAssertion;
    private Icon redIcon;
    private Icon yellowIcon;
    private Icon greenIcon;
    private JLabel lightLabelAssertion;

    public AssertionToolBar() {
        this.setName("Assertions");
        this.redIcon = new ImageIcon(AssertionExtension.class.getResource("res/img/light_red.gif"), "Red light");
        this.yellowIcon = new ImageIcon(AssertionExtension.class.getResource("res/img/light_yellow.gif"), "Yellow light");
        this.greenIcon = new ImageIcon(AssertionExtension.class.getResource("res/img/light_green.gif"), "Green light");
        this.lightLabelAssertion = new JLabel(this.yellowIcon);
        this.usAssertion = new JTextField(5);
        this.usAssertion.setEditable(false);
        this.sgAssertion = new JTextField(5);
        this.sgAssertion.setEditable(false);
        this.add(new JLabel(new ImageIcon(AssertionExtension.class.getResource("res/img/logo.gif"))));
        this.addSeparator();
        this.add(this.lightLabelAssertion);
        this.addSeparator();
        this.add(this.usAssertion);
        this.addSeparator();
        this.add(new JLabel("="));
        this.addSeparator();
        this.add(this.sgAssertion);
    }

    private void setUSAssertionText(String string) {
        this.usAssertion.setText(string);
    }

    private void setSGAssertionText(String string) {
        this.sgAssertion.setText(string);
    }

    private void setAssertionLamp(int n) {
        switch (n) {
            case 1: {
                this.lightLabelAssertion.setIcon(this.greenIcon);
                break;
            }
            case 2: {
                this.lightLabelAssertion.setIcon(this.yellowIcon);
                break;
            }
            case 3: {
                this.lightLabelAssertion.setIcon(this.redIcon);
                break;
            }
            default: {
                this.lightLabelAssertion.setIcon(this.yellowIcon);
            }
        }
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        Cell cell = selectionEvent.getCell();
        if (cell != null) {
            AssertableCell assertableCell = (AssertableCell)cell.getExtension("Assertions");
            assertableCell.addAssertableCellListener(this);
            this.assertionsChanged(assertableCell);
        } else {
            this.setAssertionLamp(2);
        }
        if (selectionEvent.getPreviousCell() != null) {
            ((AssertableCell)selectionEvent.getPreviousCell().getExtension("Assertions")).removeAssertableCellListener(this);
        }
    }

    public void assertionsChanged(AssertableCell assertableCell) {
        USAssertion uSAssertion = assertableCell.getUSAssertion();
        SGAssertion sGAssertion = assertableCell.getSGAssertion();
        if (assertableCell.hasAssertionError()) {
            if (assertableCell.assertAssertions() == Assertion.ComparisonResult.OK && assertableCell.assertAny() == Assertion.Result.NO_DATA) {
                this.setAssertionLamp(2);
            } else {
                this.setAssertionLamp(3);
            }
        } else if (assertableCell.isAsserted()) {
            this.setAssertionLamp(1);
        } else {
            this.setAssertionLamp(2);
        }
        if (uSAssertion != null) {
            this.setUSAssertionText(((Assertion)uSAssertion).toString());
        } else {
            this.setUSAssertionText("");
        }
        if (sGAssertion != null) {
            this.setSGAssertionText(sGAssertion.toString());
        } else {
            this.setSGAssertionText("");
        }
    }
}

