/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.style.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooser
extends JComponent {
    private static final Integer[] SIZES = new Integer[]{4, 6, 8, 9, 10, 12, 14, 16, 18, 20, 22, 24, 28, 32, 36, 40, 48, 64};
    private static final Integer DEFAULT_SIZE = 10;
    private JList familyList;
    private JList sizeList;
    private JCheckBox boldBox = new JCheckBox("Bold");
    private JCheckBox italicBox = new JCheckBox("Italic");
    private JLabel previewLabel = new JLabel();

    public FontChooser() {
        this(null);
    }

    public FontChooser(Font font) {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.familyList = new JList<String>(stringArray);
        this.familyList.setSelectionMode(0);
        this.familyList.setVisibleRowCount(10);
        this.sizeList = new JList<Integer>(SIZES);
        this.sizeList.setSelectionMode(0);
        this.sizeList.setVisibleRowCount(6);
        ((DefaultListCellRenderer)this.sizeList.getCellRenderer()).setHorizontalAlignment(4);
        this.previewLabel.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.previewLabel.setHorizontalAlignment(0);
        this.previewLabel.setPreferredSize(new Dimension(this.getPreferredSize().width, 80));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(new JScrollPane(this.familyList));
        jPanel.setBorder(BorderFactory.createTitledBorder("Family"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(new JScrollPane(this.sizeList));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Size"));
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        jPanel3.add(this.boldBox);
        jPanel3.add(this.italicBox);
        jPanel3.setBorder(BorderFactory.createTitledBorder("Style"));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "South");
        PreviewLabelUpdater previewLabelUpdater = new PreviewLabelUpdater();
        this.familyList.addListSelectionListener(previewLabelUpdater);
        this.sizeList.addListSelectionListener(previewLabelUpdater);
        this.boldBox.addActionListener(previewLabelUpdater);
        this.italicBox.addActionListener(previewLabelUpdater);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel4, "East");
        this.add((Component)this.previewLabel, "South");
        if (font != null) {
            this.setSelectedFont(font);
        } else {
            this.setSelectedFont(new Font(stringArray[0], 0, 12));
        }
    }

    public static Font showDialog(Component component, String string, Font font) {
        FontChooser fontChooser = new FontChooser(font);
        int n = JOptionPane.showConfirmDialog(component, fontChooser, string, 2, -1, null);
        if (n == 0) {
            return fontChooser.getSelectedFont();
        }
        return null;
    }

    public Font getSelectedFont() {
        return new Font((String)this.familyList.getSelectedValue(), (this.boldBox.isSelected() ? 1 : 0) | (this.italicBox.isSelected() ? 2 : 0), this.sizeList.isSelectionEmpty() ? DEFAULT_SIZE : (Integer)this.sizeList.getSelectedValue());
    }

    public void setSelectedFont(Font font) {
        this.familyList.setSelectedValue(font.getFamily(), true);
        this.sizeList.setSelectedValue(font.getSize(), true);
        this.boldBox.setSelected(font.isBold());
        this.italicBox.setSelected(font.isItalic());
    }

    private class PreviewLabelUpdater
    implements ListSelectionListener,
    ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FontChooser.this.previewLabel.setFont(FontChooser.this.getSelectedFont());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                Font font = FontChooser.this.getSelectedFont();
                FontChooser.this.previewLabel.setFont(font);
                FontChooser.this.previewLabel.setText(font.getName());
            }
        }
    }
}

