/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.style.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FormatChooser
extends JPanel {
    private static final int HISTORY_SIZE = 50;
    private static final Color ERROR_COLOR = Color.RED;
    private Format format;
    private Object value;
    private final JComboBox choices = new JComboBox();
    private final JLabel previewLabel = new JLabel();

    public FormatChooser(DateFormat dateFormat, Date date) {
        this(FormatChooser.getPatterns(dateFormat));
        this.value = date;
        this.setFormat(dateFormat);
    }

    public FormatChooser(NumberFormat numberFormat, Number number) {
        this(FormatChooser.getPatterns(numberFormat));
        this.value = number;
        this.setFormat(numberFormat);
    }

    private FormatChooser(String[] stringArray) {
        if (stringArray != null) {
            this.choices.setModel(new DefaultComboBoxModel<String>(stringArray));
        }
        this.choices.setEditable(true);
        this.choices.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatChooser.this.applyPattern(false);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.choices);
        jPanel.setBorder(BorderFactory.createTitledBorder("Format"));
        this.previewLabel.setHorizontalAlignment(0);
        this.previewLabel.setPreferredSize(new Dimension(70, 50));
        this.previewLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Preview"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)jPanel, "Center");
        this.add((Component)this.previewLabel, "South");
        this.choices.getEditor().getEditorComponent().requestFocus();
    }

    private static synchronized String[] getPatterns(Format format) {
        Locale locale = Locale.getDefault();
        if (format instanceof NumberFormat) {
            return FormatChooser.getNumberPatterns(locale);
        }
        if (format instanceof DateFormat) {
            return FormatChooser.getDatePatterns(locale);
        }
        return null;
    }

    private static String[] getNumberPatterns(Locale locale) {
        NumberFormat[] numberFormatArray = new NumberFormat[]{NumberFormat.getInstance(locale), NumberFormat.getNumberInstance(locale), NumberFormat.getPercentInstance(locale), NumberFormat.getCurrencyInstance(locale)};
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (int i = 0; i < numberFormatArray.length; ++i) {
            if (!(numberFormatArray[i] instanceof DecimalFormat)) continue;
            int n = -1;
            if (i == 1) {
                n = 4;
            } else if (i == 2) {
                n = 2;
            }
            DecimalFormat decimalFormat = (DecimalFormat)numberFormatArray[i];
            linkedHashSet.add(decimalFormat.toLocalizedPattern());
            for (int j = 0; j <= n; ++j) {
                decimalFormat.setMinimumFractionDigits(j);
                decimalFormat.setMaximumFractionDigits(j);
                linkedHashSet.add(decimalFormat.toLocalizedPattern());
            }
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private static String[] getDatePatterns(Locale locale) {
        LinkedHashSet<DateFormat> linkedHashSet = new LinkedHashSet<DateFormat>();
        int[] nArray = new int[]{3, 2, 1, 0};
        for (int n : nArray) {
            linkedHashSet.add(DateFormat.getDateInstance(n, locale));
            linkedHashSet.add(DateFormat.getTimeInstance(n, locale));
            for (int n2 : nArray) {
                linkedHashSet.add(DateFormat.getDateTimeInstance(n, n2, locale));
            }
        }
        Object object = new TreeSet();
        for (DateFormat dateFormat : linkedHashSet) {
            if (!(dateFormat instanceof SimpleDateFormat)) continue;
            object.add(((SimpleDateFormat)dateFormat).toLocalizedPattern());
        }
        return object.toArray(new String[object.size()]);
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) throws IllegalArgumentException {
        Format format2 = this.format;
        this.format = format;
        try {
            this.update();
        }
        catch (IllegalStateException illegalStateException) {
            this.format = format2;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(illegalStateException.getLocalizedMessage());
            illegalArgumentException.initCause(illegalStateException);
            throw illegalArgumentException;
        }
        this.firePropertyChange("format", format2, format);
    }

    public String getPattern() throws IllegalStateException {
        if (this.format instanceof DecimalFormat) {
            return ((DecimalFormat)this.format).toLocalizedPattern();
        }
        if (this.format instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)this.format).toLocalizedPattern();
        }
        throw new IllegalStateException();
    }

    public void setPattern(String string) throws IllegalStateException, IllegalArgumentException {
        if (this.format instanceof DecimalFormat) {
            ((DecimalFormat)this.format).applyLocalizedPattern(string);
        } else if (this.format instanceof SimpleDateFormat) {
            ((SimpleDateFormat)this.format).applyLocalizedPattern(string);
        } else {
            throw new IllegalStateException();
        }
        this.update();
    }

    private void update() {
        this.choices.setSelectedItem(this.getPattern());
        try {
            this.previewLabel.setText(this.value != null ? this.format.format(this.value) : null);
            this.previewLabel.setForeground(this.getForeground());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.previewLabel.setText(illegalArgumentException.getLocalizedMessage());
            this.previewLabel.setForeground(ERROR_COLOR);
        }
    }

    private boolean applyPattern(boolean bl) {
        String string = this.choices.getSelectedItem().toString();
        if (string.trim().length() == 0) {
            this.update();
            return false;
        }
        try {
            this.setPattern(string);
        }
        catch (RuntimeException runtimeException) {
            this.previewLabel.setText(runtimeException.getLocalizedMessage());
            this.previewLabel.setForeground(ERROR_COLOR);
            return false;
        }
        if (bl) {
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.choices.getModel();
            int n = defaultComboBoxModel.getIndexOf(string = this.choices.getSelectedItem().toString());
            if (n > 0) {
                defaultComboBoxModel.removeElementAt(n);
            }
            if (n != 0) {
                defaultComboBoxModel.insertElementAt(string, 0);
            }
            int n2 = defaultComboBoxModel.getSize();
            while (n2 > 50) {
                defaultComboBoxModel.removeElementAt(n2 - 1);
            }
            if (n2 != 0) {
                this.choices.setSelectedIndex(0);
            }
        }
        return true;
    }

    public Format showDialog(Component component, String string) {
        int n = JOptionPane.showConfirmDialog(component, this, string, 2, -1, null);
        if (n == 0 && this.applyPattern(true)) {
            return this.getFormat();
        }
        return null;
    }
}

