/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.test;

import csheets.core.Cell;
import csheets.core.Value;
import csheets.core.formula.Expression;
import csheets.core.formula.Literal;
import csheets.core.formula.Reference;
import csheets.core.formula.lang.CellReference;
import csheets.core.formula.lang.RangeReference;
import csheets.core.formula.lang.ReferenceOperation;
import csheets.core.formula.util.ExpressionBuilder;
import csheets.core.formula.util.ExpressionVisitorException;
import csheets.ext.test.TestCaseParam;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseBuilder
extends ExpressionBuilder {
    private Set<TestCaseParam> params;

    public TestCaseBuilder(Set<TestCaseParam> set) {
        this.params = set;
    }

    @Override
    public Expression visitReference(Reference reference) {
        if (reference instanceof CellReference) {
            CellReference cellReference = (CellReference)reference;
            for (TestCaseParam testCaseParam : this.params) {
                if (!cellReference.getCell().equals(testCaseParam.getCell().getDelegate())) continue;
                return new Literal(testCaseParam.getValue());
            }
            throw new ExpressionVisitorException();
        }
        ReferenceOperation referenceOperation = (ReferenceOperation)reference;
        if (referenceOperation.getOperator() instanceof RangeReference) {
            RangeReference rangeReference = referenceOperation.getOperator();
            Cell[][] cellArray = rangeReference.getCells(referenceOperation.getLeftOperand(), referenceOperation.getRightOperand());
            Value[][] valueArray = new Value[cellArray.length][cellArray[0].length];
            for (int i = 0; i < cellArray.length; ++i) {
                for (int j = 0; j < cellArray[i].length; ++j) {
                    for (TestCaseParam testCaseParam : this.params) {
                        if (!cellArray[i][j].equals(testCaseParam.getCell().getDelegate())) continue;
                        valueArray[i][j] = testCaseParam.getValue();
                    }
                    if (valueArray[i][j] != null) continue;
                    throw new ExpressionVisitorException();
                }
            }
            return new Literal(new Value(valueArray));
        }
        return super.visitReference(reference);
    }
}

