/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.test.ui;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TestTable
extends JTable {
    public static final int COLUMN_MARGIN = 10;
    public static final int MINIMUM_COLUMN_WIDTH = 30;
    private DefaultTableColumnModel columnModel = (DefaultTableColumnModel)this.getColumnModel();

    public TestTable(TableModel tableModel) {
        super(tableModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
        this.setAutoResizeMode(0);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.packColumns();
    }

    public void packColumns() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.packColumn(i);
        }
    }

    public void packColumn(int n) {
        TableColumn tableColumn = this.columnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, 0, 0);
        int n2 = component.getPreferredSize().width;
        for (int i = 0; i < this.getRowCount(); ++i) {
            tableCellRenderer = this.getCellRenderer(i, n);
            component = tableCellRenderer.getTableCellRendererComponent(this, this.getValueAt(i, n), false, false, i, n);
            n2 = Math.max(n2, component.getPreferredSize().width);
        }
        if ((n2 += 20) > 30) {
            tableColumn.setPreferredWidth(n2);
        } else {
            tableColumn.setPreferredWidth(30);
        }
    }
}

