/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui;

import csheets.CleanSheets;
import csheets.SpreadsheetAppEvent;
import csheets.SpreadsheetAppListener;
import csheets.ui.ctrl.OpenAction;
import csheets.ui.ctrl.UIController;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class ReopenMenu
extends JMenu
implements SpreadsheetAppListener {
    private CleanSheets app;
    private int maximumItems = 10;
    private Properties props;
    private int nonReopenItems;
    private UIController uiController;

    public ReopenMenu(CleanSheets cleanSheets, UIController uIController) {
        super("Reopen");
        this.app = cleanSheets;
        this.uiController = uIController;
        this.props = cleanSheets.getUserProperties();
        cleanSheets.addSpreadsheetAppListener(this);
        this.setMnemonic(82);
        this.setIcon(new ImageIcon(CleanSheets.class.getResource("res/img/reopen.gif")));
        if (this.props != null) {
            String string;
            int n = 0;
            while ((string = this.props.getProperty("recentfile" + n)) != null) {
                File file = new File(string);
                if (file.exists()) {
                    this.addReopenItem(file, false);
                }
                ++n;
            }
        }
        this.addSeparator();
        this.add(new RemoveObsoleteAction());
        this.add(new RemoveAllAction());
        this.nonReopenItems = 3;
    }

    public JMenuItem addReopenItem(File file) {
        return this.addReopenItem(file, true);
    }

    private JMenuItem addReopenItem(File file, boolean bl) {
        Component[] componentArray = this.getMenuComponents();
        for (int i = 0; i < componentArray.length && !(componentArray[i] instanceof JSeparator); ++i) {
            JMenuItem jMenuItem = (JMenuItem)componentArray[i];
            if (!file.getAbsolutePath().equals(jMenuItem.getText())) continue;
            this.remove(jMenuItem);
        }
        JMenuItem jMenuItem = this.insert(new ReopenAction(this.app, this.uiController, file), 0);
        while (this.getMenuComponentCount() - this.nonReopenItems > this.maximumItems) {
            this.remove(this.maximumItems);
        }
        if (bl) {
            this.updateProperties();
        }
        return jMenuItem;
    }

    public void removeObsolete() {
        Component[] componentArray = this.getMenuComponents();
        for (int i = 0; i < componentArray.length && !(componentArray[i] instanceof JSeparator); ++i) {
            JMenuItem jMenuItem = (JMenuItem)componentArray[i];
            if (new File(jMenuItem.getText()).exists()) continue;
            this.remove(jMenuItem);
        }
        this.updateProperties();
    }

    public void removeAll() {
        Component[] componentArray = this.getMenuComponents();
        for (int i = 0; i < componentArray.length && !(componentArray[i] instanceof JSeparator); ++i) {
            this.remove(componentArray[i]);
        }
        this.updateProperties();
    }

    public void setMaximumItems(int n) {
        this.maximumItems = n;
    }

    private void updateProperties() {
        if (this.props != null) {
            int n;
            int n2 = this.getMenuComponentCount() - this.nonReopenItems;
            for (n = 0; n < n2; ++n) {
                this.props.setProperty("recentfile" + (n2 - n - 1), ((JMenuItem)this.getMenuComponent(n)).getText());
            }
            while (this.props.getProperty("recentfile" + n) != null) {
                this.props.remove("recentfile" + n);
                ++n;
            }
        }
    }

    public void workbookCreated(SpreadsheetAppEvent spreadsheetAppEvent) {
    }

    public void workbookLoaded(SpreadsheetAppEvent spreadsheetAppEvent) {
        this.addReopenItem(spreadsheetAppEvent.getFile(), true);
    }

    public void workbookUnloaded(SpreadsheetAppEvent spreadsheetAppEvent) {
    }

    public void workbookSaved(SpreadsheetAppEvent spreadsheetAppEvent) {
        this.addReopenItem(spreadsheetAppEvent.getFile(), true);
    }

    protected class RemoveAllAction
    extends AbstractAction {
        public RemoveAllAction() {
            String string = "Remove all";
            this.putValue("Name", string);
            this.putValue("ShortDescription", string);
            this.putValue("ActionCommandKey", string);
            this.putValue("MnemonicKey", 82);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ReopenMenu.this.removeAll();
        }
    }

    protected class RemoveObsoleteAction
    extends AbstractAction {
        public RemoveObsoleteAction() {
            String string = "Remove obsolete";
            this.putValue("Name", string);
            this.putValue("ShortDescription", string);
            this.putValue("ActionCommandKey", string);
            this.putValue("MnemonicKey", 79);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ReopenMenu.this.removeObsolete();
        }
    }

    protected static class ReopenAction
    extends OpenAction {
        private File file;

        public ReopenAction(CleanSheets cleanSheets, UIController uIController, File file) {
            super(cleanSheets, uIController, null);
            this.file = file;
            this.setEnabled(true);
            this.putValue("Name", file.getAbsolutePath());
            this.putValue("ActionCommandKey", file.getAbsolutePath());
        }

        protected void defineProperties() {
            this.putValue("ShortDescription", null);
            this.putValue("SmallIcon", null);
        }

        public File getFile() {
            return this.file;
        }
    }
}

