/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.ctrl;

import csheets.CleanSheets;
import csheets.core.Workbook;
import csheets.ui.FileChooser;
import csheets.ui.ctrl.SaveAction;
import csheets.ui.ctrl.UIController;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class CloseAction
extends SaveAction {
    public CloseAction(CleanSheets cleanSheets, UIController uIController, FileChooser fileChooser) {
        super(cleanSheets, uIController, fileChooser);
    }

    protected String getName() {
        return "Close";
    }

    protected void defineProperties() {
        this.putValue("MnemonicKey", 67);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, 2));
        this.putValue("SmallIcon", new ImageIcon(CleanSheets.class.getResource("res/img/close.gif")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Workbook workbook = this.uiController.getActiveWorkbook();
        if (workbook != null) {
            if (this.uiController.isWorkbookModified(workbook)) {
                int n = JOptionPane.showConfirmDialog(null, "The current workbook has been modified.\nDo you want to save the file before closing it?", "Save changes before closing?", 1, 2);
                if (n == 0) {
                    super.actionPerformed(actionEvent);
                }
                if (n != 0 && n != 1) {
                    return;
                }
            }
            this.app.unload(workbook);
        }
    }

    protected boolean requiresModification() {
        return false;
    }
}

