/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.ctrl;

import csheets.CleanSheets;
import csheets.core.Workbook;
import csheets.ui.FileChooser;
import csheets.ui.ctrl.BaseAction;
import csheets.ui.ctrl.UIController;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class OpenAction
extends BaseAction {
    protected CleanSheets app;
    protected UIController uiController;
    private FileChooser chooser;

    public OpenAction(CleanSheets cleanSheets, UIController uIController, FileChooser fileChooser) {
        this.app = cleanSheets;
        this.uiController = uIController;
        this.chooser = fileChooser;
        this.setEnabled(fileChooser != null);
    }

    protected String getName() {
        return "Open...";
    }

    protected void defineProperties() {
        this.putValue("MnemonicKey", 79);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        this.putValue("SmallIcon", new ImageIcon(CleanSheets.class.getResource("res/img/open.gif")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file = this.getFile();
        if (file != null) {
            Workbook workbook = this.app.getWorkbook(file);
            if (workbook == null) {
                try {
                    this.app.load(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.showErrorDialog("The file you requested was not found.");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.showErrorDialog("The class of a serialized object cannot be found:\n" + classNotFoundException.getMessage() + ".");
                }
                catch (InvalidClassException invalidClassException) {
                    this.showErrorDialog("Something is wrong with a class used by serialization.");
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    this.showErrorDialog("Control information in the input stream is inconsistent.");
                }
                catch (OptionalDataException optionalDataException) {
                    this.showErrorDialog("Primitive data was found in the input stream instead of objects.");
                }
                catch (Exception exception) {
                    this.showErrorDialog("An I/O error occurred when loading the file.");
                }
            } else {
                this.uiController.setActiveWorkbook(workbook);
            }
        }
    }

    public File getFile() {
        return this.chooser.getFileToOpen();
    }
}

