/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.ext;

import csheets.ext.Extension;
import csheets.ui.ctrl.UIController;
import csheets.ui.ext.CellDecorator;
import csheets.ui.ext.TableDecorator;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JToolBar;

public abstract class UIExtension {
    protected final Extension extension;
    protected final UIController uiController;
    protected final Properties props;

    public UIExtension(Extension extension, UIController uIController) {
        this.extension = extension;
        this.uiController = uIController;
        this.props = uIController.getUserProperties();
        if (this.getCellDecorator() != null) {
            this.getCellDecorator().setEnabled(Boolean.TRUE.equals(this.getEnabledProperty("celldecorator")));
        }
        if (this.getTableDecorator() != null) {
            this.getTableDecorator().setEnabled(Boolean.TRUE.equals(this.getEnabledProperty("tabledecorator")));
        }
        if (this.getToolBar() != null) {
            this.getToolBar().setVisible(Boolean.TRUE.equals(this.getEnabledProperty("toolbar")));
        }
        if (this.getSideBar() != null) {
            this.getSideBar().setEnabled(Boolean.TRUE.equals(this.getEnabledProperty("sidebar")));
        }
    }

    public final Extension getExtension() {
        return this.extension;
    }

    public final Boolean getEnabledProperty(String string) {
        String string2 = this.props.getProperty(this.extension.getPropertyKey() + string);
        if (string2 == null) {
            return null;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        return null;
    }

    public final void setEnabledProperty(String string, boolean bl) {
        this.props.setProperty(this.extension.getPropertyKey() + string, Boolean.toString(bl));
    }

    public Icon getIcon() {
        return null;
    }

    public CellDecorator getCellDecorator() {
        return null;
    }

    public TableDecorator getTableDecorator() {
        return null;
    }

    public JMenu getMenu() {
        return null;
    }

    public JToolBar getToolBar() {
        return null;
    }

    public JComponent getSideBar() {
        return null;
    }
}

