/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.grid;

import csheets.ui.grid.HeaderRenderer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableCellRenderer;

public class RowHeader
extends JComponent {
    private JTable table;
    private CellRendererPane rendererPane = new CellRendererPane();
    private TableCellRenderer renderer = new HeaderRenderer(1);
    private int width = 30;
    private int minRowHeight = 5;
    private int rowMargin = 1;
    private int resizingRow = -1;

    public RowHeader(JTable jTable) {
        this.table = jTable;
        this.add(this.rendererPane);
        this.setPreferredSize(new Dimension(this.width, jTable.getRowCount() * jTable.getRowHeight()));
        RowResizer rowResizer = new RowResizer();
        this.addMouseListener(rowResizer);
        this.addMouseMotionListener(rowResizer);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x, rectangle.y + rectangle.height - 1);
        int n = this.table.rowAtPoint(point);
        int n2 = this.table.rowAtPoint(point2);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = this.table.getRowCount() - 1;
        }
        int n3 = this.table.getCellRect((int)n, (int)0, (boolean)true).y;
        int[] nArray = this.table.getSelectedRows();
        for (int i = n; i <= n2; ++i) {
            boolean bl = Arrays.binarySearch(nArray, i) >= 0;
            Component component = this.renderer.getTableCellRendererComponent(this.table, null, bl, false, i, -1);
            int n4 = this.table.getRowHeight(i);
            this.rendererPane.paintComponent(graphics, component, this, 0, n3, this.width, n4, true);
            n3 += n4;
        }
    }

    public void autoResize(int n) {
        int n2 = this.renderer.getTableCellRendererComponent((JTable)this.table, null, (boolean)false, (boolean)false, (int)n, (int)0).getPreferredSize().height;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            Component component = this.table.getCellRenderer(n, i).getTableCellRendererComponent(this.table, this.table.getValueAt(n, i), false, false, n, i);
            n2 = Math.max(n2, component.getPreferredSize().height);
        }
        if ((n2 += 2 * this.rowMargin) > this.minRowHeight) {
            this.table.setRowHeight(this.resizingRow, n2);
        } else {
            this.table.setRowHeight(this.minRowHeight);
        }
        this.repaint();
    }

    protected class RowResizer
    extends MouseInputAdapter {
        private final Cursor NORMAL_CURSOR;
        private final Cursor RESIZE_CURSOR;

        protected RowResizer() {
            this.NORMAL_CURSOR = RowHeader.this.getCursor();
            this.RESIZE_CURSOR = Cursor.getPredefinedCursor(9);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            RowHeader.this.resizingRow = this.getResizingRow(mouseEvent.getPoint());
            if (RowHeader.this.resizingRow == -1) {
                int n = RowHeader.this.table.rowAtPoint(mouseEvent.getPoint());
                int n2 = RowHeader.this.table.getColumnCount();
                if (mouseEvent.isShiftDown()) {
                    RowHeader.this.table.changeSelection(n, 0, false, true);
                } else if (mouseEvent.isControlDown()) {
                    RowHeader.this.table.changeSelection(n, 0, true, false);
                } else {
                    RowHeader.this.table.changeSelection(n, n2, false, false);
                    RowHeader.this.table.changeSelection(n, 0, false, true);
                }
                RowHeader.this.repaint();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && RowHeader.this.resizingRow != -1) {
                RowHeader.this.autoResize(RowHeader.this.resizingRow);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            RowHeader.this.setCursor(this.getResizingRow(mouseEvent.getPoint()) == -1 ? this.NORMAL_CURSOR : this.RESIZE_CURSOR);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (RowHeader.this.resizingRow != -1) {
                int n = mouseEvent.getPoint().y - ((RowHeader)RowHeader.this).table.getCellRect((int)((RowHeader)RowHeader.this).resizingRow, (int)0, (boolean)true).y;
                if (n >= RowHeader.this.minRowHeight) {
                    RowHeader.this.table.setRowHeight(RowHeader.this.resizingRow, n);
                }
                RowHeader.this.repaint();
            }
        }

        private int getResizingRow(Point point) {
            int n = RowHeader.this.table.rowAtPoint(point);
            if (n == -1) {
                return n;
            }
            Rectangle rectangle = RowHeader.this.table.getCellRect(n, 0, true);
            rectangle = new Rectangle(0, rectangle.y, RowHeader.this.width, RowHeader.this.table.getRowHeight(n));
            rectangle.grow(0, -2);
            if (rectangle.contains(point)) {
                return -1;
            }
            if (point.y < rectangle.y + rectangle.height / 2) {
                --n;
            }
            return n;
        }
    }
}

