/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.sheet;

import csheets.core.Address;
import csheets.core.Cell;
import csheets.core.Spreadsheet;
import csheets.ext.style.StylableSpreadsheet;
import csheets.ui.ctrl.SelectionEvent;
import csheets.ui.ctrl.SelectionListener;
import csheets.ui.ctrl.UIController;
import csheets.ui.ext.TableDecorator;
import csheets.ui.ext.UIExtension;
import csheets.ui.grid.Grid;
import csheets.ui.sheet.CellEditor;
import csheets.ui.sheet.CellRenderer;
import csheets.ui.sheet.SpreadsheetTableModel;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SpreadsheetTable
extends Grid
implements SelectionListener {
    public static final String CLEAR_SELECTION_COMMAND = "Clear the content of the selected cells";
    private Spreadsheet spreadsheet;
    private UIController uiController;
    private List<TableDecorator> decorators = new LinkedList<TableDecorator>();
    private PropertyChangeListener columnWidthTracker = new ColumnWidthTracker();

    public SpreadsheetTable(Spreadsheet spreadsheet, UIController uIController) {
        this(new SpreadsheetTableModel(spreadsheet, uIController), uIController);
    }

    public SpreadsheetTable(SpreadsheetTableModel spreadsheetTableModel, UIController uIController) {
        super(null);
        this.uiController = uIController;
        uIController.addSelectionListener(this);
        this.setDefaultRenderer(Cell.class, new CellRenderer(uIController));
        this.setDefaultEditor(Cell.class, new CellEditor(uIController));
        this.setDragEnabled(true);
        this.setTransferHandler(uIController.getCellTransferHandler());
        ActionMap actionMap = this.getActionMap();
        actionMap.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMap.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMap.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        actionMap.put(CLEAR_SELECTION_COMMAND, new ClearSelectionAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), CLEAR_SELECTION_COMMAND);
        for (UIExtension uIExtension : uIController.getExtensions()) {
            TableDecorator tableDecorator = uIExtension.getTableDecorator();
            if (tableDecorator == null) continue;
            this.decorators.add(tableDecorator);
        }
        this.setModel(spreadsheetTableModel);
    }

    public Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    public void setSpreadsheet(Spreadsheet spreadsheet) {
        this.setModel(new SpreadsheetTableModel(spreadsheet, this.uiController));
    }

    public void setModel(TableModel tableModel) {
        int n;
        int n2;
        if (!(tableModel instanceof SpreadsheetTableModel)) {
            return;
        }
        this.spreadsheet = ((SpreadsheetTableModel)tableModel).getSpreadsheet();
        super.setModel(tableModel);
        StylableSpreadsheet stylableSpreadsheet = (StylableSpreadsheet)this.spreadsheet.getExtension("Style");
        for (n2 = 0; n2 < this.spreadsheet.getColumnCount(); ++n2) {
            n = stylableSpreadsheet.getColumnWidth(n2);
            if (n == -1) continue;
            this.columnModel.getColumn(n2).setPreferredWidth(n);
        }
        for (n2 = 0; n2 < this.spreadsheet.getRowCount(); ++n2) {
            n = stylableSpreadsheet.getRowHeight(n2);
            if (n == -1) continue;
            super.setRowHeight(n2, n);
        }
        Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().addPropertyChangeListener(this.columnWidthTracker);
        }
    }

    public Cell getSelectedCell() {
        int n = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
        int n2 = this.getSelectionModel().getAnchorSelectionIndex();
        return this.spreadsheet.getCell(new Address(n, n2));
    }

    public Cell[][] getSelectedCells() {
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        Cell[][] cellArray = new Cell[nArray.length][nArray2.length];
        for (int i = 0; i < cellArray.length; ++i) {
            for (int j = 0; j < cellArray[i].length; ++j) {
                cellArray[i][j] = this.spreadsheet.getCell(nArray2[j], nArray[i]);
            }
        }
        return cellArray;
    }

    public void clearSelectedCells() {
        Cell[][] cellArray = this.getSelectedCells();
        int n = cellArray.length;
        for (int i = 0; i < n; ++i) {
            Cell[] cellArray2;
            for (Cell cell : cellArray2 = cellArray[i]) {
                cell.clear();
            }
        }
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        super.changeSelection(n, n2, bl, bl2);
        if (!bl2) {
            this.uiController.setActiveCell(this.getSelectedCell());
        }
    }

    public void selectAll() {
        super.changeSelection(0, 0, false, false);
        this.changeSelection(this.spreadsheet.getRowCount(), this.spreadsheet.getColumnCount(), false, true);
        this.uiController.setActiveCell(this.getSelectedCell());
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        if (this.spreadsheet == selectionEvent.getSpreadsheet() && selectionEvent.isCellChanged()) {
            int n = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            int n2 = this.getSelectionModel().getAnchorSelectionIndex();
            Address address = selectionEvent.getCell().getAddress();
            if (selectionEvent.getPreviousCell() == null || address.getColumn() != n || address.getRow() != n2) {
                this.changeSelection(address.getRow(), address.getColumn(), false, false);
                this.requestFocus();
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        for (TableDecorator tableDecorator : this.decorators) {
            if (!tableDecorator.isEnabled()) continue;
            tableDecorator.decorate(graphics, this);
        }
    }

    public void setRowHeight(int n, int n2) {
        super.setRowHeight(n, n2);
        this.uiController.setWorkbookModified(this.spreadsheet.getWorkbook());
        StylableSpreadsheet stylableSpreadsheet = (StylableSpreadsheet)this.spreadsheet.getExtension("Style");
        stylableSpreadsheet.setRowHeight(n, n2);
    }

    protected class ClearSelectionAction
    extends AbstractAction {
        public ClearSelectionAction() {
            this.putValue("Name", SpreadsheetTable.CLEAR_SELECTION_COMMAND);
            this.putValue("ShortDescription", SpreadsheetTable.CLEAR_SELECTION_COMMAND);
            this.putValue("ActionCommandKey", SpreadsheetTable.CLEAR_SELECTION_COMMAND);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SpreadsheetTable.this.clearSelectedCells();
        }
    }

    private class ColumnWidthTracker
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("width")) {
                TableColumn tableColumn = (TableColumn)propertyChangeEvent.getSource();
                StylableSpreadsheet stylableSpreadsheet = (StylableSpreadsheet)SpreadsheetTable.this.spreadsheet.getExtension("Style");
                if (stylableSpreadsheet.getColumnWidth(tableColumn.getModelIndex()) != tableColumn.getWidth()) {
                    stylableSpreadsheet.setColumnWidth(tableColumn.getModelIndex(), tableColumn.getWidth());
                    SpreadsheetTable.this.uiController.setWorkbookModified(SpreadsheetTable.this.spreadsheet.getWorkbook());
                }
            }
        }
    }
}

