/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.sheet;

import csheets.core.Address;
import csheets.core.Spreadsheet;
import csheets.core.Workbook;
import csheets.core.WorkbookListener;
import csheets.ui.ctrl.ActionManager;
import csheets.ui.ctrl.SelectionEvent;
import csheets.ui.ctrl.UIController;
import csheets.ui.sheet.SpreadsheetTable;
import csheets.ui.sheet.WorkbookPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicArrowButton;

public class WorkbookPane
extends JTabbedPane
implements csheets.ui.ctrl.SelectionListener {
    public static final String FIRST_COMMAND = "First tab";
    public static final String PREV_COMMAND = "Previous tab";
    public static final String NEXT_COMMAND = "Next tab";
    public static final String LAST_COMMAND = "Last tab";
    private UIController uiController;
    private JButton[] buttons = new JButton[]{new StopArrowButton(7, "First tab"), new BasicArrowButton(7), new BasicArrowButton(3), new StopArrowButton(3, "Last tab")};
    private Dimension buttonSize = new Dimension(16, 17);
    private int visibleCount = 0;
    private int visibleStartIndex = 0;
    private JPopupMenu popupMenu = new JPopupMenu();
    private WorkbookListener synchronizer = new SpreadsheetSynchronizer();

    public WorkbookPane(UIController uIController, ActionManager actionManager) {
        super(3, 1);
        this.uiController = uIController;
        uIController.addSelectionListener(this);
        WorkbookPaneUI workbookPaneUI = new WorkbookPaneUI();
        this.buttons[1].setActionCommand(PREV_COMMAND);
        this.buttons[2].setActionCommand(NEXT_COMMAND);
        this.setUI(workbookPaneUI);
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(33, 2), "Select previous spreadsheet");
        inputMap.put(KeyStroke.getKeyStroke(34, 2), "Select next spreadsheet");
        ActionMap actionMap = this.getActionMap();
        WorkbookPaneUI workbookPaneUI2 = workbookPaneUI;
        workbookPaneUI2.getClass();
        actionMap.put("Select previous spreadsheet", new WorkbookPaneUI.NavigateAction(workbookPaneUI2, 13));
        ActionMap actionMap2 = this.getActionMap();
        WorkbookPaneUI workbookPaneUI3 = workbookPaneUI;
        workbookPaneUI3.getClass();
        actionMap2.put("Select next spreadsheet", new WorkbookPaneUI.NavigateAction(workbookPaneUI3, 12));
        this.popupMenu.add(actionManager.getAction("addsheet"));
        this.popupMenu.add(actionManager.getAction("removesheet"));
        this.popupMenu.add(actionManager.getAction("renamesheet"));
        this.addMouseListener(new PopupShower());
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        Workbook workbook = selectionEvent.getWorkbook();
        if (selectionEvent.isWorkbookChanged()) {
            this.removeAll();
            if (workbook != null && workbook.getSpreadsheetCount() > 0) {
                int n = 0;
                for (Spreadsheet spreadsheet : workbook) {
                    SpreadsheetTable spreadsheetTable = new SpreadsheetTable(spreadsheet, this.uiController);
                    this.add(spreadsheet.getTitle(), new JScrollPane(spreadsheetTable));
                    this.setMnemonicAt(n++, KeyStroke.getKeyStroke(Integer.toString(n)).getKeyCode());
                    spreadsheetTable.selectionChanged(selectionEvent);
                }
            } else {
                this.add(new JPanel());
            }
            if (selectionEvent.getPreviousWorkbook() != null) {
                selectionEvent.getPreviousWorkbook().removeWorkbookListener(this.synchronizer);
            }
            if (selectionEvent.getWorkbook() != null) {
                selectionEvent.getWorkbook().addWorkbookListener(this.synchronizer);
            }
        }
    }

    protected ChangeListener createChangeListener() {
        return new SelectionListener();
    }

    public Dimension getPreferredButtonSize() {
        return this.buttonSize;
    }

    public JButton[] getButtons() {
        return this.buttons;
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        if (component instanceof BasicArrowButton) {
            if (component != null) {
                component.setVisible(true);
                this.addImpl(component, null, -1);
            }
        } else {
            super.insertTab(string, icon, component, string2, n);
        }
    }

    public boolean isVisibleTab(int n) {
        return this.visibleStartIndex <= n && n < this.visibleStartIndex + this.visibleCount;
    }

    public int getVisibleCount() {
        return this.visibleCount;
    }

    public void setVisibleCount(int n) {
        if (n < 0) {
            return;
        }
        this.visibleCount = n;
    }

    public int getVisibleStartIndex() {
        return this.visibleStartIndex;
    }

    public void setVisibleStartIndex(int n) {
        if (n < 0 || this.getTabCount() <= n) {
            return;
        }
        this.visibleStartIndex = n;
    }

    protected static class StopArrowButton
    extends BasicArrowButton {
        public StopArrowButton(int n, String string) {
            super(n);
            this.setActionCommand(string);
        }

        public void paintTriangle(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
            super.paintTriangle(graphics, n, n2, n3, n4, bl);
            Color color = graphics.getColor();
            if (bl) {
                graphics.setColor(UIManager.getColor("controlDkShadow"));
            } else {
                graphics.setColor(UIManager.getColor("controlShadow"));
            }
            graphics.translate(n, n2);
            n3 = Math.max(n3, 2);
            int n5 = n3 / 2;
            int n6 = n3 - 1;
            if (n4 == 7) {
                graphics.drawLine(-1, n5 - n6, -1, n5 + n6);
                if (!bl) {
                    graphics.setColor(UIManager.getColor("controlLtHighlight"));
                    graphics.drawLine(0, n5 - n6 + 1, 0, n5 - 1);
                    graphics.drawLine(0, n5 + 2, 0, n5 + n6 + 1);
                }
            } else {
                graphics.drawLine(n3, n5 - n6, n3, n5 + n6);
                if (!bl) {
                    graphics.setColor(UIManager.getColor("controlLtHighlight"));
                    graphics.drawLine(n3 + 1, n5 - n6 + 1, n3 + 1, n5 + n6 + 1);
                }
            }
            graphics.setColor(color);
        }
    }

    private class PopupShower
    extends MouseAdapter {
        private PopupShower() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                WorkbookPane.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY() - ((WorkbookPane)WorkbookPane.this).popupMenu.getPreferredSize().height);
            }
        }
    }

    private class SpreadsheetSynchronizer
    implements WorkbookListener {
        private SpreadsheetSynchronizer() {
        }

        public void spreadsheetInserted(Spreadsheet spreadsheet, int n) {
            WorkbookPane.this.insertTab(spreadsheet.getTitle(), null, new JScrollPane(new SpreadsheetTable(spreadsheet, WorkbookPane.this.uiController)), null, n);
            for (int i = 0; i < WorkbookPane.this.getTabCount(); ++i) {
                WorkbookPane.this.setMnemonicAt(i, KeyStroke.getKeyStroke(Integer.toString(i)).getKeyCode());
            }
        }

        public void spreadsheetRemoved(Spreadsheet spreadsheet) {
            for (Component component : WorkbookPane.this.getComponents()) {
                Component component2;
                if (!(component instanceof JScrollPane) || !((component2 = ((JScrollPane)component).getViewport().getView()) instanceof SpreadsheetTable) || ((SpreadsheetTable)component2).getSpreadsheet() != spreadsheet) continue;
                WorkbookPane.this.remove(component);
            }
        }

        public void spreadsheetRenamed(Spreadsheet spreadsheet) {
        }
    }

    protected class SelectionListener
    extends JTabbedPane.ModelListener {
        protected SelectionListener() {
            super(WorkbookPane.this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Component component;
            super.stateChanged(changeEvent);
            Component component2 = WorkbookPane.this.getSelectedComponent();
            if (component2 != null && component2 instanceof JScrollPane && (component = ((JScrollPane)component2).getViewport().getView()) instanceof SpreadsheetTable) {
                SpreadsheetTable spreadsheetTable = (SpreadsheetTable)component;
                int n = spreadsheetTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                int n2 = spreadsheetTable.getSelectionModel().getAnchorSelectionIndex();
                WorkbookPane.this.uiController.setActiveCell(spreadsheetTable.getSpreadsheet().getCell(new Address(n, n2)));
            }
        }
    }
}

