/*
 * Copyright (c) 2005 Einar Pehrson <einar@pehrson.nu>.
 *
 * This file is part of
 * CleanSheets - a spreadsheet application for the Java platform.
 *
 * CleanSheets is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CleanSheets is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CleanSheets; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package csheets.core.formula;

import csheets.core.IllegalValueTypeException;
import csheets.core.Value;

/**
 * A unary operator in a formula.
 * @author Einar Pehrson
 */
public interface UnaryOperator extends Operator {

	/**
	 * Applies the operator to the given operand and returns the result.
	 * @return the result of the operation
	 * @throws IllegalValueTypeException if the value of the operand is not of the expected type
	 */
	public Value applyTo(Expression operand) throws IllegalValueTypeException;

	/**
	 * Returns whether the operator is a prefix operator, i.e. it appears
	 * before its operand.
	 * @return true for prefix operators, false for postfix operators
	 */
	public boolean isPrefix();
}