/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.tools.calculator;

import com.eteks.parser.CalculatorParser;
import com.eteks.parser.CompilationException;
import com.eteks.parser.Function;
import com.eteks.parser.Interpreter;
import com.eteks.parser.Syntax;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;

public class JeksCalculator
extends Applet {
    private static final Syntax SYNTAX = new 1();
    private static final Interpreter INTERPRETER = new 2();
    private static final CalculatorParser PARSER = new CalculatorParser(SYNTAX);
    private TextField expressionTextField = new TextField();
    private Label numberLabel = new Label("0", 2);
    private Button powerButton = new FuncButton("     pow     ");
    private Button squareButton = new FuncButton("     x\u00b2      ");
    private Button squareRootButton = new FuncButton("      \u221a      ");
    private Button invButton = new FuncButton("     1/x     ");
    private Button expButton = new FuncButton("     exp     ");
    private Button lnButton = new FuncButton("      ln      ");
    private Button logButton = new FuncButton("     log     ");
    private Button sinButton = new FuncButton("     sin     ");
    private Button cosButton = new FuncButton("     cos     ");
    private Button tanButton = new FuncButton("     tan     ");
    private Button arcsinButton = new FuncButton("  arcsin  ");
    private Button arccosButton = new FuncButton("  arccos  ");
    private Button arctanButton = new FuncButton("  arctan  ");
    private Button openingBracketButton = new FuncButton("       (       ");
    private Button closingBracketButton = new FuncButton("       )       ");
    private Button piButton = new FuncButton("      \u03c0      ");
    private Button digit0Button = new DigButton("0");
    private Button digit1Button = new DigButton("1");
    private Button digit2Button = new DigButton("2");
    private Button digit3Button = new DigButton("3");
    private Button digit4Button = new DigButton("4");
    private Button digit5Button = new DigButton("5");
    private Button digit6Button = new DigButton("6");
    private Button digit7Button = new DigButton("7");
    private Button digit8Button = new DigButton("8");
    private Button digit9Button = new DigButton("9");
    private Button decimalButton = new DigButton(" . ");
    private Button oppositeButton = new DigButton(" \u00b1 ");
    private Button addButton = new DigButton("+");
    private Button substractButton = new DigButton("-");
    private Button multiplyButton = new DigButton("*");
    private Button divideButton = new DigButton("/");
    private Button clearButton = new DigButton("CE");
    private Button clearAllButton = new DigButton("C");
    private Button equalButton = new DigButton("=");
    private boolean newExpression = false;
    private boolean newOperand = true;
    private String lastBinaryOperator = null;

    public void init() {
        Font font = this.getFont();
        ((Component)this).setFont(new Font(font.getName(), 1, font.getSize()));
        this.numberLabel.setFont(new Font(font.getName(), 1, font.getSize() * 2));
        this.numberLabel.setBackground(Color.white);
        this.expressionTextField.disable();
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(4, 4, 3, 3));
        panel.add(this.powerButton);
        panel.add(this.sinButton);
        panel.add(this.arcsinButton);
        panel.add(this.expButton);
        panel.add(this.squareRootButton);
        panel.add(this.cosButton);
        panel.add(this.arccosButton);
        panel.add(this.lnButton);
        panel.add(this.squareButton);
        panel.add(this.tanButton);
        panel.add(this.arctanButton);
        panel.add(this.logButton);
        panel.add(this.invButton);
        panel.add(this.piButton);
        panel.add(this.openingBracketButton);
        panel.add(this.closingBracketButton);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(4, 4, 3, 3));
        panel2.add(this.digit7Button);
        panel2.add(this.digit8Button);
        panel2.add(this.digit9Button);
        panel2.add(this.divideButton);
        panel2.add(this.digit4Button);
        panel2.add(this.digit5Button);
        panel2.add(this.digit6Button);
        panel2.add(this.multiplyButton);
        panel2.add(this.digit1Button);
        panel2.add(this.digit2Button);
        panel2.add(this.digit3Button);
        panel2.add(this.substractButton);
        panel2.add(this.digit0Button);
        panel2.add(this.decimalButton);
        panel2.add(this.oppositeButton);
        panel2.add(this.addButton);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(2, 1, 3, 3));
        panel3.add(this.clearButton);
        panel3.add(this.clearAllButton);
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(2, 1, 3, 3));
        panel4.add(panel3);
        panel4.add(this.equalButton);
        Panel panel5 = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel5.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        panel5.add(panel);
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        gridBagConstraints.gridx = 1;
        panel5.add(panel2);
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 2;
        panel5.add(panel4);
        gridBagLayout.setConstraints(panel4, gridBagConstraints);
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout(3, 3));
        panel6.add("North", this.expressionTextField);
        3 var10_10 = new 3();
        var10_10.setBackground(Color.lightGray);
        var10_10.setLayout(new GridLayout(1, 1));
        var10_10.add(this.numberLabel);
        panel6.add("South", var10_10);
        Panel panel7 = new Panel();
        panel7.setLayout(new BorderLayout(3, 3));
        panel7.add("North", panel6);
        panel7.add("Center", panel5);
        this.setLayout(new BorderLayout());
        this.add("West", panel7);
    }

    public Insets insets() {
        return new Insets(3, 3, 3, 3);
    }

    public boolean keyDown(Event event, int n) {
        switch (n) {
            case 48: {
                this.postEvent(new Event(this.digit0Button, 1001, this.digit0Button.getLabel()));
                break;
            }
            case 49: {
                this.postEvent(new Event(this.digit1Button, 1001, this.digit1Button.getLabel()));
                break;
            }
            case 50: {
                this.postEvent(new Event(this.digit2Button, 1001, this.digit2Button.getLabel()));
                break;
            }
            case 51: {
                this.postEvent(new Event(this.digit3Button, 1001, this.digit3Button.getLabel()));
                break;
            }
            case 52: {
                this.postEvent(new Event(this.digit4Button, 1001, this.digit4Button.getLabel()));
                break;
            }
            case 53: {
                this.postEvent(new Event(this.digit5Button, 1001, this.digit5Button.getLabel()));
                break;
            }
            case 54: {
                this.postEvent(new Event(this.digit6Button, 1001, this.digit6Button.getLabel()));
                break;
            }
            case 55: {
                this.postEvent(new Event(this.digit7Button, 1001, this.digit7Button.getLabel()));
                break;
            }
            case 56: {
                this.postEvent(new Event(this.digit8Button, 1001, this.digit8Button.getLabel()));
                break;
            }
            case 57: {
                this.postEvent(new Event(this.digit9Button, 1001, this.digit9Button.getLabel()));
                break;
            }
            case 46: {
                this.postEvent(new Event(this.decimalButton, 1001, this.decimalButton.getLabel()));
                break;
            }
            case 43: {
                this.postEvent(new Event(this.addButton, 1001, this.addButton.getLabel()));
                break;
            }
            case 45: {
                this.postEvent(new Event(this.substractButton, 1001, this.substractButton.getLabel()));
                break;
            }
            case 42: {
                this.postEvent(new Event(this.multiplyButton, 1001, this.multiplyButton.getLabel()));
                break;
            }
            case 47: {
                this.postEvent(new Event(this.divideButton, 1001, this.divideButton.getLabel()));
                break;
            }
            case 40: {
                this.postEvent(new Event(this.openingBracketButton, 1001, this.openingBracketButton.getLabel()));
                break;
            }
            case 41: {
                this.postEvent(new Event(this.closingBracketButton, 1001, this.closingBracketButton.getLabel()));
                break;
            }
            case 10: {
                this.postEvent(new Event(this.equalButton, 1001, this.equalButton.getLabel()));
                break;
            }
        }
        return true;
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Button) {
            String string = ((String)object).trim();
            if (event.target == this.equalButton && this.newExpression) {
                return true;
            }
            if (event.target == this.clearAllButton || this.newExpression) {
                ((TextComponent)this.expressionTextField).setText("");
                if (Character.isDigit(string.charAt(0)) || event.target == this.decimalButton || event.target == this.clearAllButton) {
                    this.numberLabel.setText("0");
                }
                this.newExpression = false;
            }
            String string2 = this.expressionTextField.getText();
            if ("+-/*".indexOf(string) != -1 || event.target == this.powerButton) {
                if (this.newOperand && this.lastBinaryOperator != null) {
                    ((TextComponent)this.expressionTextField).setText(String.valueOf(string2.substring(0, string2.lastIndexOf(this.lastBinaryOperator))) + string + " ");
                } else if (string2.endsWith(")")) {
                    ((TextComponent)this.expressionTextField).setText(String.valueOf(string2) + " " + string + " ");
                } else {
                    ((TextComponent)this.expressionTextField).setText(String.valueOf(string2) + this.numberLabel.getText() + " " + string + " ");
                }
                this.newOperand = true;
                this.lastBinaryOperator = string;
            } else {
                this.lastBinaryOperator = null;
                if (event.target == this.equalButton) {
                    if (!string2.endsWith(")")) {
                        string2 = String.valueOf(string2) + this.numberLabel.getText();
                        ((TextComponent)this.expressionTextField).setText(string2);
                    }
                    int n = this.getCharCount(string2, '(') - this.getCharCount(string2, ')');
                    while (n > 0) {
                        string2 = String.valueOf(string2) + ")";
                        ((TextComponent)this.expressionTextField).setText(string2);
                        --n;
                    }
                    try {
                        this.numberLabel.setText(PARSER.computeExpression(this.expressionTextField.getText(), INTERPRETER).toString());
                        this.newOperand = false;
                    }
                    catch (CompilationException compilationException) {
                        this.numberLabel.setText(compilationException.getMessage());
                    }
                    this.newExpression = true;
                } else if (string.length() == 1 && Character.isDigit(string.charAt(0))) {
                    if ("0".equals(this.numberLabel.getText())) {
                        this.numberLabel.setText(string);
                    } else if ("-0".equals(this.numberLabel.getText())) {
                        this.numberLabel.setText("-" + string);
                    } else {
                        this.numberLabel.setText(String.valueOf(this.numberLabel.getText()) + string);
                    }
                    this.newOperand = false;
                } else if (event.target == this.decimalButton) {
                    this.numberLabel.setText(String.valueOf(this.numberLabel.getText()) + (this.numberLabel.getText().indexOf(".") == -1 ? "." : ""));
                    this.newOperand = false;
                } else if (event.target == this.oppositeButton) {
                    this.numberLabel.setText(this.numberLabel.getText().charAt(0) == '-' ? this.numberLabel.getText().substring(1) : "-" + this.numberLabel.getText());
                    this.newOperand = false;
                } else if (event.target == this.piButton) {
                    this.numberLabel.setText(String.valueOf(Math.PI));
                    this.newOperand = false;
                } else if (event.target == this.clearButton) {
                    this.newOperand = true;
                } else if (event.target == this.openingBracketButton) {
                    ((TextComponent)this.expressionTextField).setText(String.valueOf(string2) + "(");
                    this.newOperand = true;
                } else if (event.target == this.closingBracketButton) {
                    if (this.getCharCount(string2, '(') - this.getCharCount(string2, ')') > 0) {
                        if (string2.endsWith(")")) {
                            ((TextComponent)this.expressionTextField).setText(String.valueOf(string2) + ")");
                        } else {
                            ((TextComponent)this.expressionTextField).setText(String.valueOf(string2) + this.numberLabel.getText() + ")");
                        }
                    }
                } else if (event.target != this.clearAllButton) {
                    if (event.target == this.squareButton) {
                        string = "sqr";
                    } else if (event.target == this.squareRootButton) {
                        string = "sqrt";
                    } else if (event.target == this.invButton) {
                        string = "inv";
                    }
                    ((TextComponent)this.expressionTextField).setText(String.valueOf(string2) + string + " ");
                    this.newOperand = true;
                }
            }
            if (this.newOperand) {
                this.numberLabel.setText("0");
            }
        }
        return true;
    }

    private int getCharCount(String string, char c) {
        int n = 0;
        int n2 = -1;
        do {
            if ((n2 = string.indexOf(c, n2 + 1)) == -1) continue;
            ++n;
        } while (n2 != -1);
        return n;
    }

    public String getAppletInfo() {
        return "JeksCalculator applet\nCopyrights (C) 1998-2001 eTeks";
    }

    public double getValue() {
        return new Double(this.numberLabel.getText());
    }

    public static void main(String[] stringArray) {
        4 var1_1 = new 4("JeksCalculator");
        JeksCalculator jeksCalculator = new JeksCalculator();
        var1_1.add("Center", jeksCalculator);
        var1_1.addNotify();
        ((Applet)jeksCalculator).init();
        var1_1.pack();
        var1_1.setResizable(false);
        var1_1.show();
    }

    private final class 1
    implements Syntax {
        public Object getLiteral(String string, StringBuffer stringBuffer) {
            int n = 0;
            while (n < string.length() && (Character.isDigit(string.charAt(n)) || string.charAt(n) == '.')) {
                if (++n >= string.length() || Character.toUpperCase(string.charAt(n)) != 'E') continue;
                n += 2;
            }
            if (n == 0) {
                return null;
            }
            stringBuffer.append(string.substring(0, n));
            return new Double(stringBuffer.toString());
        }

        public Object getConstantKey(String string) {
            return null;
        }

        public Object getUnaryOperatorKey(String string) {
            if ("+".equals(string) || "-".equals(string)) {
                return string;
            }
            return null;
        }

        public Object getBinaryOperatorKey(String string) {
            if ("+".equals(string = string.toUpperCase()) || "-".equals(string) || "/".equals(string) || "*".equals(string) || "POW".equals(string)) {
                return string;
            }
            return null;
        }

        public Object getConditionPartKey(String string) {
            return null;
        }

        public int getConditionPartCount() {
            return 0;
        }

        public Object getCommonFunctionKey(String string) {
            if ("LN".equals(string = string.toUpperCase()) || "LOG".equals(string) || "EXP".equals(string) || "SQR".equals(string) || "SQRT".equals(string) || "COS".equals(string) || "SIN".equals(string) || "TAN".equals(string) || "ARCCOS".equals(string) || "ARCSIN".equals(string) || "ARCTAN".equals(string) || "INV".equals(string)) {
                return string;
            }
            return null;
        }

        public Function getFunction(String string) {
            return null;
        }

        public int getBinaryOperatorPriority(Object object) {
            if ("+".equals(object)) {
                return 1;
            }
            if ("-".equals(object)) {
                return 1;
            }
            if ("/".equals(object)) {
                return 2;
            }
            if ("*".equals(object)) {
                return 2;
            }
            if ("POW".equals(object)) {
                return 3;
            }
            throw new IllegalArgumentException();
        }

        public String getAssignmentOperator() {
            return null;
        }

        public String getWhiteSpaceCharacters() {
            return " \t\n\r";
        }

        public char getOpeningBracket() {
            return '(';
        }

        public char getClosingBracket() {
            return ')';
        }

        public char getParameterSeparator() {
            return '\u0000';
        }

        public String getDelimiters() {
            return " \t\n\r-+*/().";
        }

        public boolean isCaseSensitive() {
            return false;
        }

        public boolean isShortSyntax() {
            return true;
        }

        public boolean isValidIdentifier(String string) {
            return false;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements Interpreter {
        public Object getLiteralValue(Object object) {
            return object;
        }

        public Object getParameterValue(Object object) {
            return null;
        }

        public Object getConstantValue(Object object) {
            return null;
        }

        public Object getUnaryOperatorValue(Object object, Object object2) {
            if (object.equals("+")) {
                return object2;
            }
            if (object.equals("-")) {
                return new Double(-((Number)object2).doubleValue());
            }
            throw new IllegalArgumentException("Not implemented");
        }

        public Object getBinaryOperatorValue(Object object, Object object2, Object object3) {
            if (object.equals("+")) {
                return new Double(((Number)object2).doubleValue() + ((Number)object3).doubleValue());
            }
            if (object.equals("-")) {
                return new Double(((Number)object2).doubleValue() - ((Number)object3).doubleValue());
            }
            if (object.equals("/")) {
                return new Double(((Number)object2).doubleValue() / ((Number)object3).doubleValue());
            }
            if (object.equals("*")) {
                return new Double(((Number)object2).doubleValue() * ((Number)object3).doubleValue());
            }
            if (object.equals("POW")) {
                return new Double(Math.pow(((Number)object2).doubleValue(), ((Number)object3).doubleValue()));
            }
            throw new IllegalArgumentException("Not implemented");
        }

        public Object getCommonFunctionValue(Object object, Object object2) {
            if (object.equals("LN")) {
                return new Double(Math.log(((Number)object2).doubleValue()));
            }
            if (object.equals("LOG")) {
                return new Double(Math.log(((Number)object2).doubleValue()) / Math.log(10.0));
            }
            if (object.equals("EXP")) {
                return new Double(Math.exp(((Number)object2).doubleValue()));
            }
            if (object.equals("SQR")) {
                return new Double(((Number)object2).doubleValue() * ((Number)object2).doubleValue());
            }
            if (object.equals("SQRT")) {
                return new Double(Math.sqrt(((Number)object2).doubleValue()));
            }
            if (object.equals("COS")) {
                return new Double(Math.cos(((Number)object2).doubleValue()));
            }
            if (object.equals("SIN")) {
                return new Double(Math.sin(((Number)object2).doubleValue()));
            }
            if (object.equals("TAN")) {
                return new Double(Math.tan(((Number)object2).doubleValue()));
            }
            if (object.equals("ARCCOS")) {
                return new Double(Math.acos(((Number)object2).doubleValue()));
            }
            if (object.equals("ARCSIN")) {
                return new Double(Math.asin(((Number)object2).doubleValue()));
            }
            if (object.equals("ARCTAN")) {
                return new Double(Math.atan(((Number)object2).doubleValue()));
            }
            if (object.equals("INV")) {
                return new Double(1.0 / ((Number)object2).doubleValue());
            }
            throw new IllegalArgumentException("Not implemented");
        }

        public Object getConditionValue(Object object, Object object2, Object object3) {
            return null;
        }

        public boolean isTrue(Object object) {
            return false;
        }

        public boolean supportsRecursiveCall() {
            return false;
        }

        public Object getFunctionValue(Function function, Object[] objectArray, boolean bl) {
            return null;
        }

        /* synthetic */ 2() {
        }
    }

    private class DigButton
    extends Button {
        public DigButton(String string) {
            super(string);
        }

        public Dimension preferredSize() {
            Dimension dimension = super.preferredSize();
            dimension.width = dimension.height * 5 / 4;
            return dimension;
        }
    }

    private class FuncButton
    extends Button {
        public FuncButton(String string) {
            super(string);
        }

        public Dimension preferredSize() {
            Dimension dimension = super.preferredSize();
            dimension.width = dimension.height * 5 / 2;
            return dimension;
        }
    }

    private final class 3
    extends Panel {
        public Insets insets() {
            return new Insets(1, 1, 1, 1);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends Frame {
        public boolean handleEvent(Event event) {
            switch (event.id) {
                case 201: {
                    this.dispose();
                    System.exit(0);
                    return true;
                }
            }
            return super.handleEvent(event);
        }

        /* synthetic */ 4(String string) {
            super(string);
        }
    }
}

