/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.jeks;

import com.eteks.jeks.CircularityException;
import com.eteks.jeks.JeksCell;
import com.eteks.jeks.JeksExpression;
import com.eteks.jeks.JeksExpressionParser;
import com.eteks.jeks.JeksExpressionSyntax;
import com.eteks.jeks.JeksFunctionSyntax;
import com.eteks.parser.CompilationException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;

public class JeksCellEditor
extends DefaultCellEditor {
    private JeksExpressionParser parser;
    private JTable table;
    private Object cellValue;

    public JeksCellEditor(JeksExpressionParser jeksExpressionParser) {
        super(new JTextField());
        JTextField jTextField = new JTextField();
        this.editorComponent = jTextField;
        this.delegate = new 1(jTextField, this, this);
        jTextField.addActionListener(this.delegate);
        this.parser = jeksExpressionParser;
    }

    public Object getCellEditorValue() {
        return this.cellValue;
    }

    public boolean stopCellEditing() {
        String string = (String)super.getCellEditorValue();
        this.cellValue = this.getModelValue(string, this.table.getModel(), new JeksCell(this.table.getEditingRow(), this.table.convertColumnIndexToModel(this.table.getEditingColumn())));
        if (this.cellValue == null) {
            return false;
        }
        return super.stopCellEditing();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.cellValue = object;
        object = this.getEditedValue(object);
        this.table = jTable;
        return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    public Object getEditedValue(Object object) {
        if (this.parser != null) {
            return this.parser.getEditedValue(object);
        }
        return object;
    }

    public Object getModelValue(String string, TableModel tableModel, JeksCell jeksCell) {
        try {
            if (this.parser != null) {
                Object object = this.parser.getModelValue(string);
                if (object instanceof JeksExpression) {
                    try {
                        ((JeksExpression)object).checkCircularity(tableModel, jeksCell);
                    }
                    catch (CircularityException circularityException) {
                        JeksExpressionSyntax jeksExpressionSyntax = (JeksExpressionSyntax)this.parser.getSyntax();
                        if (JOptionPane.showConfirmDialog(null, jeksExpressionSyntax.getMessage(JeksExpressionSyntax.MESSAGE_CIRCULARITY_ERROR_CONFIRM), jeksExpressionSyntax.getMessage(JeksExpressionSyntax.MESSAGE_CIRCULARITY_ERROR_TITLE), 0) == 1) {
                            return null;
                        }
                        ((JeksExpression)object).invalidateValue(circularityException);
                    }
                }
                return object;
            }
            return string;
        }
        catch (CompilationException compilationException) {
            JeksExpressionSyntax jeksExpressionSyntax = (JeksExpressionSyntax)this.parser.getSyntax();
            String string2 = jeksExpressionSyntax.getExceptionMessage(compilationException);
            JOptionPane.showMessageDialog(null, string2, jeksExpressionSyntax.getMessage(JeksFunctionSyntax.MESSAGE_COMPILATION_ERROR_TITLE), 0);
            return null;
        }
    }

    private static final class 1
    extends DefaultCellEditor.EditorDelegate {
        private final /* synthetic */ JeksCellEditor this$0;
        private final /* synthetic */ JTextField val$textField;

        public void setValue(Object object) {
            this.val$textField.setText(object != null ? object.toString() : "");
        }

        public Object getCellEditorValue() {
            return this.val$textField.getText();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.stopCellEditing()) {
                super.actionPerformed(actionEvent);
            }
        }

        /* synthetic */ 1(JTextField jTextField, JeksCellEditor jeksCellEditor, JeksCellEditor jeksCellEditor2) {
            super(jeksCellEditor2);
            this.val$textField = jTextField;
            this.this$0 = jeksCellEditor;
        }
    }
}

