/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.jeks;

import com.eteks.jeks.IllegalCellException;
import com.eteks.jeks.JeksCell;
import com.eteks.jeks.JeksExpression;
import com.eteks.jeks.JeksExpressionSyntax;
import com.eteks.jeks.JeksFunctionParser;
import com.eteks.jeks.JeksFunctionSyntax;
import com.eteks.jeks.JeksInterpreter;
import com.eteks.jeks.JeksParameter;
import com.eteks.parser.CompilationException;
import com.eteks.parser.CompiledExpression;
import com.eteks.parser.ExpressionParameter;
import com.eteks.parser.ExpressionParser;
import com.eteks.parser.Function;
import com.eteks.parser.FunctionParser;
import com.eteks.parser.Interpreter;
import com.eteks.parser.Parser;
import com.eteks.parser.Syntax;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.TableModel;

public class JeksExpressionParser
extends ExpressionParser {
    private NumberFormat numberParser;
    private DateFormat dateParser;
    private DateFormat timeParser;
    private DateFormat dateTimeParser;
    private JeksFunctionParser functionParser;
    private Interpreter interpreter;
    private Vector userFunctions = new Vector();
    static /* synthetic */ Class class$com$eteks$jeks$IllegalCellException;

    public JeksExpressionParser(TableModel tableModel) {
        this(tableModel, new JeksExpressionSyntax(), (Interpreter)new JeksInterpreter());
    }

    private JeksExpressionParser(TableModel tableModel, JeksExpressionSyntax jeksExpressionSyntax, Interpreter interpreter) {
        this(jeksExpressionSyntax, new JeksParameter(jeksExpressionSyntax, interpreter, tableModel), interpreter, new JeksFunctionParser(), null);
    }

    public JeksExpressionParser(JeksExpressionSyntax jeksExpressionSyntax, ExpressionParameter expressionParameter, Interpreter interpreter) {
        this(jeksExpressionSyntax, expressionParameter, interpreter, null, null);
    }

    public JeksExpressionParser(JeksExpressionSyntax jeksExpressionSyntax, ExpressionParameter expressionParameter, Interpreter interpreter, JeksFunctionParser jeksFunctionParser, Vector vector) {
        super(jeksExpressionSyntax, expressionParameter);
        this.functionParser = jeksFunctionParser;
        this.interpreter = interpreter;
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                this.addUserFunction((Function)vector.elementAt(n));
                ++n;
            }
        }
        this.numberParser = NumberFormat.getInstance(jeksExpressionSyntax.getLocale());
        this.dateParser = DateFormat.getDateInstance(3, jeksExpressionSyntax.getLocale());
        this.timeParser = DateFormat.getTimeInstance(3, jeksExpressionSyntax.getLocale());
        this.dateTimeParser = DateFormat.getDateTimeInstance(3, 3, jeksExpressionSyntax.getLocale());
    }

    public CompiledExpression compileExpression(String string) throws CompilationException {
        CompiledExpression compiledExpression = super.compileExpression(string);
        return new JeksExpression(compiledExpression);
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public JeksFunctionParser getFunctionParser() {
        return this.functionParser;
    }

    public Vector getUserFunctions() {
        return (Vector)this.userFunctions.clone();
    }

    public void addUserFunction(Function function) {
        this.userFunctions.addElement(function);
        ((JeksExpressionSyntax)this.getSyntax()).addFunction(function);
        if (this.functionParser != null) {
            ((JeksFunctionSyntax)this.functionParser.getSyntax()).addFunction(function);
        }
    }

    public void removeUserFunction(Function function) {
        this.userFunctions.removeElement(function);
        ((JeksExpressionSyntax)this.getSyntax()).removeFunction(function);
        if (this.functionParser != null) {
            ((JeksFunctionSyntax)this.functionParser.getSyntax()).removeFunction(function);
        }
    }

    public void removeAllUserFunctions() {
        int n = 0;
        while (n < this.userFunctions.size()) {
            Function function = (Function)this.userFunctions.elementAt(n);
            ((JeksExpressionSyntax)this.getSyntax()).removeFunction(function);
            if (this.functionParser != null) {
                ((JeksFunctionSyntax)this.functionParser.getSyntax()).removeFunction(function);
            }
            ++n;
        }
        this.userFunctions.removeAllElements();
    }

    public Object getEditedValue(Object object) {
        if (object instanceof JeksExpression) {
            return ((JeksExpression)object).getDefinition();
        }
        if (object instanceof Number) {
            return this.numberParser.format(object);
        }
        if (object instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) {
                return this.dateParser.format(object);
            }
            return this.dateTimeParser.format(object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? ((JeksExpressionSyntax)this.getSyntax()).getConstant(Syntax.CONSTANT_TRUE) : ((JeksExpressionSyntax)this.getSyntax()).getConstant(Syntax.CONSTANT_FALSE);
        }
        return object;
    }

    public Object getModelValue(String string) throws CompilationException {
        if (string.startsWith(this.getSyntax().getAssignmentOperator())) {
            return this.compileExpression(string);
        }
        return this.parseLitteral(string);
    }

    public Object parseLitteral(String string) {
        if ("".equals(string)) {
            return string;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Object object = this.numberParser.parse(string, parsePosition);
        if (parsePosition.getIndex() < string.length()) {
            parsePosition.setIndex(0);
            object = this.dateParser.parse(string, parsePosition);
            if (parsePosition.getIndex() < string.length()) {
                parsePosition.setIndex(0);
                object = this.dateTimeParser.parse(string, parsePosition);
                if (parsePosition.getIndex() < string.length()) {
                    parsePosition.setIndex(0);
                    object = this.timeParser.parse(string, parsePosition);
                    if (parsePosition.getIndex() > string.length()) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime((Date)object);
                        Calendar calendar2 = Calendar.getInstance();
                        calendar2.set(11, calendar.get(11));
                        calendar2.set(12, calendar.get(12));
                        calendar2.set(13, calendar.get(13));
                        object = calendar2.getTime();
                    } else {
                        object = Syntax.CONSTANT_TRUE.equals(this.getSyntax().getConstantKey(string)) ? Boolean.TRUE : (Syntax.CONSTANT_FALSE.equals(this.getSyntax().getConstantKey(string)) ? Boolean.FALSE : string);
                    }
                }
            }
        }
        return object;
    }

    public String shiftExpression(CompiledExpression compiledExpression, int n, int n2) {
        if (n == 0 && n2 == 0 || compiledExpression.getParameters().size() == 0) {
            return compiledExpression.getDefinition();
        }
        JeksExpressionSyntax jeksExpressionSyntax = (JeksExpressionSyntax)this.getSyntax();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(compiledExpression.getParameters().size());
        Enumeration enumeration = compiledExpression.getParameters().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = compiledExpression.getParameters().get(string);
            String string2 = jeksExpressionSyntax.getCellError(JeksExpressionSyntax.ERROR_ILLEGAL_CELL);
            try {
                if (!v.equals(class$com$eteks$jeks$IllegalCellException != null ? class$com$eteks$jeks$IllegalCellException : JeksExpressionParser.class$("com.eteks.jeks.IllegalCellException"))) {
                    if (v instanceof JeksCell) {
                        string2 = this.shiftCell(((JeksCell)v).getRow(), ((JeksCell)v).getColumn(), n, string.indexOf(jeksExpressionSyntax.getConstantChar(), 1) != -1, n2, string.charAt(0) == jeksExpressionSyntax.getConstantChar(), false);
                    } else {
                        int n3 = string.indexOf(jeksExpressionSyntax.getCellSetSeparator());
                        String string3 = string.substring(0, n3);
                        String string4 = string.substring(n3 + 1);
                        JeksCell jeksCell = jeksExpressionSyntax.getCellAt(string3);
                        JeksCell jeksCell2 = jeksExpressionSyntax.getCellAt(string4);
                        string2 = String.valueOf(this.shiftCell(jeksCell.getRow(), jeksCell.getColumn(), n, string3.indexOf(jeksExpressionSyntax.getConstantChar(), 1) != -1, n2, string3.charAt(0) == jeksExpressionSyntax.getConstantChar(), false)) + jeksExpressionSyntax.getCellSetSeparator() + this.shiftCell(jeksCell2.getRow(), jeksCell2.getColumn(), n, string4.indexOf(jeksExpressionSyntax.getConstantChar(), 1) != -1, n2, string4.charAt(0) == jeksExpressionSyntax.getConstantChar(), false);
                    }
                }
            }
            catch (IllegalCellException illegalCellException) {
                string2 = jeksExpressionSyntax.getCellError(JeksExpressionSyntax.ERROR_ILLEGAL_CELL);
            }
            hashtable.put(string, string2);
        }
        return this.replaceShiftedParameters(compiledExpression, hashtable);
    }

    public String shiftExpression(CompiledExpression compiledExpression, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n == 0 && n2 == 0 || compiledExpression.getParameters().size() == 0) {
            return compiledExpression.getDefinition();
        }
        JeksExpressionSyntax jeksExpressionSyntax = (JeksExpressionSyntax)this.getSyntax();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(compiledExpression.getParameters().size());
        Enumeration enumeration = compiledExpression.getParameters().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = compiledExpression.getParameters().get(string);
            String string2 = jeksExpressionSyntax.getCellError(JeksExpressionSyntax.ERROR_ILLEGAL_CELL);
            try {
                if (!v.equals(class$com$eteks$jeks$IllegalCellException != null ? class$com$eteks$jeks$IllegalCellException : JeksExpressionParser.class$("com.eteks.jeks.IllegalCellException"))) {
                    if (v instanceof JeksCell) {
                        JeksCell jeksCell = (JeksCell)v;
                        string2 = jeksCell.getRow() >= n3 && jeksCell.getRow() <= n5 && jeksCell.getColumn() >= n4 && jeksCell.getColumn() <= n6 ? this.shiftCell(((JeksCell)v).getRow(), ((JeksCell)v).getColumn(), n, string.indexOf(jeksExpressionSyntax.getConstantChar(), 1) != -1, n2, string.charAt(0) == jeksExpressionSyntax.getConstantChar(), true) : string;
                    } else {
                        int n7 = string.indexOf(jeksExpressionSyntax.getCellSetSeparator());
                        String string3 = string.substring(0, n7);
                        String string4 = string.substring(n7 + 1);
                        JeksCell jeksCell = jeksExpressionSyntax.getCellAt(string3);
                        JeksCell jeksCell2 = jeksExpressionSyntax.getCellAt(string4);
                        string2 = jeksCell.getRow() >= n3 && jeksCell.getRow() <= n5 && jeksCell.getColumn() >= n4 && jeksCell.getColumn() <= n6 ? this.shiftCell(jeksCell.getRow(), jeksCell.getColumn(), n, string3.indexOf(jeksExpressionSyntax.getConstantChar(), 1) != -1, n2, string3.charAt(0) == jeksExpressionSyntax.getConstantChar(), true) : string3;
                        string2 = String.valueOf(string2) + jeksExpressionSyntax.getCellSetSeparator();
                        string2 = jeksCell2.getRow() >= n3 && jeksCell2.getRow() <= n5 && jeksCell2.getColumn() >= n4 && jeksCell2.getColumn() <= n6 ? String.valueOf(string2) + this.shiftCell(jeksCell2.getRow(), jeksCell2.getColumn(), n, string4.indexOf(jeksExpressionSyntax.getConstantChar(), 1) != -1, n2, string4.charAt(0) == jeksExpressionSyntax.getConstantChar(), true) : String.valueOf(string2) + string4;
                    }
                }
            }
            catch (IllegalCellException illegalCellException) {
                string2 = jeksExpressionSyntax.getCellError(JeksExpressionSyntax.ERROR_ILLEGAL_CELL);
            }
            hashtable.put(string, string2);
        }
        return this.replaceShiftedParameters(compiledExpression, hashtable);
    }

    private String replaceShiftedParameters(CompiledExpression compiledExpression, Hashtable hashtable) {
        JeksExpressionSyntax jeksExpressionSyntax = (JeksExpressionSyntax)this.getSyntax();
        StringBuffer stringBuffer = new StringBuffer(jeksExpressionSyntax.getAssignmentOperator());
        Parser.Lexical lexical = null;
        int n = jeksExpressionSyntax.getAssignmentOperator().length();
        while (n < compiledExpression.getDefinition().length()) {
            String string;
            block6: {
                string = null;
                try {
                    lexical = this.getLexical(compiledExpression.getDefinition(), n, compiledExpression.getParameters());
                    if (lexical.getCode() != 10) break block6;
                    Enumeration enumeration = compiledExpression.getParameters().keys();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        if (!FunctionParser.compare(string2, lexical.getExtractedString(), jeksExpressionSyntax.isCaseSensitive())) continue;
                        string = string2;
                        break;
                    }
                }
                catch (CompilationException compilationException) {}
            }
            if (string != null) {
                stringBuffer.append(hashtable.get(string));
            } else {
                stringBuffer.append(lexical.getExtractedString());
            }
            n += lexical.getExtractedString().length();
        }
        return stringBuffer.toString();
    }

    private String shiftCell(int n, int n2, int n3, boolean bl, int n4, boolean bl2, boolean bl3) {
        int n5 = n + (bl3 || !bl ? n3 : 0);
        int n6 = n2 + (bl3 || !bl2 ? n4 : 0);
        if (n5 >= 0 && n6 >= 0) {
            return ((JeksExpressionSyntax)this.getSyntax()).toString(n5, bl, n6, bl2);
        }
        throw new IllegalCellException();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

