/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.jeks;

import com.eteks.jeks.IllegalCellException;
import com.eteks.jeks.JeksCell;
import com.eteks.jeks.JeksFunctionSyntax;
import com.eteks.parser.Function;
import com.eteks.parser.Interpreter;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public class JeksExpressionSyntax
extends JeksFunctionSyntax {
    private Hashtable cellErrors = new Hashtable();
    private Hashtable messages = new Hashtable();
    private char cellSetSeparator;
    private char constantChar;
    private char columnRangeMin = (char)65;
    private char columnRangeMax = (char)90;
    private char rowRangeMin = (char)48;
    private char rowRangeMax = (char)57;
    public static final Integer ERROR_ILLEGAL_CELL = new Integer(10000);
    public static final Integer ERROR_ILLEGAL_VALUE = new Integer(10001);
    public static final Integer ERROR_UNKNOWN_NAME = new Integer(10002);
    public static final Integer ERROR_INVALID_NUMBER = new Integer(10003);
    public static final Integer ERROR_DIVISION_BY_ZERO = new Integer(10004);
    public static final Integer ERROR_ERR = new Integer(10005);
    public static final Integer JEKS_FUNCTION_IF = new Integer(20000);
    public static final Integer MESSAGE_CIRCULARITY_ERROR_TITLE = new Integer(40000);
    public static final Integer MESSAGE_CIRCULARITY_ERROR_CONFIRM = new Integer(40001);
    public static final Integer MESSAGE_CIRCULARITY_ERROR_INFO = new Integer(40002);

    public JeksExpressionSyntax() {
        this(Locale.getDefault());
    }

    public JeksExpressionSyntax(Locale locale) {
        super(locale);
        String string;
        ResourceBundle.getBundle("com.eteks.jeks.resources.syntax", locale);
        this.setResourceString(this.cellErrors, "ERROR_ILLEGAL_CELL", ERROR_ILLEGAL_CELL);
        this.setResourceString(this.cellErrors, "ERROR_ILLEGAL_VALUE", ERROR_ILLEGAL_VALUE);
        this.setResourceString(this.cellErrors, "ERROR_UNKNOWN_NAME", ERROR_UNKNOWN_NAME);
        this.setResourceString(this.cellErrors, "ERROR_INVALID_NUMBER", ERROR_INVALID_NUMBER);
        this.setResourceString(this.cellErrors, "ERROR_DIVISION_BY_ZERO", ERROR_DIVISION_BY_ZERO);
        this.setResourceString(this.cellErrors, "ERROR_ERR", ERROR_ERR);
        this.setResourceJeksFunction("JEKS_FUNCTION_IF", JEKS_FUNCTION_IF, new JeksFunctionIf());
        this.setResourceString(this.messages, "MESSAGE_CIRCULARITY_ERROR_TITLE", MESSAGE_CIRCULARITY_ERROR_TITLE);
        this.setResourceString(this.messages, "MESSAGE_CIRCULARITY_ERROR_CONFIRM", MESSAGE_CIRCULARITY_ERROR_CONFIRM);
        this.setResourceString(this.messages, "MESSAGE_CIRCULARITY_ERROR_INFO", MESSAGE_CIRCULARITY_ERROR_INFO);
        this.cellSetSeparator = this.getResourceChar("CELL_SET_SEPARATOR");
        this.constantChar = this.getResourceChar("CONSTANT_CHAR");
        String string2 = this.getResourceString("COLUMN_LETTER_RANGE");
        if (string2 != null) {
            this.columnRangeMin = Character.toUpperCase(string2.charAt(0));
            this.columnRangeMax = Character.toUpperCase(string2.charAt(1));
        }
        if ((string = this.getResourceString("ROW_DIGIT_RANGE")) != null) {
            this.rowRangeMin = Character.toUpperCase(string.charAt(0));
            this.rowRangeMax = Character.toUpperCase(string.charAt(1));
        }
    }

    public String getCellError(Object object) {
        return (String)this.cellErrors.get(object);
    }

    public String getCellError(Throwable throwable) {
        if (throwable instanceof IllegalCellException) {
            return this.getCellError(ERROR_ILLEGAL_CELL);
        }
        if (throwable instanceof IndexOutOfBoundsException) {
            return this.getCellError(ERROR_UNKNOWN_NAME);
        }
        if (throwable instanceof IllegalArgumentException) {
            return this.getCellError(ERROR_ILLEGAL_VALUE);
        }
        if (throwable instanceof ArithmeticException) {
            return this.getCellError(ERROR_DIVISION_BY_ZERO);
        }
        if (throwable instanceof Exception) {
            return this.getCellError(ERROR_ERR);
        }
        if (throwable instanceof StackOverflowError) {
            return this.getCellError(ERROR_ERR);
        }
        return null;
    }

    public Object getConditionPartKey(String string) {
        return null;
    }

    public String getMessage(Object object) {
        String string = (String)this.messages.get(object);
        return string != null ? string : super.getMessage(object);
    }

    public char getCellSetSeparator() {
        return this.cellSetSeparator;
    }

    public char getConstantChar() {
        return this.constantChar;
    }

    public boolean isValidIdentifier(String string) {
        return super.isValidIdentifier(string) || this.isCellIdentifier(string);
    }

    private boolean isColumnLetter(char c) {
        return (c = Character.toUpperCase(c)) >= this.columnRangeMin && c <= this.columnRangeMax;
    }

    private boolean isRowDigit(char c) {
        return c >= this.rowRangeMin && c <= this.rowRangeMax;
    }

    public boolean isCellIdentifier(String string) {
        if (string.equals(this.getCellError(ERROR_ILLEGAL_CELL))) {
            return true;
        }
        if (string.length() < 2) {
            return false;
        }
        int n = 0;
        if (string.charAt(0) == this.getConstantChar()) {
            ++n;
        }
        if (!this.isColumnLetter(string.charAt(n))) {
            return false;
        }
        while (++n < string.length() && this.isColumnLetter(string.charAt(n))) {
        }
        if (n == string.length()) {
            return false;
        }
        if (string.charAt(n) == this.getConstantChar()) {
            ++n;
        }
        if (n == string.length() || !this.isRowDigit(string.charAt(n))) {
            return false;
        }
        while (++n < string.length() && this.isRowDigit(string.charAt(n))) {
        }
        if (n < string.length() - 2 && string.charAt(n) == this.getCellSetSeparator()) {
            if (string.charAt(++n) == this.getConstantChar()) {
                ++n;
            }
            if (!this.isColumnLetter(string.charAt(n))) {
                return false;
            }
            while (++n < string.length() && this.isColumnLetter(string.charAt(n))) {
            }
            if (n == string.length()) {
                return false;
            }
            if (string.charAt(n) == this.getConstantChar()) {
                ++n;
            }
            if (n == string.length() || !this.isRowDigit(string.charAt(n))) {
                return false;
            }
            while (++n < string.length() && this.isRowDigit(string.charAt(n))) {
            }
        }
        return n == string.length();
    }

    public JeksCell getCellAt(String string) {
        int n;
        int n2 = 0;
        if (string.charAt(n2) == this.getConstantChar()) {
            ++n2;
        }
        int n3 = n2;
        while (this.isColumnLetter(string.charAt(n3))) {
            ++n3;
        }
        int n4 = n3;
        if (string.charAt(n3) == this.getConstantChar()) {
            ++n3;
        }
        int n5 = 0;
        int n6 = n2;
        while (n6 < n4) {
            n5 = n5 * (this.columnRangeMax - this.columnRangeMin + 1) + Character.toUpperCase(string.charAt(n6)) - this.columnRangeMin + 1;
            ++n6;
        }
        try {
            n = this.getNumberFormat().parse(string.substring(n3)).intValue() - 1;
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(string);
        }
        return new JeksCell(n, --n5);
    }

    public String getRowName(int n) {
        return this.getNumberFormat().format(n + 1);
    }

    public String getColumnName(int n) {
        String string = "";
        while (n >= 0) {
            string = String.valueOf((char)((char)(n % (this.columnRangeMax - this.columnRangeMin + 1)) + this.columnRangeMin)) + string;
            n = n / (this.columnRangeMax - this.columnRangeMin + 1) - 1;
        }
        return string;
    }

    public String toString(JeksCell jeksCell) {
        return this.toString(jeksCell.getRow(), false, jeksCell.getColumn(), false);
    }

    public String toString(int n, boolean bl, int n2, boolean bl2) {
        if (this.getConstantChar() != '\u0000') {
            return String.valueOf(bl2 ? String.valueOf(this.getConstantChar()) : "") + this.getColumnName(n2) + (bl ? String.valueOf(this.getConstantChar()) : "") + this.getRowName(n);
        }
        return String.valueOf(this.getColumnName(n2)) + this.getRowName(n);
    }

    private class JeksFunctionIf
    implements Function {
        public String getName() {
            return JeksExpressionSyntax.this.getJeksFunction(JEKS_FUNCTION_IF);
        }

        public boolean isValidParameterCount(int n) {
            return n == 3;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            return interpreter.isTrue(objectArray[0]) ? objectArray[1] : objectArray[2];
        }

        JeksFunctionIf() {
        }
    }
}

