/*
 * Decompiled with CFR 0.152.
 */
import com.eteks.parser.CompilationException;
import com.eteks.parser.CompiledFunction;
import com.eteks.parser.Function;
import com.eteks.parser.FunctionParser;
import com.eteks.parser.JavaSyntax;
import com.eteks.parser.Syntax;
import com.eteks.tools.awt.GridBagConstraints2;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Window;

public class JeksJavaPerformanceTest {
    public static void main(String[] stringArray) {
        JeksJavaPerformanceTest.showFirstDialog();
        FunctionTest[] functionTestArray = new FunctionTest[]{new OperatorsTest(), new CommonFunctionsTest(), new MultipleFunctionsTest()};
        JeksJavaPerformanceTest.showSpeedMeterDialog(functionTestArray);
    }

    private static void showFirstDialog() {
        1 var0 = new 1(new Frame(), "Jeks parser", true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        var0.setLayout(gridBagLayout);
        Component component = new Label("Jeks parser / Java performance test.");
        var0.add(component);
        gridBagLayout.setConstraints(component, new GridBagConstraints2(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        component = new Label("\u00a9 Copyright 1998-2001 eTeks <info@eteks.com>.");
        var0.add(component);
        gridBagLayout.setConstraints(component, new GridBagConstraints2(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 20, 5), 0, 0));
        component = new Button(" Ok ");
        var0.add(component);
        gridBagLayout.setConstraints(component, new GridBagConstraints2(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 10, 0), 0, 0));
        var0.setResizable(false);
        var0.pack();
        ((Window)var0).show();
    }

    private static void showSpeedMeterDialog(FunctionTest[] functionTestArray) {
        2 var1_1 = new 2(new Frame(), "Average computation duration", false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        var1_1.setLayout(gridBagLayout);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(functionTestArray.length + 1, 1, 0, 10));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(functionTestArray.length + 1, 3, 10, 10));
        panel.add(new Label(""));
        panel2.add(new Label("Jeks (\u00b5s)", 1));
        panel2.add(new Label("Java (\u00b5s)", 1));
        panel2.add(new Label("Ratio (Jeks/Java)", 1));
        Label[] labelArray = new Label[functionTestArray.length];
        Label[] labelArray2 = new Label[functionTestArray.length];
        Label[] labelArray3 = new Label[functionTestArray.length];
        int n = 0;
        while (n < functionTestArray.length) {
            panel.add(new Label(functionTestArray[n].toString()));
            labelArray[n] = new Label("0000000 ", 2);
            labelArray[n].setForeground(Color.green);
            labelArray[n].setBackground(Color.black);
            panel2.add(labelArray[n]);
            labelArray2[n] = new Label("0000000 ", 2);
            labelArray2[n].setForeground(Color.red);
            labelArray2[n].setBackground(Color.black);
            panel2.add(labelArray2[n]);
            labelArray3[n] = new Label("      1 ", 2);
            labelArray3[n].setForeground(Color.lightGray);
            labelArray3[n].setBackground(Color.black);
            panel2.add(labelArray3[n]);
            ++n;
        }
        var1_1.add(panel);
        gridBagLayout.setConstraints(panel, new GridBagConstraints2(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        var1_1.add(panel2);
        gridBagLayout.setConstraints(panel2, new GridBagConstraints2(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 0, 10, 10), 0, 0));
        Button button = new Button(" Quit ");
        var1_1.add(button);
        gridBagLayout.setConstraints(button, new GridBagConstraints2(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
        var1_1.setResizable(false);
        var1_1.pack();
        ((Window)var1_1).show();
        long[] lArray = new long[functionTestArray.length];
        long[] lArray2 = new long[functionTestArray.length];
        int n2 = 1;
        while (true) {
            int n3 = 0;
            while (n3 < functionTestArray.length) {
                long l = System.currentTimeMillis();
                int n4 = n3;
                lArray[n4] = lArray[n4] + JeksJavaPerformanceTest.getJeksTestDuration(functionTestArray[n3]);
                labelArray[n3].setText(String.valueOf(String.valueOf((float)lArray[n3] * 1000.0f / (float)(n2 * functionTestArray[n3].getLoopCount()))) + " ");
                int n5 = n3;
                lArray2[n5] = lArray2[n5] + JeksJavaPerformanceTest.getJavaTestDuration(functionTestArray[n3]);
                labelArray2[n3].setText(String.valueOf(String.valueOf((float)lArray2[n3] * 1000.0f / (float)(n2 * functionTestArray[n3].getLoopCount()))) + " ");
                labelArray3[n3].setText(lArray2[n3] != 0L ? String.valueOf(String.valueOf((int)Math.round((double)lArray[n3] / (double)lArray2[n3]))) + " " : "");
                try {
                    long l2 = System.currentTimeMillis() - l;
                    Thread.sleep(l2 < 50L ? 100L - l2 : 100L);
                }
                catch (InterruptedException interruptedException) {}
                ++n3;
            }
            ++n2;
        }
    }

    private static long getJeksTestDuration(FunctionTest functionTest) {
        System.gc();
        long l = System.currentTimeMillis();
        int n = functionTest.getLoopCount();
        while (n-- > 0) {
            functionTest.computeJeksFunction();
        }
        return System.currentTimeMillis() - l;
    }

    private static long getJavaTestDuration(FunctionTest functionTest) {
        System.gc();
        long l = System.currentTimeMillis();
        int n = functionTest.getLoopCount() * 100;
        while (n-- > 0) {
            functionTest.computeJavaFunction();
        }
        return (System.currentTimeMillis() - l) / 100L;
    }

    private final class 1
    extends Dialog {
        public boolean action(Event event, Object object) {
            this.dispose();
            return true;
        }

        /* synthetic */ 1(Frame frame, String string, boolean bl) {
            super(frame, string, bl);
        }
    }

    static interface FunctionTest {
        public static final FunctionParser PARSER = new FunctionParser((Syntax)new JavaSyntax());

        public double computeJeksFunction();

        public double computeJavaFunction();

        public int getLoopCount();
    }

    static class OperatorsTest
    implements FunctionTest {
        CompiledFunction function;

        public OperatorsTest() {
            try {
                this.function = FunctionTest.PARSER.compileFunction("func (x) = Math.PI * +x * (x + -x / 3.) - 5E-2");
                if (this.computeJeksFunction() != this.computeJavaFunction()) {
                    throw new RuntimeException("Jeks and Java give different results !");
                }
            }
            catch (CompilationException compilationException) {
                compilationException.printStackTrace();
                System.exit(0);
            }
        }

        public double computeJeksFunction() {
            return this.function.computeFunction(new double[]{10.0});
        }

        public double computeJavaFunction() {
            return this.func(10.0);
        }

        public double func(double d) {
            return Math.PI * d * (d + -d / 3.0) - 0.05;
        }

        public int getLoopCount() {
            return 50000;
        }

        public String toString() {
            return "Operators : Math.PI * +x * (x + -x / 3) - 5E-2";
        }
    }

    static class CommonFunctionsTest
    implements FunctionTest {
        CompiledFunction function;

        public CommonFunctionsTest() {
            try {
                this.function = FunctionTest.PARSER.compileFunction("func (x, y) = Math.cos (x) * Math.sin (y) + Math.pow (x / y, 1.2)");
                if (this.computeJeksFunction() != this.computeJavaFunction()) {
                    throw new RuntimeException("Jeks and Java give different results !");
                }
            }
            catch (CompilationException compilationException) {
                compilationException.printStackTrace();
                System.exit(0);
            }
        }

        public double computeJeksFunction() {
            return this.function.computeFunction(new double[]{5.33, 4.5});
        }

        public double computeJavaFunction() {
            return this.func(5.33, 4.5);
        }

        public double func(double d, double d2) {
            return Math.cos(d) * Math.sin(d2) + Math.pow(d / d2, 1.2);
        }

        public int getLoopCount() {
            return 10000;
        }

        public String toString() {
            return "CommonFunctions : Math.cos (x) * Math.sin (y) + Math.pow (x / y, 1.2)";
        }
    }

    static class MultipleFunctionsTest
    implements FunctionTest {
        CompiledFunction function;

        public MultipleFunctionsTest() {
            try {
                this.function = FunctionTest.PARSER.compileFunction("capitalPaid (rate, count, capital, testedPMT)= count <= 0 ? 0 : testedPMT - capital * rate + capitalPaid (rate, count - 1, capital - (testedPMT - capital * rate), testedPMT)");
                ((JavaSyntax)FunctionTest.PARSER.getSyntax()).addFunction((Function)this.function);
                this.function = FunctionTest.PARSER.compileFunction("computePMT (rate, count, capital, capitalPaid1, capitalPaid2, testedPMT1, testedPMT2)=Math.abs (capitalPaid1 - capital) < 0.01 ? testedPMT1 : Math.abs (capitalPaid1 - capital) < Math.abs (capitalPaid2 - capital) ? computePMT (rate, count, capital, capitalPaid1, capitalPaid (rate, count, capital, testedPMT2 - (testedPMT2 - testedPMT1) / 2), testedPMT1, testedPMT2 - (testedPMT2 - testedPMT1) / 2) : computePMT (rate, count, capital, capitalPaid (rate, count, capital, testedPMT1 + (testedPMT2 - testedPMT1) / 2), capitalPaid2, testedPMT1 + (testedPMT2 - testedPMT1) / 2, testedPMT2)");
                ((JavaSyntax)FunctionTest.PARSER.getSyntax()).addFunction((Function)this.function);
                this.function = FunctionTest.PARSER.compileFunction("PMT (rate, count, capital)=computePMT (rate, count, capital, capitalPaid (rate, count, capital, capital / count), capitalPaid (rate, count, capital, capital * Math.pow ((1 + rate), count)) / count, capital / count, capital * Math.pow ((1 + rate), count) / count)");
                if (this.computeJeksFunction() != this.computeJavaFunction()) {
                    throw new RuntimeException("Jeks and Java give different results !");
                }
            }
            catch (CompilationException compilationException) {
                compilationException.printStackTrace();
                System.exit(0);
            }
        }

        public double computeJeksFunction() {
            return this.function.computeFunction(new double[]{0.065, 60.0, 10000.0});
        }

        public double computeJavaFunction() {
            return this.PMT(0.065, 60.0, 10000.0);
        }

        public double capitalPaid(double d, double d2, double d3, double d4) {
            return d2 <= 0.0 ? 0.0 : d4 - d3 * d + this.capitalPaid(d, d2 - 1.0, d3 - (d4 - d3 * d), d4);
        }

        public double computePMT(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
            return Math.abs(d4 - d3) < 0.01 ? d6 : (Math.abs(d4 - d3) < Math.abs(d5 - d3) ? this.computePMT(d, d2, d3, d4, this.capitalPaid(d, d2, d3, d7 - (d7 - d6) / 2.0), d6, d7 - (d7 - d6) / 2.0) : this.computePMT(d, d2, d3, this.capitalPaid(d, d2, d3, d6 + (d7 - d6) / 2.0), d5, d6 + (d7 - d6) / 2.0, d7));
        }

        public double PMT(double d, double d2, double d3) {
            return this.computePMT(d, d2, d3, this.capitalPaid(d, d2, d3, d3 / d2), this.capitalPaid(d, d2, d3, d3 * Math.pow(1.0 + d, d2)) / d2, d3 / d2, d3 * Math.pow(1.0 + d, d2) / d2);
        }

        public int getLoopCount() {
            return 100;
        }

        public String toString() {
            return "MultipleFunctions : PMT (rate, count, capital) = computePMT (...)";
        }
    }

    private final class 2
    extends Dialog {
        public boolean action(Event event, Object object) {
            System.exit(0);
            return true;
        }

        /* synthetic */ 2(Frame frame, String string, boolean bl) {
            super(frame, string, bl);
        }
    }
}

