/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.tools.awt;

import com.eteks.parser.CompiledFunction;
import com.eteks.tools.d3d.Matrix3D;
import com.eteks.tools.d3d.Point3D;
import com.eteks.tools.d3d.Vector3D;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;

public class Curve3DDisplay
extends Canvas {
    private float[][] values;
    private Point3D[][] points3D;
    private double minimumX;
    private double maximumX;
    private int displayMode = 2;
    private Image bitmap;
    private int meshSize = 50;
    private static final int DEFAULT_X_ANGLE = 20;
    private static final int DEFAULT_Y_ANGLE = 45;
    private static final int DEFAULT_Z_ANGLE = 0;
    private static final float DEFAULT_DISTANCE = 4.0f;
    private static final float DEFAULT_TRANSLATION = 0.0f;
    private static final int DEFAULT_MESH_SIZE = 50;
    private int mouseX;
    private int mouseY;
    private int angleX = 20;
    private int angleY = 45;
    private int angleZ = 0;
    private float distance = 4.0f;
    private float translationX = 0.0f;
    private float translationY = 0.0f;
    private float translationZ = 0.0f;
    private float userDistance;
    private Color curveColor = Color.white;
    private Color curveBackColor = Color.blue.darker().darker().darker();
    private Color curvePolygonOutlineColor = Color.darkGray;
    private Color curveMeshColor = Color.black;
    private Vector3D lightDirection = new Vector3D(0.25f, -0.25f, -1.0f);
    private float lightValue = 1.25f;
    private float kd = 0.7f;
    private float ambientLightValue = 0.25f;
    private float ka = 0.7f;
    public static final int DISPLAY_WITH_LIGHTING = 0;
    public static final int DISPLAY_MESH = 1;
    public static final int DISPLAY_ALL_MESH = 2;

    public void computeCurve(CompiledFunction compiledFunction, double d, double d2, int n) {
        this.minimumX = d;
        this.maximumX = d2;
        this.meshSize = n;
        this.distance -= (float)d;
        this.computeValuesArray(compiledFunction, new Double(d), new Double(d2), new Double((d2 - d) / (double)n), new Double(d), new Double(d2), new Double((d2 - d) / (double)n));
    }

    public void setDisplayMode(int n) {
        this.displayMode = n;
        this.invalidateSurface();
    }

    public void setDefaultPosition() {
        this.angleX = 20;
        this.angleY = 45;
        this.angleZ = 0;
        this.distance = 4.0f;
        this.translationX = 0.0f;
        this.translationY = 0.0f;
        this.translationZ = 0.0f;
        this.invalidateSurface();
    }

    private void invalidateSurface() {
        this.points3D = null;
        if (this.values != null) {
            this.repaint();
        }
    }

    private synchronized void computeValuesArray(CompiledFunction compiledFunction, Double d, Double d2, Double d3, Double d4, Double d5, Double d6) {
        Double d7;
        double[] dArray = new double[2];
        float f = (float)d3.doubleValue();
        float f2 = (float)d6.doubleValue();
        if (d > d2) {
            d7 = d;
            d = d2;
            d2 = d7;
        }
        if (d4 > d4) {
            d5 = d7 = d4;
        }
        int n = 1 + (int)((d2 - d) / d3);
        int n2 = 1 + (int)((d5 - d4) / d6);
        this.values = new float[n + 1][n2 + 1];
        float f3 = (float)d.doubleValue();
        int n3 = 1;
        while (n3 <= n) {
            this.values[n3][0] = f3;
            dArray[0] = f3;
            float f4 = (float)d4.doubleValue();
            int n4 = 1;
            while (n4 <= n2) {
                if (n3 == 1) {
                    this.values[0][n4] = f4;
                }
                dArray[1] = f4;
                this.values[n3][n4] = (float)compiledFunction.computeFunction(dArray);
                f4 += f2;
                ++n4;
            }
            f3 += f;
            ++n3;
        }
        this.invalidateSurface();
    }

    private synchronized void compute3DPoints() {
        if (this.values == null) {
            return;
        }
        this.points3D = new Point3D[this.values.length - 1][this.values[0].length - 1];
        Point3D point3D = new Point3D(0.0f, 0.0f, 0.0f);
        float f = (float)this.angleX * (float)Math.PI / 180.0f;
        float f2 = (float)this.angleY * (float)Math.PI / 180.0f;
        float f3 = (float)this.angleZ * (float)Math.PI / 180.0f;
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 2;
        int[] nArray2 = nArray;
        Vector3D vector3D = new Vector3D(this.translationX, -this.translationY, -this.translationZ);
        Dimension dimension = this.size();
        float f4 = (float)Math.min(dimension.width, dimension.height) / (float)(this.maximumX - this.minimumX);
        this.userDistance = -this.distance * f4;
        Matrix3D matrix3D = Matrix3D.getDisplayMatrix(point3D, new Vector3D(f, f2, f3), nArray2, vector3D, 0.0f, 0.0f, this.distance, new Point3D(dimension.width / 2, dimension.height / 2, 0.0f), new Vector3D(f4, -f4, f4));
        int n = 0;
        while (n < this.points3D.length) {
            int n2 = 0;
            while (n2 < this.points3D[0].length) {
                this.points3D[n][n2] = new Point3D(this.values[n + 1][0], this.values[n + 1][n2 + 1], this.values[0][n2 + 1]).multiplyMatrixByPoint(matrix3D);
                ++n2;
            }
            ++n;
        }
    }

    private Color getTriangleColor(Point3D point3D, Point3D point3D2, Point3D point3D3) {
        Vector3D vector3D = new Vector3D(point3D, point3D2).getCrossProduct(new Vector3D(point3D, point3D3));
        if (vector3D.getZ() <= 0.0f) {
            return this.curveBackColor;
        }
        float f = vector3D.getDotProduct(this.lightDirection) / (vector3D.getLength() * this.lightDirection.getLength());
        float f2 = this.kd * this.lightValue * Math.abs(f) + this.ka * this.ambientLightValue;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return new Color((int)((float)this.curveColor.getRed() * f2), (int)((float)this.curveColor.getGreen() * f2), (int)((float)this.curveColor.getBlue() * f2));
    }

    private void displayPolygon(Graphics graphics, boolean bl, int n, int n2) {
        Dimension[] dimensionArray = new Dimension[4];
        boolean bl2 = true;
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 0;
            while (n4 < 2) {
                if (Double.isNaN(this.values[n + 1 + n3][n2 + 1 + n4])) {
                    return;
                }
                float f = Math.round(this.points3D[n + n3][n2 + n4].getX());
                float f2 = Math.round(this.points3D[n + n3][n2 + n4].getY());
                dimensionArray[2 * n3 + n4] = new Dimension((int)f, (int)f2);
                if (bl2) {
                    bl2 = !this.inside(dimensionArray[2 * n3 + n4].width, dimensionArray[2 * n3 + n4].height) || this.points3D[n + n3][n2 + n4].getZ() < this.userDistance;
                }
                ++n4;
            }
            ++n3;
        }
        if (bl2) {
            return;
        }
        graphics.setColor(bl ? this.getTriangleColor(this.points3D[n][n2], this.points3D[n + 1][n2], this.points3D[n][n2 + 1]) : this.curveColor);
        Polygon polygon = new Polygon();
        polygon.addPoint(dimensionArray[0].width, dimensionArray[0].height);
        polygon.addPoint(dimensionArray[1].width, dimensionArray[1].height);
        polygon.addPoint(dimensionArray[3].width, dimensionArray[3].height);
        polygon.addPoint(dimensionArray[2].width, dimensionArray[2].height);
        graphics.fillPolygon(polygon);
        polygon.addPoint(dimensionArray[0].width, dimensionArray[0].height);
        graphics.setColor(this.curvePolygonOutlineColor);
        graphics.drawPolygon(polygon);
    }

    private void displaySurface(Graphics graphics, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        int n7 = 1;
        Point3D point3D = this.points3D[0][0];
        int n8 = 0;
        while (n8 < this.points3D.length) {
            n = 0;
            while (n < this.points3D[0].length) {
                if ((n8 != 0 || n != 0) && this.points3D[n8][n].getZ() < point3D.getZ()) {
                    point3D = this.points3D[n8][n];
                    n2 = n8;
                    n3 = n;
                }
                n += this.points3D[0].length - 1;
            }
            n8 += this.points3D.length - 1;
        }
        n4 = n2 == 0 ? this.points3D.length - 1 : 0;
        n5 = n3 == 0 ? this.points3D[0].length - 1 : 0;
        int n9 = n = !(this.points3D[n4][n3].getZ() < this.points3D[n2][n5].getZ()) ? 0 : 1;
        if (n2 != 0) {
            --n2;
            n4 = -1;
            n6 = -1;
        }
        if (n3 != 0) {
            --n3;
            n5 = -1;
            n7 = -1;
        }
        if (n == 0) {
            int n10 = n2;
            while (n10 != n4) {
                int n11 = n3;
                while (n11 != n5) {
                    this.displayPolygon(graphics, bl, n10, n11);
                    n11 += n7;
                }
                n10 += n6;
            }
        } else {
            int n12 = n3;
            while (n12 != n5) {
                int n13 = n2;
                while (n13 != n4) {
                    this.displayPolygon(graphics, bl, n13, n12);
                    n13 += n6;
                }
                n12 += n7;
            }
        }
    }

    private void displayMesh(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        graphics.setColor(this.curveMeshColor);
        int n6 = 0;
        while (n6 < this.points3D.length) {
            n5 = 1;
            while (n5 < this.points3D[0].length) {
                if (this.values[n6 + 1][n5] == this.values[n6 + 1][n5] && this.values[n6 + 1][n5 + 1] == this.values[n6 + 1][n5 + 1]) {
                    n4 = (int)this.points3D[n6][n5 - 1].getX();
                    n3 = (int)this.points3D[n6][n5 - 1].getY();
                    n2 = (int)this.points3D[n6][n5].getX();
                    n = (int)this.points3D[n6][n5].getY();
                    if (this.inside(n4, n3) && this.points3D[n6][n5 - 1].getZ() >= this.userDistance || this.inside(n2, n) && this.points3D[n6][n5].getZ() >= this.userDistance) {
                        graphics.drawLine(n4, n3, n2, n);
                    }
                }
                ++n5;
            }
            ++n6;
        }
        n5 = 0;
        while (n5 < this.points3D[0].length) {
            n4 = 1;
            while (n4 < this.points3D.length) {
                if (this.values[n4][n5 + 1] == this.values[n4][n5 + 1] && this.values[n4 + 1][n5 + 1] == this.values[n4 + 1][n5 + 1]) {
                    n3 = (int)this.points3D[n4 - 1][n5].getX();
                    n2 = (int)this.points3D[n4 - 1][n5].getY();
                    n = (int)this.points3D[n4][n5].getX();
                    int n7 = (int)this.points3D[n4][n5].getY();
                    if (this.inside(n3, n2) && this.points3D[n4 - 1][n5].getZ() >= this.userDistance || this.inside(n, n7) && this.points3D[n4][n5].getZ() >= this.userDistance) {
                        graphics.drawLine(n3, n2, n, n7);
                    }
                }
                ++n4;
            }
            ++n5;
        }
    }

    public Dimension preferredSize() {
        return new Dimension(300, 200);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.bitmap == null) {
            Dimension dimension = this.size();
            this.bitmap = this.createImage(dimension.width, dimension.height);
            this.paintSurface(this.bitmap.getGraphics());
        } else if (this.points3D == null) {
            this.paintSurface(this.bitmap.getGraphics());
        }
        graphics.drawImage(this.bitmap, 0, 0, this);
    }

    private synchronized void paintSurface(Graphics graphics) {
        Dimension dimension = this.size();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.points3D == null) {
            this.compute3DPoints();
        }
        if (this.points3D != null) {
            switch (this.displayMode) {
                case 0: {
                    this.displaySurface(graphics, true);
                    break;
                }
                case 1: {
                    this.displaySurface(graphics, false);
                    break;
                }
                case 2: {
                    this.displayMesh(graphics);
                    break;
                }
            }
        }
        graphics.setColor(this.getBackground());
        graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, false);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.mouseX = n;
        this.mouseY = n2;
        return super.mouseDown(event, n, n2);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.points3D != null) {
            Dimension dimension = this.size();
            if ((event.modifiers & 1) != 0) {
                this.translationX += (float)((n - this.mouseX) * 5) * (float)(this.maximumX - this.minimumX) / (float)dimension.height;
                this.translationY += (float)((n2 - this.mouseY) * 5) * (float)(this.maximumX - this.minimumX) / (float)dimension.height;
            } else if ((event.modifiers & 2) != 0) {
                this.angleZ = (this.angleZ + (n - this.mouseX) * 180 / dimension.width) % 360;
                this.translationZ = Math.max(this.translationZ + (float)((this.mouseY - n2) * 5) * (float)(this.maximumX - this.minimumX) / (float)dimension.height, (float)this.minimumX - this.distance);
            } else {
                this.angleY = (this.angleY + (n - this.mouseX) * 180 / dimension.width) % 360;
                this.angleX = (this.angleX + (n2 - this.mouseY) * 180 / dimension.height) % 360;
            }
            this.mouseX = n;
            this.mouseY = n2;
            this.invalidateSurface();
            return true;
        }
        return super.mouseDrag(event, n, n2);
    }
}

