/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AddressField
extends JTextField {
    public CellPoint getAddress() {
        return Formula.parseAddress(this.getText());
    }

    public void setAddress(CellPoint cellPoint) {
        if (cellPoint == null) {
            this.setText(null);
        } else {
            this.setText(cellPoint.toString());
        }
    }

    public AddressField(int n) {
        super(n);
        this.setDocument(new NumberFilterDocument());
    }

    class NumberFilterDocument
    extends PlainDocument {
        private StringBuffer __scratchBuffer = new StringBuffer();

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || string.length() == 0) {
                return;
            }
            this.__scratchBuffer.setLength(0);
            try {
                this.__scratchBuffer.append(this.getText(0, this.getLength()));
                this.__scratchBuffer.insert(n, string);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                stringIndexOutOfBoundsException.printStackTrace();
                return;
            }
            String string2 = this.__scratchBuffer.toString();
            boolean bl = false;
            int n2 = 0;
            while (n2 < string2.length()) {
                char c = string2.charAt(n2);
                if (!Character.isLetter(c)) {
                    if (!Character.isDigit(c) || n2 <= 0) return;
                    bl = true;
                } else if (bl) {
                    return;
                }
                ++n2;
            }
            super.insertString(n, string.toUpperCase(), attributeSet);
        }
    }
}

