/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class EditOp
implements ActionListener {
    private SharpTools sharp;
    private JTable table;
    private SharpTableModel tableModel;
    private History history;
    private JToolBar toolBar;
    private CellPoint copyPoint = new CellPoint(SharpTools.baseRow, SharpTools.baseCol);
    private Clipboard system;
    private String findValue;
    private boolean matchCase = false;
    private boolean matchCell = false;
    private static final ImageIcon fillIcon = SharpTools.getImageIcon("fill32.gif");
    private static final ImageIcon findIcon = SharpTools.getImageIcon("find32.gif");

    EditOp(SharpTools sharpTools) {
        this.sharp = sharpTools;
        this.table = sharpTools.getTable();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(90, 2, false);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(89, 2, false);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(88, 2, false);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(86, 2, false);
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke(76, 2, false);
        KeyStroke keyStroke7 = KeyStroke.getKeyStroke(127, 0, false);
        KeyStroke keyStroke8 = KeyStroke.getKeyStroke(70, 2, false);
        KeyStroke keyStroke9 = KeyStroke.getKeyStroke(114, 0, false);
        this.table.registerKeyboardAction(this, "Undo", keyStroke, 0);
        this.table.registerKeyboardAction(this, "Redo", keyStroke2, 0);
        this.table.registerKeyboardAction(this, "Cut", keyStroke3, 0);
        this.table.registerKeyboardAction(this, "Copy", keyStroke4, 0);
        this.table.registerKeyboardAction(this, "Paste", keyStroke5, 0);
        this.table.registerKeyboardAction(this, "Fill", keyStroke6, 0);
        this.table.registerKeyboardAction(this, "Clear", keyStroke7, 0);
        this.table.registerKeyboardAction(this, "Find", keyStroke8, 0);
        this.table.registerKeyboardAction(this, "Find Next", keyStroke9, 0);
        this.init(sharpTools);
    }

    public void init(SharpTools sharpTools) {
        this.tableModel = sharpTools.getTableModel();
        this.history = sharpTools.getHistory();
    }

    public void cut() {
        this.doCopy(true);
    }

    public void copy() {
        this.doCopy(false);
    }

    private void doCopy(boolean bl) {
        if (this.table.getSelectedRowCount() != 0) {
            CellRange cellRange = new CellRange(this.table.getSelectedRows(), this.table.getSelectedColumns());
            if (bl) {
                this.history.add(this.tableModel, cellRange);
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.table.getSelectedRow();
            int n2 = this.table.getSelectedColumn();
            int n3 = this.table.getSelectedRowCount();
            int n4 = this.table.getSelectedColumnCount();
            this.copyPoint = new CellPoint(this.table.getSelectedRow(), this.table.getSelectedColumn());
            String string = this.tableModel.toString(cellRange, false);
            StringSelection stringSelection = new StringSelection(string);
            this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.system.setContents(stringSelection, stringSelection);
            if (bl) {
                this.tableModel.clearRange(cellRange);
            }
        } else if (bl) {
            this.sharp.noCellsSelected("Cut");
        } else {
            this.sharp.noCellsSelected("Copy");
        }
    }

    public void paste() {
        if (this.table.getSelectedRowCount() != 0) {
            int n = this.table.getSelectedRow();
            int n2 = this.table.getSelectedColumn();
            int n3 = n - this.copyPoint.getRow();
            int n4 = n2 - this.copyPoint.getCol();
            try {
                String string = (String)this.system.getContents(this).getTransferData(DataFlavor.stringFlavor);
                CellPoint cellPoint = SharpTableModel.getSize(string);
                int n5 = Math.min(this.table.getRowCount() - 1, n + cellPoint.getRow() - 1);
                int n6 = Math.min(this.table.getColumnCount() - 1, n2 + cellPoint.getCol() - 1);
                CellRange cellRange = new CellRange(n, n5, n2, n6);
                this.history.add(this.tableModel, cellRange);
                this.tableModel.fromString(string, n3, n4, cellRange);
            }
            catch (Exception exception) {}
        } else {
            this.sharp.noCellsSelected("Paste");
        }
    }

    public void clear() {
        if (this.table.getSelectedRowCount() != 0) {
            CellRange cellRange = new CellRange(this.table.getSelectedRows(), this.table.getSelectedColumns());
            this.history.add(this.tableModel, cellRange);
            Debug.println("Clear");
            this.tableModel.clearRange(cellRange);
        } else {
            this.sharp.noCellsSelected("Clear");
        }
    }

    public void fill() {
        if (this.table.getSelectedRowCount() != 0) {
            CellRange cellRange = new CellRange(this.table.getSelectedRows(), this.table.getSelectedColumns());
            Cell cell = this.tableModel.getCellAt(cellRange.getStartRow(), cellRange.getStartCol());
            String string = null;
            string = cell.isFormula() ? "=" + cell.getFormula().toString() : cell.getValue().toString();
            Object object = SharpOptionPane.showInputDialog(this.sharp, "Please enter a value to fill the range", "Fill", 1, fillIcon, null, string);
            if (object != null && ((String)object).length() != 0) {
                this.history.add(this.tableModel, cellRange);
                this.tableModel.fillRange(cellRange, (String)object);
            }
        } else {
            this.sharp.noCellsSelected("Fill");
        }
    }

    public void find(boolean bl) {
        CellPoint cellPoint;
        if (this.table.getSelectedRowCount() != 0) {
            int n = this.table.getSelectedRow();
            int n2 = this.table.getSelectedColumn();
            if (!bl) {
                if (n2 < this.table.getColumnCount() - 1) {
                    ++n2;
                } else {
                    n2 = 1;
                    ++n;
                }
            }
            cellPoint = new CellPoint(n, n2);
        } else {
            cellPoint = new CellPoint(SharpTools.baseRow, SharpTools.baseCol);
        }
        if (bl) {
            FindDialog findDialog = new FindDialog(this.sharp, this.findValue, this.matchCase, this.matchCell);
            findDialog.pack();
            findDialog.setLocationRelativeTo(this.sharp);
            findDialog.setVisible(true);
            String string = findDialog.getString();
            if (string == null || string.length() == 0) {
                return;
            }
            this.setFindValue(string);
            this.matchCase = findDialog.isCaseSensitive();
            this.matchCell = findDialog.isCellMatching();
            Debug.println("case sens : " + findDialog.isCaseSensitive());
            Debug.println("match cell : " + findDialog.isCellMatching());
        } else if (!this.hasFindValue()) {
            return;
        }
        CellPoint cellPoint2 = this.tableModel.look(cellPoint, SharpTableModel.fieldParser(this.findValue), this.matchCase, this.matchCell);
        if (cellPoint2 != null) {
            this.table.setColumnSelectionInterval(cellPoint2.getCol(), cellPoint2.getCol());
            this.table.setRowSelectionInterval(cellPoint2.getRow(), cellPoint2.getRow());
            this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(cellPoint2.getRow(), cellPoint2.getCol(), true)));
        } else {
            SharpOptionPane.showMessageDialog(this.sharp, "SharpTools has finished the search and no more \"" + this.findValue + "\" is found.", "Find Completed", 1, findIcon);
        }
    }

    public boolean hasFindValue() {
        return this.findValue != null && this.findValue.length() != 0;
    }

    private void setFindValue(String string) {
        this.findValue = string;
        this.sharp.checkFindNextState();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().compareTo("Undo") == 0) {
            this.history.undo(this.tableModel);
        } else if (actionEvent.getActionCommand().compareTo("Redo") == 0) {
            this.history.redo(this.tableModel);
        } else if (actionEvent.getActionCommand().compareTo("Cut") == 0) {
            this.cut();
        } else if (actionEvent.getActionCommand().compareTo("Copy") == 0) {
            this.copy();
        } else if (actionEvent.getActionCommand().compareTo("Paste") == 0) {
            this.paste();
        } else if (actionEvent.getActionCommand().compareTo("Fill") == 0) {
            this.fill();
        } else if (actionEvent.getActionCommand().compareTo("Find") == 0) {
            this.find(true);
        } else if (actionEvent.getActionCommand().compareTo("Find Next") == 0) {
            this.find(false);
        }
    }
}

