/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumberField
extends JTextField {
    private boolean positiveOnly;
    private boolean integer;

    public NumberField(int n) {
        super(n);
        this.setDocument(new NumberFilterDocument());
    }

    public NumberField(int n, boolean bl) {
        this(n);
        this.positiveOnly = bl;
        this.setDocument(new NumberFilterDocument());
    }

    public NumberField(int n, boolean bl, boolean bl2) {
        this(n);
        this.positiveOnly = bl;
        this.integer = bl2;
        this.setDocument(new NumberFilterDocument());
    }

    public NumberField(boolean bl, boolean bl2) {
        this.positiveOnly = bl;
        this.integer = bl2;
        this.setDocument(new NumberFilterDocument());
    }

    public Float getNumber() {
        try {
            return new Float(Float.parseFloat(this.getText()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setNumber(Float f) {
        if (f == null) {
            this.setText(null);
        } else {
            this.setText(f.toString());
        }
    }

    public Integer getInteger() {
        try {
            return new Integer(Integer.parseInt(this.getText()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setInteger(Integer n) {
        if (n == null) {
            this.setText(null);
        } else {
            this.setText(n.toString());
        }
    }

    class NumberFilterDocument
    extends PlainDocument {
        private StringBuffer __scratchBuffer = new StringBuffer();

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            float f;
            if (string == null) {
                return;
            }
            this.__scratchBuffer.setLength(0);
            try {
                this.__scratchBuffer.append(this.getText(0, this.getLength()));
                this.__scratchBuffer.insert(n, string);
                this.__scratchBuffer.append('0');
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                stringIndexOutOfBoundsException.printStackTrace();
                return;
            }
            try {
                f = NumberField.this.integer ? (float)Integer.parseInt(this.__scratchBuffer.toString()) : Float.parseFloat(this.__scratchBuffer.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (NumberField.this.positiveOnly && f < 0.0f) {
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

