/*
 * Decompiled with CFR 0.152.
 */
public class SharpClipboard {
    private String text;
    private CellRange source;

    public SharpClipboard(SharpTableModel sharpTableModel, CellRange cellRange, boolean bl) {
        this.text = sharpTableModel.toString(cellRange, false);
        this.source = cellRange;
        if (bl) {
            sharpTableModel.clearRange(cellRange);
        }
    }

    public CellRange getRange(SharpTableModel sharpTableModel, CellPoint cellPoint) {
        int n = sharpTableModel.getRowCount() - 1;
        int n2 = sharpTableModel.getColumnCount() - 1;
        int n3 = cellPoint.getRow() + this.source.getHeight() - 1;
        int n4 = cellPoint.getCol() + this.source.getWidth() - 1;
        if (cellPoint.getRow() < SharpTools.baseRow || cellPoint.getCol() < SharpTools.baseCol) {
            return null;
        }
        return new CellRange(cellPoint, new CellPoint(Math.min(n3, n), Math.min(n4, n2)));
    }

    public void paste(SharpTableModel sharpTableModel, CellPoint cellPoint) {
        CellRange cellRange = this.getRange(sharpTableModel, cellPoint);
        this.paste(sharpTableModel, cellRange);
    }

    public void paste(SharpTableModel sharpTableModel, CellRange cellRange) {
        if (cellRange != null) {
            int n = cellRange.getStartRow() - this.source.getStartRow();
            int n2 = cellRange.getStartCol() - this.source.getStartCol();
            sharpTableModel.fromString(this.text, n, n2, cellRange);
        }
    }

    public CellRange getSource() {
        return this.source;
    }

    public void setSource(CellRange cellRange) {
        this.source = cellRange;
    }

    public String toString() {
        return this.text;
    }
}

