/*
 * Decompiled with CFR 0.152.
 */
package net.dnsalias.pcb.csveditor.gui;

import java.util.ResourceBundle;
import net.dnsalias.pcb.utilities.HelperClass;

public class Enums {
    private static final String resourceSrc = "resources/EnumsResources";

    public static enum HelpOperation {
        ABOUT("ABOUT"),
        HELP("HELP");

        private final String name;

        private HelpOperation(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum FontStyle {
        PLAIN("Plain"),
        BOLD("Bold"),
        ITALIC("Italic"),
        BOLD_ITALIC("Bold_Italic");

        private final String name;

        private FontStyle(String name) {
            this.name = name;
        }

        public String toString() {
            ResourceBundle EnumsResources = HelperClass.getResourceBundleFromJar(Enums.resourceSrc, "UTF-8");
            return EnumsResources.getString(this.name);
        }
    }

    public static enum EditOperation {
        UNDO("UNDO"),
        REDO("REDO");

        private final String name;

        private EditOperation(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum FileDialogMethod {
        OPEN("OPEN"),
        SAVE("SAVE"),
        SAVEAS("SAVEAS");

        private final String name;

        private FileDialogMethod(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum SearchOperation {
        FIND("FIND"),
        REPLACE("REPLACE"),
        REPLACEALL("REPLACEALL"),
        CLOSE("CLOSE"),
        FINDAGAIN("FINDAGAIN"),
        SELECTALL("SELECTALL");

        private final String name;

        private SearchOperation(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum SettingsOperation {
        FONT("FONT"),
        TABSIZE("TABSIZE"),
        LINEWRAP("LINEWRAP"),
        EOL("EOL");

        private final String name;

        private SettingsOperation(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum FileOperation {
        OPEN("OPEN"),
        RECENT("RECENT"),
        CLOSE("CLOSE"),
        EXIT("EXIT"),
        SAVE("SAVE"),
        PRINT("PRINT"),
        SAVEAS("SAVEAS");

        private final String name;

        private FileOperation(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum MenuOperation {
        FILE("FILE"),
        EDIT("EDIT"),
        SETTINGS("SETTINGS"),
        HELP("HELP");

        private final String name;

        private MenuOperation(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

