/*
 * Decompiled with CFR 0.152.
 */
package net.dnsalias.pcb.csveditor.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import net.dnsalias.pcb.csveditor.gui.Enums;

public class FileDialog
implements PropertyChangeListener {
    private File path;
    private JFileChooser chooser;
    private Component parent;

    public FileDialog(Component parent, Enums.FileDialogMethod method) {
        this(parent, method, null);
    }

    public FileDialog(Component parent, Enums.FileDialogMethod method, File path) {
        this.parent = parent;
        this.path = path;
        if (method == Enums.FileDialogMethod.OPEN) {
            this.parent = parent;
            this.path = path;
            this.fileOpenDialog();
        }
        if (method == Enums.FileDialogMethod.SAVEAS) {
            this.parent = parent;
            this.path = path;
            this.fileSaveAsDialog();
        }
    }

    private File fileOpenDialog() {
        this.chooser = new JFileChooser(this.path, FileSystemView.getFileSystemView());
        this.chooser.setFileSelectionMode(0);
        this.chooser.setMultiSelectionEnabled(false);
        int result = this.chooser.showOpenDialog(this.parent);
        if (result == 0) {
            this.path = this.chooser.getSelectedFile();
            if (this.path.isDirectory()) {
                this.path = null;
            }
        } else {
            this.path = null;
        }
        return this.path;
    }

    private File fileSaveAsDialog() {
        this.chooser = new JFileChooser(this.path, FileSystemView.getFileSystemView());
        this.chooser.setFileSelectionMode(0);
        this.chooser.setMultiSelectionEnabled(false);
        this.chooser.setSelectedFile(this.path);
        int result = this.chooser.showSaveDialog(this.parent);
        if (result == 0) {
            this.path = this.chooser.getSelectedFile();
            if (this.path.isDirectory()) {
                this.path = null;
            }
        } else {
            this.path = null;
        }
        return this.path;
    }

    public File getPath() {
        return this.path;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.chooser.isVisible() && e.getSource() == this.chooser && this.chooser.getDialogType() == 1 && prop.equals("directoryChanged")) {
            this.path = new File(this.chooser.getSelectedFile().getParent() + System.getProperty("file.separator") + this.path.getName());
        }
    }
}

