/*
 * Decompiled with CFR 0.152.
 */
package net.dnsalias.pcb.csveditor.gui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.dnsalias.pcb.csveditor.gui.CsvEditor;
import net.dnsalias.pcb.utilities.HelperClass;

public class PrintFormatDialog
extends JDialog
implements ChangeListener,
PropertyChangeListener {
    public static final long serialVersionUID = 19650221L;
    private JTable.PrintMode printMode;
    private Object[] options = new Object[2];
    private JFrame owner;
    private JOptionPane dialogPane;
    private ResourceBundle resourceBundle;
    private static final String resourceSrc = "resources/PrintFormatDialogResources";

    public PrintFormatDialog(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.resourceBundle = HelperClass.getResourceBundleFromJar(resourceSrc, "UTF-8");
        this.createAndShowGUI();
    }

    public PrintFormatDialog(CsvEditor owner, boolean modal) {
        this(owner, owner.getAppname(), modal);
    }

    public PrintFormatDialog(CsvEditor owner, String title, boolean modal) {
        super(owner, title, modal);
        this.owner = owner;
        this.resourceBundle = HelperClass.getResourceBundleFromJar(resourceSrc, "UTF-8");
        this.createAndShowGUI();
    }

    private void createAndShowGUI() {
        this.options[0] = this.resourceBundle.getString("NORMAL");
        this.options[1] = this.resourceBundle.getString("FIT_WIDTH");
        this.dialogPane = new JOptionPane(this.resourceBundle.getString("msg"), 3, -1, null, this.options, this.options[0]);
        this.dialogPane.addPropertyChangeListener(this);
        this.setContentPane(this.dialogPane);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
        this.dialogPane.selectInitialValue();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object selectedOption;
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.dialogPane && prop.equals("value") && (selectedOption = this.dialogPane.getValue()) != null) {
            if (selectedOption == this.options[0]) {
                this.printMode = JTable.PrintMode.NORMAL;
                this.setVisible(false);
            } else if (selectedOption == this.options[1]) {
                this.printMode = JTable.PrintMode.FIT_WIDTH;
                this.setVisible(false);
            } else {
                this.printMode = null;
            }
        }
    }

    public JTable.PrintMode getOption() {
        return this.printMode;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PrintFormatDialog dialog = new PrintFormatDialog(new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

