/*
 * Decompiled with CFR 0.152.
 */
package net.dnsalias.pcb.csveditor.gui;

import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import net.dnsalias.pcb.utilities.HelperClass;

public class RecentDialog
extends JDialog {
    public static final long serialVersionUID = 19650221L;
    private JFrame owner;
    private JList list;
    private int selectedIndex = -1;
    private String selected = null;
    private ResourceBundle RecentDialogResources;
    private static final String resourceSrc = "resources/RecentDialogResources";

    public RecentDialog(JFrame owner, JList list) {
        super((Frame)owner, true);
        this.setDefaultCloseOperation(0);
        this.owner = owner;
        this.list = list;
        this.RecentDialogResources = HelperClass.getResourceBundleFromJar(resourceSrc, "UTF-8");
        if (list.getModel().getSize() > 0) {
            this.createAndShowGUI();
        }
    }

    private void createAndShowGUI() {
        this.addWindowListener(new WindowClosingEventHandlerClass());
        this.setTitle(this.RecentDialogResources.getString("Select_Item"));
        this.list.setBorder(BorderFactory.createEtchedBorder(0));
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new ListMouseListener());
        this.list.addKeyListener(new ListKeyListener());
        this.add(this.list);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
    }

    private void getSelected(int index) {
        if (index > -1) {
            try {
                this.selected = (String)this.list.getModel().getElementAt(index);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.windowClosingEventHandler();
    }

    private void windowClosingEventHandler() {
        this.setVisible(false);
    }

    public String getSelectedString() {
        return this.selected;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    private class WindowClosingEventHandlerClass
    extends WindowAdapter {
        private WindowClosingEventHandlerClass() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            RecentDialog.this.selectedIndex = -1;
            RecentDialog.this.selected = null;
            RecentDialog.this.windowClosingEventHandler();
        }
    }

    private class ListKeyListener
    extends KeyAdapter {
        private ListKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.keyEventHandler(e);
        }

        private void keyEventHandler(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                RecentDialog.this.selectedIndex = RecentDialog.this.list.getSelectedIndex();
                RecentDialog.this.getSelected(RecentDialog.this.selectedIndex);
            }
            if (e.getKeyCode() == 27) {
                RecentDialog.this.selectedIndex = -1;
                RecentDialog.this.selected = null;
                RecentDialog.this.getSelected(RecentDialog.this.selectedIndex);
            }
        }
    }

    private class ListMouseListener
    extends MouseAdapter {
        private ListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.mouseEventHandler(e);
        }

        private void mouseEventHandler(MouseEvent e) {
            if (e.getClickCount() == 2) {
                RecentDialog.this.selectedIndex = RecentDialog.this.list.locationToIndex(e.getPoint());
                RecentDialog.this.getSelected(RecentDialog.this.selectedIndex);
            }
        }
    }
}

