/*
 * Decompiled with CFR 0.152.
 */
package net.dnsalias.pcb.utilities.dnd;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.dnsalias.pcb.utilities.dnd.StringTransferHandler;

public class TableTransferHandler
extends StringTransferHandler {
    private int[] rows = null;
    private int addIndex = -1;
    private int addCount = 0;

    @Override
    protected String exportString(JComponent c) {
        JTable table = (JTable)c;
        this.rows = table.getSelectedRows();
        int colCount = table.getColumnCount();
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < this.rows.length; ++i) {
            for (int j = 0; j < colCount; ++j) {
                Object val = table.getValueAt(this.rows[i], j);
                buff.append(val == null ? "" : val.toString());
                if (j == colCount - 1) continue;
                buff.append("\t");
            }
            if (i == this.rows.length - 1) continue;
            buff.append("\n");
        }
        return buff.toString();
    }

    @Override
    protected void importString(JComponent c, String str) {
        JTable target = (JTable)c;
        DefaultTableModel model = (DefaultTableModel)target.getModel();
        int index = target.getSelectedRow();
        if (this.rows != null && index >= this.rows[0] - 1 && index <= this.rows[this.rows.length - 1]) {
            this.rows = null;
            return;
        }
        int max = model.getRowCount();
        if (index < 0) {
            index = max;
        } else if (++index > max) {
            index = max;
        }
        this.addIndex = index;
        String[] values = str.split("\\n");
        this.addCount = values.length;
        int colCount = target.getColumnCount();
        for (int i = 0; i < values.length && i < colCount; ++i) {
            model.insertRow(index++, values[i].split("\\t"));
        }
    }

    @Override
    protected void cleanup(JComponent c, boolean remove) {
        JTable source = (JTable)c;
        if (remove && this.rows != null) {
            int i;
            DefaultTableModel model = (DefaultTableModel)source.getModel();
            if (this.addCount > 0) {
                for (i = 0; i < this.rows.length; ++i) {
                    if (this.rows[i] <= this.addIndex) continue;
                    int n = i;
                    this.rows[n] = this.rows[n] + this.addCount;
                }
            }
            for (i = this.rows.length - 1; i >= 0; --i) {
                model.removeRow(this.rows[i]);
            }
        }
        this.rows = null;
        this.addCount = 0;
        this.addIndex = -1;
    }
}

