/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Mount;
import com.sun.nfs.Nfs;
import com.sun.nfs.Nfs2;
import com.sun.nfs.Nfs3;
import com.sun.nfs.NfsException;
import com.sun.nfs.NfsURL;
import com.sun.rpc.ConnectDatagram;
import com.sun.rpc.ConnectSocket;
import com.sun.rpc.Connection;
import com.sun.rpc.CredUnix;
import com.sun.rpc.MsgAcceptedException;
import com.sun.rpc.Rpc;
import com.sun.rpc.RpcHandler;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Hashtable;

public class NfsConnect {
    private static byte[] pubfh2 = new byte[32];
    private static byte[] pubfh3 = new byte[0];
    private static Hashtable cacheNfsConnect = new Hashtable();
    static final int NFS_PORT = 2049;
    static final int NFS_PROG = 100003;
    static final int MAXBUF = 32968;
    String server;
    int port;
    int version;
    String proto;
    boolean pub;
    static CredUnix cred = new CredUnix();
    static RpcHandler rhandler;

    NfsConnect(String string, int n, int n2, String string2, boolean bl) {
        this.server = string;
        this.port = n;
        this.version = n2;
        this.proto = string2;
        this.pub = bl;
    }

    static Nfs connect(String string) throws IOException {
        NfsURL nfsURL = new NfsURL(string);
        String string2 = nfsURL.getHost();
        int n = nfsURL.getPort();
        String string3 = nfsURL.getFile();
        int n2 = nfsURL.getVersion();
        String string4 = nfsURL.getProto();
        boolean bl = nfsURL.getPub();
        NfsConnect nfsConnect = null;
        if (n2 == 0 && string4 == null && bl) {
            nfsConnect = NfsConnect.cache_get(string2);
        }
        if (nfsConnect == null) {
            return NfsConnect.connect(string2, string3, n, n2, string4, bl);
        }
        return NfsConnect.connect(string2, string3, nfsConnect.port, nfsConnect.version, nfsConnect.proto, nfsConnect.pub);
    }

    static Nfs connect(String string, int n, String string2) throws IOException {
        NfsConnect nfsConnect = NfsConnect.cache_get(string);
        if (nfsConnect == null) {
            return NfsConnect.connect(string, string2, n, 0, null, true);
        }
        return NfsConnect.connect(string, string2, nfsConnect.port, nfsConnect.version, nfsConnect.proto, nfsConnect.pub);
    }

    /*
     * Unable to fully structure code
     */
    static Nfs connect(String var0, String var1_1, int var2_2, int var3_3, String var4_4, boolean var5_5) throws IOException {
        block35: {
            if (var2_2 == 0) {
                var2_2 = 2049;
            }
            if (var1_1 == null || var1_1.length() == 0) {
                var1_1 = ".";
            }
            if ((var6_6 = Nfs.cache_get(var0, var1_1)) != null) {
                var6_6.getattr();
                if (var6_6.isSymlink()) {
                    return NfsConnect.followLink(var6_6);
                }
                return var6_6;
            }
            if (var4_4 == null) {
                var7_7 = Connection.getCache(var0, var2_2, "tcp");
                if (var7_7 == null) {
                    var7_7 = Connection.getCache(var0, var2_2, "udp");
                }
                if (var7_7 == null) {
                    try {
                        var7_7 = new ConnectSocket(var0, var2_2, 32968);
                        Connection.putCache(var7_7);
                        var4_4 = "tcp";
                    }
                    catch (UnknownHostException var8_8) {
                        throw var8_8;
                    }
                    catch (IOException v0) {
                        var7_7 = new ConnectDatagram(var0, var2_2, 32968);
                        Connection.putCache(var7_7);
                        var4_4 = "udp";
                    }
                }
            } else if (var4_4.equals("tcp")) {
                var7_7 = Connection.getCache(var0, var2_2, "tcp");
                if (var7_7 == null) {
                    var7_7 = new ConnectSocket(var0, var2_2, 32968);
                    Connection.putCache(var7_7);
                }
            } else if (var4_4.equals("udp")) {
                var7_7 = Connection.getCache(var0, var2_2, "udp");
                if (var7_7 == null) {
                    var7_7 = new ConnectDatagram(var0, var2_2, 32968);
                    Connection.putCache(var7_7);
                }
            } else {
                throw new IOException("Unknown protocol: " + var4_4);
            }
            if (!var5_5) break block35;
            try {
                switch (var3_3) {
                    case 0: {
                        try {
                            var6_6 = NfsConnect.tryNfs(var7_7, NfsConnect.pubfh3, var1_1, 3, false);
                            var3_3 = 3;
                        }
                        catch (MsgAcceptedException var8_9) {
                            if (var8_9.error != 2) {
                                throw var8_9;
                            }
                            var3_3 = 2;
                            var6_6 = NfsConnect.tryNfs(var7_7, NfsConnect.pubfh2, var1_1, 2, false);
                        }
                        break;
                    }
                    case 2: {
                        var6_6 = NfsConnect.tryNfs(var7_7, NfsConnect.pubfh2, var1_1, 2, false);
                        break;
                    }
                    case 3: {
                        var6_6 = NfsConnect.tryNfs(var7_7, NfsConnect.pubfh3, var1_1, 3, false);
                        break;
                    }
                    default: {
                        if (var6_6 == null) break block35;
                    }
                }
            }
            catch (MsgAcceptedException var8_10) {
                if (var8_10.error != 4) {
                    throw var8_10;
                }
                if (var3_3 == 0) {
                    var3_3 = 3;
                }
            }
            catch (NfsException var8_11) {
                if (var8_11.error != 70 && var8_11.error != 10001) {
                    throw var8_11;
                }
                if (var3_3 != 0) ** GOTO lbl73
                var3_3 = 3;
            }
lbl73:
            // 7 sources

            if (var6_6 == null) break block35;
            NfsConnect.cache_put(new NfsConnect(var0, var2_2, var3_3, var4_4, true));
            return var6_6;
        }
        if (var1_1.equals(".")) {
            var1_1 = "/";
        }
        var8_12 = new Mount().getFH(var0, var1_1, var3_3);
        NfsConnect.cache_put(new NfsConnect(var0, var2_2, var3_3, var4_4, false));
        return NfsConnect.tryNfs(var7_7, var8_12, var1_1, var3_3, true);
    }

    private static Nfs tryNfs(Connection connection, byte[] byArray, String string, int n, boolean bl) throws IOException {
        Rpc rpc = new Rpc(connection, 100003, n);
        rpc.setCred(cred);
        rpc.setRpcHandler(rhandler);
        Nfs nfs = n == 2 ? new Nfs2(rpc, byArray, string, null) : new Nfs3(rpc, byArray, string, null);
        if (string.equals("/.")) {
            return nfs;
        }
        if (bl) {
            nfs.getattr();
            Nfs.cache_put(nfs);
            return nfs;
        }
        return nfs.lookup(null);
    }

    static Nfs followLink(Nfs nfs) throws IOException {
        String string;
        String string2 = nfs.name;
        String string3 = nfs.readlink();
        String string4 = nfs.rpc.conn.server;
        int n = nfs.rpc.conn.port;
        if (string3.startsWith("nfs://")) {
            NfsURL nfsURL = new NfsURL(string3);
            string4 = nfsURL.getHost();
            n = nfsURL.getPort();
            string = nfsURL.getFile();
        } else if (string3.startsWith("/")) {
            string = string3;
        } else {
            int n2 = 0;
            int n3 = string2.lastIndexOf(47);
            int n4 = string3.length();
            while (string3.regionMatches(n2, "..", 0, n4 - n2) || string3.startsWith("../", n2)) {
                if ((n2 += 3) >= n4) break;
                n3 = string2.lastIndexOf(47, n3 - 1);
            }
            if (n2 > n4) {
                n2 = n4;
            }
            n3 = n3 < 0 ? 0 : ++n3;
            string = String.valueOf(string2.substring(0, n3)) + string3.substring(n2);
        }
        try {
            return NfsConnect.connect(string4, n, string);
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf(iOException) + ": symbolic link: " + string2 + " -> " + string3);
            return nfs;
        }
    }

    private static void cache_put(NfsConnect nfsConnect) {
        cacheNfsConnect.put(nfsConnect.server, nfsConnect);
    }

    private static NfsConnect cache_get(String string) {
        return (NfsConnect)cacheNfsConnect.get(string);
    }

    public static CredUnix getCred() {
        return cred;
    }

    public static void setRpcHandler(RpcHandler rpcHandler) {
        rhandler = rpcHandler;
    }
}

