/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.forms;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Vector;
import sunw.hotjava.forms.HighlightFilter;

public class ComboBox
extends Canvas
implements MouseListener,
ActionListener,
ItemSelectable {
    private static boolean debug;
    protected Vector elemVector = new Vector();
    transient ItemListener itemListener;
    protected String name = "";
    protected PopupMenu menu;
    protected boolean dirty = true;
    protected String currSelection;
    protected int currIndex;
    protected int lineAscent;
    protected int lineWidth;
    protected int lineHeight;
    protected int leftMargin;
    protected int topMargin;
    protected static Color disableColor;
    protected static Color focusColor;
    protected static Color topShadowColor;
    protected static Color bottomShadowColor;
    protected static Color topArrowShadowColor;
    protected static Color bottomArrowShadowColor;
    protected static final int shadowThickness = 1;
    protected static final int borderWidth = 5;
    protected static final int indentWidth = 10;
    protected static final int arrowWidth = 10;
    protected static final int arrowShadowThickness = 2;
    private int[] xPts;
    private int[] yPts;

    public ComboBox() {
        super.setName(this.name);
        this.addMouseListener(this);
        this.enableEvents(16L);
    }

    public void addNotify() {
        super.addNotify();
        this.calculateSize();
        if (focusColor == null || topShadowColor == null || bottomShadowColor == null) {
            this.setComponentColor();
        }
    }

    protected void setLabel(String string) {
        this.name = string;
        this.calculateSize();
        this.repaint();
    }

    protected void updateLabel() {
        if (this.elemVector.size() >= 1) {
            this.setLabel((String)this.elemVector.elementAt(this.currIndex));
        }
    }

    public synchronized void add(String string) {
        this.dirty = true;
        this.elemVector.addElement(string);
        this.updateLabel();
    }

    public synchronized void insert(String string, int n) {
        this.dirty = true;
        this.elemVector.insertElementAt(string, n);
        if (n == this.currIndex) {
            this.updateLabel();
        }
    }

    public synchronized void remove(int n) {
        this.dirty = true;
        try {
            this.elemVector.removeElementAt(n);
            if (n == this.currIndex) {
                this.updateLabel();
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public synchronized void remove(String string) {
        this.dirty = true;
        this.elemVector.removeElement(string);
        this.updateLabel();
    }

    public synchronized void removeAll() {
        this.dirty = true;
        this.elemVector.removeAllElements();
        this.elemVector.trimToSize();
        this.setLabel(" ");
    }

    public String getItem(int n) {
        String string = null;
        try {
            string = (String)this.elemVector.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = null;
        }
        return string;
    }

    public synchronized String getSelectedItem() {
        return this.currSelection;
    }

    public synchronized int getSelectedIndex() {
        return this.currIndex;
    }

    public int getItemCount() {
        return this.elemVector.size();
    }

    public synchronized void select(int n) {
        try {
            String string;
            this.currSelection = string = (String)this.elemVector.elementAt(n);
            this.setLabel(string);
            this.currIndex = n;
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.elemVector.size() == 0) {
                this.currSelection = null;
                this.currIndex = 0;
                this.setLabel(" ");
            }
            return;
        }
    }

    public synchronized void select(String string) {
        int n = this.elemVector.indexOf(string);
        if (n != -1) {
            this.select(n);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.showMenu(mouseEvent.getX(), mouseEvent.getY());
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this.getSelectedItem()};
        return objectArray;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setLabel(actionEvent.getActionCommand());
        this.currSelection = actionEvent.getActionCommand();
        this.currIndex = this.elemVector.indexOf(this.currSelection);
        ItemEvent itemEvent = new ItemEvent(this, 701, this.currSelection, 1);
        this.processItemEvent(itemEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    private void showMenu(int n, int n2) {
        ComboBox.pr("showMenu() menu=" + this.menu + ", item cnt=" + this.getItemCount());
        if (this.getItemCount() <= 0) {
            return;
        }
        if (this.dirty) {
            this.updateEntries();
        }
        int n3 = n;
        int n4 = n2;
        Dimension dimension = this.getSize();
        Font font = this.getFont();
        Font font2 = this.menu.getFont();
        if (font2 != font) {
            this.menu.setFont(font);
        }
        n3 = 0;
        n4 = dimension.height;
        this.menu.show(this, n3, n4);
    }

    private void createPopup() {
        if (this.menu != null) {
            return;
        }
        this.menu = new PopupMenu();
        Container container = this.getParent();
        while (!(container instanceof Frame)) {
            container = container.getParent();
        }
        container.add(this.menu);
        ComboBox.pr("Create a popup menu = " + this.menu);
        this.menu.addActionListener(this);
    }

    private void updateEntries() {
        String[] stringArray;
        int n;
        Serializable serializable;
        ComboBox.pr("updateEntries()");
        this.createPopup();
        this.menu.removeAll();
        Object[] objectArray = new String[this.elemVector.size()];
        this.elemVector.copyInto(objectArray);
        boolean bl = false;
        int n2 = 0;
        Font font = null;
        Container container = this.getParent();
        if (container != null) {
            font = container.getFont();
        }
        if (font != null) {
            serializable = this.getFontMetrics(font);
            n = ((FontMetrics)serializable).getHeight() + 6;
            stringArray = Toolkit.getDefaultToolkit().getScreenSize();
            n2 = stringArray.height / n - 1;
            ComboBox.pr("items.length: " + objectArray.length);
            ComboBox.pr("numItems: " + n2);
            if (n2 < objectArray.length) {
                bl = true;
                ComboBox.pr("we have more...");
            }
        }
        serializable = null;
        if (bl) {
            n = 0;
            while (n < n2) {
                serializable = new MenuItem((String)objectArray[n]);
                if (font != null) {
                    ((MenuComponent)serializable).setFont(font);
                }
                this.menu.add((MenuItem)serializable);
                ++n;
            }
            stringArray = new String[objectArray.length - n2];
            int n3 = n2;
            int n4 = 0;
            while (n4 < stringArray.length) {
                stringArray[n4] = objectArray[n3 + n4];
                ++n4;
            }
            Menu menu = this.createMenu(stringArray, n2);
            menu.addActionListener(this);
            this.menu.add(menu);
        } else {
            n = 0;
            while (n < objectArray.length) {
                serializable = new MenuItem((String)objectArray[n]);
                if (font != null) {
                    ((MenuComponent)serializable).setFont(font);
                }
                this.menu.add((MenuItem)serializable);
                ++n;
            }
        }
        this.dirty = false;
    }

    private Menu createMenu(String[] stringArray, int n) {
        Menu menu = new Menu("More...");
        Font font = this.getParent().getFont();
        if (stringArray.length <= n) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                MenuItem menuItem = new MenuItem(stringArray[n2]);
                if (font != null) {
                    menuItem.setFont(font);
                }
                menu.add(menuItem);
                ++n2;
            }
        } else if (stringArray.length > n) {
            int n3 = 0;
            while (n3 < n) {
                MenuItem menuItem = new MenuItem(stringArray[n3]);
                if (font != null) {
                    menuItem.setFont(font);
                }
                menu.add(menuItem);
                ++n3;
            }
            String[] stringArray2 = new String[stringArray.length - n];
            int n4 = 0;
            while (n4 < stringArray2.length) {
                stringArray2[n4] = stringArray[n + n4];
                ++n4;
            }
            menu.add(this.createMenu(stringArray2, n));
        }
        menu.addActionListener(this);
        return menu;
    }

    private MenuItem add(MenuItem menuItem) {
        this.createPopup();
        menuItem.addActionListener(this);
        return this.menu.add(menuItem);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        Color color3 = topShadowColor;
        Color color4 = bottomShadowColor;
        Color color5 = color2;
        graphics.setColor(color2);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        this.drawShadow(graphics, color3, color4, 0, 0, dimension.width, dimension.height, 1);
        this.leftMargin = 6;
        if (!this.isEnabled()) {
            color = disableColor;
        }
        graphics.setColor(color);
        graphics.drawString(this.name, this.leftMargin, this.topMargin);
        int n = dimension.width - 5 - 10;
        int[] nArray = new int[]{this.xPts[0] + n, this.xPts[1] + n, this.xPts[2] + n};
        graphics.setColor(Color.lightGray);
        graphics.fillPolygon(nArray, this.yPts, 3);
        graphics.setColor(topArrowShadowColor);
        int n2 = 0;
        while (n2 < 2) {
            graphics.drawLine(nArray[2] + n2, this.yPts[2] + n2, nArray[0] - n2, this.yPts[0] + n2);
            graphics.drawLine(nArray[2] + n2, this.yPts[2], nArray[1], this.yPts[1] - n2);
            ++n2;
        }
        graphics.setColor(bottomArrowShadowColor);
        n2 = 0;
        while (n2 < 2) {
            graphics.drawLine(nArray[1], this.yPts[1] - n2, nArray[0] - n2, this.yPts[0]);
            ++n2;
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.menu != null) {
            this.menu.setFont(font);
        }
        this.calculateSize();
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.lineWidth + 10 + 2, this.lineHeight + 10 + 2);
        return dimension;
    }

    protected void drawShadow(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4, int n5) {
        int n6 = n + n3 - 1;
        int n7 = n2 + n4 - 1;
        int n8 = 0;
        while (n8 < n5) {
            graphics.setColor(color2);
            graphics.drawLine(n + n8, n7 - n8, n6 - n8, n7 - n8);
            graphics.drawLine(n6 - n8, n2 + n8, n6 - n8, n7 - n8);
            graphics.setColor(color);
            graphics.drawLine(n + n8, n2 + n8, n6 - n8, n2 + n8);
            graphics.drawLine(n + n8, n2 + n8, n + n8, n7 - n8);
            ++n8;
        }
    }

    protected void calculateSize() {
        int n;
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics == null) {
            return;
        }
        this.lineWidth = 0;
        int n2 = 0;
        while (n2 < this.elemVector.size()) {
            n = fontMetrics.stringWidth((String)this.elemVector.elementAt(n2));
            if (n > this.lineWidth) {
                this.lineWidth = n;
            }
            ++n2;
        }
        this.lineHeight = fontMetrics.getHeight();
        this.lineAscent = fontMetrics.getMaxAscent();
        this.leftMargin = 5;
        this.topMargin = this.lineAscent + 5 + 1;
        this.lineWidth += 20;
        this.xPts = new int[3];
        this.yPts = new int[3];
        n = 5 + this.lineHeight / 2;
        int n3 = 5;
        this.xPts[0] = 10;
        this.xPts[1] = n3;
        this.xPts[2] = 0;
        this.yPts[0] = n - n3;
        this.yPts[1] = n + n3;
        this.yPts[2] = this.yPts[0];
    }

    private void setComponentColor() {
        Color color = this.getBackground();
        if (color != null) {
            HighlightFilter highlightFilter = new HighlightFilter(false, 20);
            int n = highlightFilter.filterRGB(0, 0, color.getRGB());
            focusColor = new Color(n);
            highlightFilter = new HighlightFilter(true, 50);
            n = highlightFilter.filterRGB(0, 0, this.getForeground().getRGB());
            disableColor = new Color(n);
            n = highlightFilter.filterRGB(0, 0, color.getRGB());
            topShadowColor = new Color(n);
            n = highlightFilter.filterRGB(0, 0, Color.lightGray.getRGB());
            topArrowShadowColor = new Color(n);
            highlightFilter = new HighlightFilter(false, 50);
            n = highlightFilter.filterRGB(0, 0, color.getRGB());
            bottomShadowColor = new Color(n);
            n = highlightFilter.filterRGB(0, 0, Color.lightGray.getRGB());
            bottomArrowShadowColor = new Color(n);
            return;
        }
        focusColor = color;
        topShadowColor = Color.white;
        bottomShadowColor = Color.black;
    }

    public int getAscent() {
        Font font = this.getFont();
        if (font == null) {
            return 0;
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics == null) {
            return 0;
        }
        return fontMetrics.getMaxAscent() + 5 + 1;
    }

    public int getDescent() {
        int n = this.getAscent();
        if (n == 0) {
            return 0;
        }
        return this.getSize().height - n;
    }

    private static void pr(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    static {
        disableColor = null;
        focusColor = null;
        topShadowColor = null;
        bottomShadowColor = null;
        topArrowShadowColor = null;
        bottomArrowShadowColor = null;
    }
}

