/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.forms;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import sunw.hotjava.bean.HotJavaBrowserBean;
import sunw.hotjava.bean.ImageCacher;
import sunw.hotjava.doc.DocItemVisitor;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.EmptyTagItem;
import sunw.hotjava.doc.Floatable;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.MeasureState;
import sunw.hotjava.doc.Measurement;
import sunw.hotjava.doc.SizeItem;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.doc.VBreakInfo;
import sunw.hotjava.forms.FORM;
import sunw.hotjava.forms.FormPanel;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.HJColor;
import sunw.hotjava.tags.Align;
import sunw.html.Attributes;

public class INPUT
extends EmptyTagItem
implements Floatable,
SizeItem,
ImageObserver {
    private int align;
    private boolean isImage;
    Document doc;
    Image currImage;
    URL imageURL;
    boolean registered = false;
    static final int TEXT = 1;
    static final int PASSWORD = 2;
    static final int FILE = 12;
    public static final String[][] myHandlers = new String[][]{new String[0], {"onblur", "onchange", "onfocus", "onselect"}, {"onblur", "onfocus"}, {"onblur", "onclick", "onfocus"}, {"onblur", "onclick", "onfocus"}, {"onblur", "onclick", "onfocus"}, {"onblur", "onclick", "onfocus"}, {"onblur", "onclick", "onfocus"}, new String[0], new String[0], new String[0], new String[0], {"onblur", "onclick", "onfocus"}, {"onblur", "onclick", "onfocus", "onmouseup", "onmousedown"}};
    private FORM parentForm;

    public synchronized void init(Document document) {
        this.setAttribute("value", this.squeezeOut(this.getAttribute("value"), '\n'));
        super.init(document);
        this.doc = document;
        String string = this.getAttribute("align");
        if (string != null && string.equals("center")) {
            this.setAttribute("align", "middle");
        }
        this.align = Align.getAlign(this.atts);
        this.isImage = false;
        String string2 = this.getAttribute("type");
        if (string2 != null && string2.equals("image")) {
            this.isImage = true;
            String string3 = this.getAttribute("src");
            try {
                this.imageURL = new URL(document.getBaseURL(), string3);
            }
            catch (MalformedURLException malformedURLException) {}
            String string4 = this.getAttribute("width");
            String string5 = this.getAttribute("height");
            if (string4 == null || string5 == null) {
                this.registerImageWaitRef();
                this.preLoadImage();
            }
        }
    }

    private void preLoadImage() {
        this.currImage = this.getImage(Globals.getRegisteredFrame());
    }

    private Image getImage(Component component) {
        ImageCacher imageCacher = HotJavaBrowserBean.getImageCache();
        Image image = null;
        if (imageCacher != null) {
            URL uRL = null;
            if (this.doc != null) {
                uRL = this.doc.getBaseURL();
            }
            image = imageCacher.getImage(this.doc, this.imageURL, uRL);
        }
        if (image != null && component != null) {
            component.prepareImage(image, this);
            int n = image.getWidth(this);
            int n2 = image.getHeight(this);
            if (n != -1 && n2 != -1) {
                this.unregisterImageWaitRef();
            }
        }
        return image;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x30) != 0) {
            this.unregisterImageWaitRef();
            this.currImage = null;
            return false;
        }
        if ((n & 0x40) != 0) {
            this.unregisterImageWaitRef();
            return false;
        }
        return (n & 0xA0) == 0;
    }

    private void registerImageWaitRef() {
        this.doc.addSizeItemWidthWaitRef(this);
        this.doc.addSizeItemHeightWaitRef(this);
        this.registered = true;
    }

    public void unregisterImageWaitRef() {
        if (this.registered) {
            this.doc.removeSizeItemWaitRef(this);
        }
        this.registered = false;
    }

    private String squeezeOut(String string, char c) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] == c) {
                System.arraycopy(cArray, n2 + 1, cArray, n2, --n - n2);
                --n2;
            }
            ++n2;
        }
        return new String(cArray, 0, n);
    }

    public boolean needsActivation() {
        return true;
    }

    public boolean isHidden(Formatter formatter) {
        FormPanel formPanel = (FormPanel)formatter.getPanel(this);
        if (formPanel != null) {
            return formPanel.isHidden();
        }
        return false;
    }

    public int getWidth(DocStyle docStyle) {
        DocumentFormatter documentFormatter = docStyle.win;
        if (documentFormatter != null) {
            return this.getWidth(documentFormatter, docStyle);
        }
        return 0;
    }

    public int getWidth(Formatter formatter, DocStyle docStyle) {
        FormPanel formPanel = (FormPanel)formatter.getPanel(this);
        if (formPanel != null) {
            Dimension dimension = formPanel.getPreferredSize();
            return dimension.width;
        }
        return 0;
    }

    public boolean format(Formatter formatter, FormatState formatState, FormatState formatState2) {
        if (formatState.state == 2) {
            return true;
        }
        formatState.state = 1;
        FormPanel formPanel = (FormPanel)formatter.getPanel(this);
        if (formPanel == null || this.isHidden(formatter)) {
            formatState.pos += 4096;
            return false;
        }
        Dimension dimension = formPanel.getPreferredSize();
        formPanel.setSize(dimension.width, dimension.height);
        formPanel.validate();
        if (this.isImage && this.alignIsFloating()) {
            boolean bl = false;
            if (!formatter.isFloater(this) && formatState.width + dimension.width > formatState.maxWidth) {
                if (formatState.startPos != formatState.pos) {
                    formatState.below += formatter.getCumulativeFloaterHeight(formatState.y);
                    return true;
                }
                bl = true;
            }
            formatter.queueFloater(formatter, formatState, this, this.getAscent(formatter, formatState) + this.getDescent(formatter, formatState), this.align == 7);
            formatState.pos += 4096;
            return bl;
        }
        if (formatState.width + dimension.width > formatState.maxWidth && formatState.width != 0) {
            return true;
        }
        int n = formPanel.getAscent();
        if (this.isImage) {
            n = Math.max(Align.getAscent(formatState, this.align, dimension.height), n);
        }
        formatState.ascent = Math.max(formatState.ascent, Math.max(formatState.style.ascent, n));
        formatState.descent = Math.max(formatState.descent, Math.max(formatState.style.descent, dimension.height - n));
        if (formPanel.getType() > 2 && formPanel.getType() != 12 && formatState.textAscent <= formatState.descent) {
            formatState.above += formatState.descent / 2;
        }
        formatState.width += dimension.width;
        formatState.pos += 4096;
        return false;
    }

    private int paintImage(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        if (this.isHidden(formatter)) {
            return 0;
        }
        FormPanel formPanel = (FormPanel)formatter.getPanel(this);
        if (formPanel != null) {
            Dimension dimension = formPanel.getSize();
            if (this.isImage) {
                if (docLine != null) {
                    n2 += Align.yOffset(docLine, formatter.displayStyle, this.align, dimension.height);
                }
            } else if (docLine != null) {
                n2 += docLine.height - docLine.getBelow() - formPanel.getPreferredSize().height;
                if (formPanel.getType() > 2 && formPanel.getType() != 12 && docLine.textAscent != 0) {
                    n2 -= docLine.lndescent / 2;
                }
            }
            formPanel.setLocation(n, n2);
            DocStyle docStyle = formatter.displayStyle;
            if (docStyle != null) {
                HJColor hJColor = new HJColor(formatter.getFormatterBackgroundColor());
                if (hJColor.similar(docStyle.color)) {
                    formPanel.setForeground(hJColor.getContrastingColor());
                } else {
                    formPanel.setForeground(docStyle.color);
                }
            }
            formPanel.setBackground(formatter.getFormatterBackgroundColor());
            formPanel.validate();
            formPanel.setVisible(true);
            return dimension.width;
        }
        return 0;
    }

    public int paint(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        formatter.displayPos += 4096;
        if (this.isImage && this.alignIsFloating()) {
            return 0;
        }
        return this.paintImage(formatter, graphics, n, n2, docLine);
    }

    public int printImage(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine, VBreakInfo vBreakInfo) {
        FormPanel formPanel = (FormPanel)formatter.getPanel(this);
        if (formPanel != null) {
            Dimension dimension = formPanel.getSize();
            int n3 = dimension.width;
            int n4 = dimension.height;
            if (this.isImage) {
                if (docLine != null) {
                    n2 += Align.yOffset(docLine, formatter.displayStyle, this.align, dimension.height);
                }
            } else if (docLine != null) {
                n2 += docLine.height - docLine.getBelow() - formPanel.getPreferredSize().height;
                if (formPanel.getType() > 2 && formPanel.getType() != 12 && docLine.textAscent != 0) {
                    n2 -= docLine.lndescent / 2;
                }
            }
            Graphics graphics2 = graphics.create(n, n2, n3, n4);
            DocStyle docStyle = formatter.displayStyle;
            if (docStyle != null) {
                HJColor hJColor = new HJColor(docStyle.color);
                formPanel.setForeground(hJColor.getContrastingColor());
            }
            boolean bl = formPanel.isVisible();
            try {
                try {
                    if (!bl) {
                        formPanel.setVisible(true);
                    }
                    formPanel.printAll(graphics2);
                }
                catch (Exception exception) {
                }
                Object var15_15 = null;
                graphics2.dispose();
                if (!bl) {
                    formPanel.setVisible(false);
                }
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                graphics2.dispose();
                if (!bl) {
                    formPanel.setVisible(false);
                }
                throw throwable;
            }
            return dimension.width;
        }
        return 0;
    }

    public int print(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine, VBreakInfo vBreakInfo) {
        formatter.displayPos += 4096;
        if (this.alignIsFloating()) {
            return 0;
        }
        return this.printImage(formatter, graphics, n, n2, docLine, vBreakInfo);
    }

    public int paint(Formatter formatter, Graphics graphics, int n, int n2) {
        return this.paintImage(formatter, graphics, n, n2, null);
    }

    public int print(Formatter formatter, Graphics graphics, int n, int n2, VBreakInfo vBreakInfo) {
        return this.printImage(formatter, graphics, n, n2, null, null);
    }

    public int getFormPanel(Formatter formatter, Vector vector) {
        FormPanel formPanel;
        while ((formPanel = (FormPanel)formatter.getPanel(this)) == null && (formatter = formatter.getParentFormatter()) != null) {
        }
        if (formPanel != null) {
            vector.addElement(formPanel);
        }
        return 1;
    }

    public Component createView(Formatter formatter, Document document) {
        FormPanel formPanel = new FormPanel(formatter, document, this, null);
        int n = this.getIndex();
        document.change(n << 12, n + 1 << 12);
        return formPanel;
    }

    public boolean measureItem(Formatter formatter, FormatState formatState, Measurement measurement, MeasureState measureState) {
        FormPanel formPanel = (FormPanel)formatter.getPanel(this);
        if (formPanel != null) {
            Dimension dimension = formPanel.getPreferredSize();
            measurement.setMinWidth(dimension.width);
            measurement.setPreferredWidth(dimension.width);
            if (dimension.equals(new Dimension())) {
                measureState.measurementInvalid = true;
            }
        }
        measureState.pos += 4096;
        return false;
    }

    public void setFormParent(TagItem tagItem) {
        if (tagItem == null || !(tagItem instanceof FORM)) {
            return;
        }
        this.parentForm = (FORM)tagItem;
    }

    public TagItem getFormParent() {
        return this.parentForm;
    }

    private boolean alignIsFloating() {
        return this.align == 7 || this.align == 8;
    }

    public int getAscent(Formatter formatter, FormatState formatState) {
        return Align.getAscent(formatState, this.align, this.getHeight(formatter));
    }

    public int getDescent(Formatter formatter, FormatState formatState) {
        return Align.getDescent(formatState, this.align, this.getHeight(formatter));
    }

    private int getHeight(Formatter formatter) {
        FormPanel formPanel = (FormPanel)formatter.getPanel(this);
        if (formPanel != null) {
            Dimension dimension = formPanel.getPreferredSize();
            return dimension.height;
        }
        return 0;
    }

    protected boolean determineIfTagHasHandlers() {
        Attributes attributes = this.getAttributes();
        if (attributes == null) {
            return false;
        }
        String string = attributes.get("type");
        if (string == null) {
            string = "text";
        }
        if (string.equalsIgnoreCase("text")) {
            return this.myDetermineHandlers(myHandlers[1]);
        }
        if (string.equalsIgnoreCase("password")) {
            return this.myDetermineHandlers(myHandlers[2]);
        }
        if (string.equalsIgnoreCase("checkbox")) {
            return this.myDetermineHandlers(myHandlers[3]);
        }
        if (string.equalsIgnoreCase("radio")) {
            return this.myDetermineHandlers(myHandlers[4]);
        }
        if (string.equalsIgnoreCase("submit")) {
            return this.myDetermineHandlers(myHandlers[5]);
        }
        if (string.equalsIgnoreCase("reset")) {
            return this.myDetermineHandlers(myHandlers[6]);
        }
        if (string.equalsIgnoreCase("image")) {
            return this.myDetermineHandlers(myHandlers[7]);
        }
        if (string.equalsIgnoreCase("hidden")) {
            return this.myDetermineHandlers(myHandlers[8]);
        }
        if (string.equalsIgnoreCase("textarea")) {
            return this.myDetermineHandlers(myHandlers[9]);
        }
        if (string.equalsIgnoreCase("choice")) {
            return this.myDetermineHandlers(myHandlers[10]);
        }
        if (string.equalsIgnoreCase("list")) {
            return this.myDetermineHandlers(myHandlers[11]);
        }
        if (string.equalsIgnoreCase("file")) {
            return this.myDetermineHandlers(myHandlers[12]);
        }
        if (string.equalsIgnoreCase("button")) {
            return this.myDetermineHandlers(myHandlers[13]);
        }
        return false;
    }

    private boolean myDetermineHandlers(String[] stringArray) {
        Attributes attributes = this.getAttributes();
        int n = 0;
        while (n < stringArray.length) {
            if (attributes.get(stringArray[n]) != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean visit(DocItemVisitor docItemVisitor) {
        return docItemVisitor.visitINPUTTag(this);
    }

    public Dimension getSize() {
        return null;
    }

    public boolean hasSize() {
        return false;
    }

    public void waiterTimedOut() {
    }
}

