/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.forms;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import sunw.hotjava.bean.HotJavaBrowserBean;
import sunw.hotjava.bean.ImageCacher;
import sunw.hotjava.doc.DocConstants;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.ElementInfo;
import sunw.hotjava.forms.FormPanel;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.tags.A;

class ImageCanvas
extends Canvas
implements DocConstants {
    private URL imageURL;
    private Document doc;
    boolean depressed;
    boolean usingErrorImage = false;
    static Image errorImage = null;
    boolean badErrorImage = false;
    ActionListener listeners;
    int border = 2;
    int oldWidth = -1;
    int oldHeight = -1;
    boolean needToSize = true;
    private static boolean lazyLoadingNotDone = true;

    public ImageCanvas(Document document, URL uRL, String string) {
        this.imageURL = uRL;
        this.doc = document;
        ImageCanvas.loadLazy();
        this.addMouseListener(new MouseEventListener());
        try {
            this.border = Integer.parseInt(string);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.border = 2;
            return;
        }
    }

    private static synchronized void loadLazy() {
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("beanPropertiesKey");
        if (lazyLoadingNotDone) {
            errorImage = Globals.getImageFromBeanJar_DontUseThisMethod(hJBProperties.getProperty("img.errimg"));
            lazyLoadingNotDone = false;
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.listeners = AWTEventMulticaster.add(this.listeners, actionListener);
    }

    public Dimension preferredSize() {
        if (this.usingErrorImage && errorImage != null) {
            int n = errorImage.getWidth(this);
            int n2 = errorImage.getHeight(this);
            if (n >= 0 && n2 >= 0) {
                return new Dimension(n, n2);
            }
        }
        ImageCacher imageCacher = HotJavaBrowserBean.getImageCache();
        Image image = null;
        if (imageCacher != null) {
            URL uRL = null;
            if (this.doc != null) {
                uRL = this.doc.getBaseURL();
            }
            image = imageCacher.getImage(this.doc, this.imageURL, uRL);
        }
        if (image != null && !this.usingErrorImage) {
            if (this.needToSize) {
                this.oldWidth = image.getWidth(this);
                this.oldHeight = image.getHeight(this);
                this.needToSize = false;
                if (this.usingErrorImage) {
                    return this.preferredSize();
                }
            }
            return new Dimension(this.oldWidth, this.oldHeight);
        }
        return super.preferredSize();
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        int n6;
        Document document;
        Object object;
        FormPanel formPanel;
        if (this.badErrorImage || this.usingErrorImage && image != errorImage) {
            return false;
        }
        if (n4 != this.oldWidth || n5 != this.oldHeight) {
            formPanel = (FormPanel)this.getParent();
            object = Globals.getAwtLock();
            synchronized (object) {
                document = formPanel.doc;
                synchronized (document) {
                    n6 = formPanel.item.getIndex();
                    formPanel.doc.change(n6 << 12, n6 + 1 << 12);
                }
            }
            this.oldWidth = n4;
            this.oldHeight = n5;
        }
        if ((n & 0x40) != 0) {
            if (this.usingErrorImage) {
                this.badErrorImage = true;
                return false;
            }
            this.usingErrorImage = true;
        }
        if ((n & 0x43) != 0) {
            formPanel = (FormPanel)this.getParent();
            object = Globals.getAwtLock();
            synchronized (object) {
                document = formPanel.doc;
                synchronized (document) {
                    n6 = formPanel.item.getIndex();
                    formPanel.doc.change(n6 << 12, n6 + 1 << 12);
                }
            }
        }
        if ((n & 0x30) != 0) {
            formPanel = (FormPanel)this.getParent();
            object = Globals.getAwtLock();
            synchronized (object) {
                document = formPanel.doc;
                synchronized (document) {
                    n6 = formPanel.item.getIndex();
                    formPanel.doc.update(n6 << 12, n6 + 1 << 12);
                }
            }
        }
        if ((n & 0x40) != 0) {
            return false;
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    private void paintBorder(Graphics graphics, Color color) {
        Image image = null;
        ImageCacher imageCacher = HotJavaBrowserBean.getImageCache();
        if (imageCacher != null) {
            URL uRL = null;
            if (this.doc != null) {
                uRL = this.doc.getBaseURL();
            }
            image = imageCacher.getImage(this.doc, this.imageURL, uRL);
        }
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        if (n <= 0 || n2 <= 0) {
            return;
        }
        graphics.setColor(color);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < this.border) {
            graphics.drawRect(n4, n5, n - (n3 * 2 + 1), n2 - (n3 * 2 + 1));
            ++n3;
            ++n4;
            ++n5;
        }
    }

    public void paint(Graphics graphics) {
        ImageCacher imageCacher = HotJavaBrowserBean.getImageCache();
        if (imageCacher != null && !this.badErrorImage) {
            if (!this.usingErrorImage) {
                URL uRL = null;
                if (this.doc != null) {
                    uRL = this.doc.getBaseURL();
                }
                graphics.drawImage(imageCacher.getImage(this.doc, this.imageURL, uRL), 0, 0, this);
            } else {
                graphics.drawImage(errorImage, 0, 0, this);
            }
            if (this.border != 0) {
                this.paintBorder(graphics, A.newColor);
            }
        }
    }

    private void mouseDown(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            ElementInfo elementInfo = new ElementInfo();
            elementInfo.imageURL = this.imageURL.toExternalForm();
            elementInfo.event = mouseEvent;
            ((FormPanel)this.getParent()).win.dispatchDocumentEvent(1027, elementInfo);
            return;
        }
        if (!this.badErrorImage) {
            this.depressed = true;
            if (this.border != 0) {
                Graphics graphics = this.getGraphics();
                try {
                    this.paintBorder(this.getGraphics(), A.activeColor);
                    return;
                }
                finally {
                    Object var4_4 = null;
                    graphics.dispose();
                }
            }
        }
    }

    private void mouseUp(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            ElementInfo elementInfo = new ElementInfo();
            elementInfo.imageURL = this.imageURL.toExternalForm();
            elementInfo.event = mouseEvent;
            ((FormPanel)this.getParent()).win.dispatchDocumentEvent(1027, elementInfo);
            return;
        }
        Point point = mouseEvent.getPoint();
        if (!this.badErrorImage) {
            if (this.depressed && this.inside(point.x, point.y)) {
                Object object;
                if (this.border != 0) {
                    object = this.getGraphics();
                    try {
                        this.paintBorder((Graphics)object, A.newColor);
                    }
                    finally {
                        Object var5_5 = null;
                        ((Graphics)object).dispose();
                    }
                }
                object = String.valueOf(point.x) + ":" + point.y;
                ((FormPanel)this.getParent()).processUserAction(new ActionEvent(this, 1001, (String)object));
            }
            this.depressed = false;
        }
    }

    public void setDimension(int n, int n2) {
        this.oldWidth = n;
        this.oldHeight = n2;
    }

    class MouseEventListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            ImageCanvas.this.mouseDown(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ImageCanvas.this.mouseUp(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ImageCanvas.this.setCursor(new Cursor(12));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ImageCanvas.this.setCursor(new Cursor(0));
        }

        MouseEventListener() {
            ImageCanvas.this = ImageCanvas.this;
        }
    }
}

