/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.protocol.file;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import sun.io.ByteToCharConverter;
import sun.net.www.MessageHeader;
import sun.net.www.MimeEntry;
import sun.net.www.MimeTable;
import sun.net.www.URLConnection;
import sunw.hotjava.misc.Sort;
import sunw.hotjava.protocol.file.StringCompare;

public class FileURLConnection
extends URLConnection {
    private InputStream is;
    private int iconWidth;
    private int iconHeight;
    private String fn;
    private SimpleDateFormat fmt;
    private MimeTable mt;
    private String unitBytes;
    private String unitKb;
    private String unitMb;
    private long lastModified;

    FileURLConnection(URL uRL) {
        super(uRL);
    }

    public void connect() throws IOException {
        this.unitBytes = System.getProperty("file.dir.bytes", "bytes");
        this.unitKb = System.getProperty("file.dir.kb", "Kb");
        this.unitMb = System.getProperty("file.dir.mb", "Mb");
        MessageHeader messageHeader = new MessageHeader();
        this.fn = this.decodeFileName(this.url.getFile());
        try {
            Class.forName("java.text.SimpleDateFormat");
            this.fmt = new SimpleDateFormat(System.getProperty("file.dir.datefmt", "hh:mm a dd, yyyy"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fmt = null;
        }
        this.iconHeight = Integer.getInteger("file.icon.height", 26);
        this.iconWidth = Integer.getInteger("file.icon.width", 24);
        this.mt = MimeTable.getDefaultTable();
        MimeEntry mimeEntry = this.mt.findByFileName(this.fn);
        if (mimeEntry != null) {
            messageHeader.add("content-type", mimeEntry.getType());
        }
        this.setProperties(messageHeader);
        File file = new File(this.fn);
        String string = file.getCanonicalPath();
        String string2 = new File(string).getParent();
        this.lastModified = file.lastModified();
        if (file.isDirectory()) {
            StringBuffer stringBuffer = new StringBuffer();
            Object[] objectArray = file.list();
            if (objectArray == null) {
                throw new FileNotFoundException(this.fn);
            }
            StringCompare stringCompare = new StringCompare();
            Sort.quicksort(objectArray, stringCompare);
            messageHeader.add("content-type", "text/html");
            stringBuffer.append("<title>");
            stringBuffer.append(System.getProperty("file.dir.title", "Directory Listing"));
            stringBuffer.append("</title></head><body>\n");
            stringBuffer.append("<base href=\"");
            stringBuffer.append(this.url.toString().replace(File.separatorChar, '/'));
            if (stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
                stringBuffer.append("/");
            }
            stringBuffer.append("\"><h1>");
            stringBuffer.append(this.fn.substring(this.fn.charAt(0) != File.separatorChar ? 1 : 0).replace('/', File.separatorChar));
            stringBuffer.append("</h1>\n");
            stringBuffer.append("<hr>\n");
            stringBuffer.append("<table border=0>");
            if (string2 != null) {
                this.formatParentDirLine(System.getProperty("file.dir.parent", "Parent Directory"), string2, stringBuffer);
            }
            int n = 0;
            while (n < objectArray.length) {
                this.formatLine((String)objectArray[n], (String)objectArray[n], stringBuffer);
                ++n;
            }
            stringBuffer.append("</table></body></html>");
            this.is = new ByteArrayInputStream(stringBuffer.toString().getBytes());
        } else {
            if (file.exists()) {
                messageHeader.add("Content-length", String.valueOf(file.length()));
                messageHeader.add("last-modified", new Date(file.lastModified()).toString());
            }
            this.is = new BufferedInputStream(new FileInputStream(this.fn.replace('/', File.separatorChar)));
        }
        this.connected = true;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.is;
    }

    private void formatParentDirLine(String string, String string2, StringBuffer stringBuffer) {
        int n;
        String string3;
        int n2 = (string3 = this.url.toString()).lastIndexOf(47, string3.length() - 2);
        string3 = string3.substring(0, n2 > (n = string3.lastIndexOf(File.separatorChar, string3.length() - 2)) ? n2 + 1 : n + 1);
        Date date = new Date(new File(string2).lastModified());
        String string4 = this.fmt == null ? date.toString() : this.fmt.format(date);
        stringBuffer.append("<tr><td> <img align=middle src=\"");
        stringBuffer.append("doc:/lib/images/ftp/directory.gif\" width=" + this.iconWidth + " height=" + this.iconHeight + ">\n");
        stringBuffer.append("</td><td><a href=\"");
        stringBuffer.append(string3);
        stringBuffer.append("\">");
        stringBuffer.append(string);
        stringBuffer.append("</a></td>");
        stringBuffer.append("<td align=\"right\"></td><td>dir</td><td>");
        stringBuffer.append(string4);
        stringBuffer.append("</td></tr>");
    }

    private void formatLine(String string, String string2, StringBuffer stringBuffer) {
        String string3;
        String string4;
        stringBuffer.append("<tr><td> <img align=middle src=\"");
        File file = new File(String.valueOf(this.fn) + "/" + string2);
        if (file.isDirectory()) {
            stringBuffer.append("doc:/lib/images/ftp/directory.gif\" width=" + this.iconWidth + " height=" + this.iconHeight + ">\n");
            string4 = "";
            string3 = "dir";
        } else {
            String string5;
            long l = file.length();
            if (l < 1000L) {
                string3 = this.unitBytes;
            } else if (l < 1000000L) {
                l /= 1000L;
                string3 = this.unitKb;
            } else {
                l /= 1000000L;
                string3 = this.unitMb;
            }
            string4 = Long.toString(l);
            String string6 = "doc:/lib/images/ftp/file.gif";
            MimeEntry mimeEntry = this.mt.findByFileName(string2);
            if (mimeEntry != null && (string5 = mimeEntry.getImageFileName()) != null) {
                string6 = string5;
            }
            stringBuffer.append(string6);
            stringBuffer.append("\" width=" + this.iconWidth + " height=" + this.iconHeight + ">\n");
        }
        Date date = new Date(file.lastModified());
        String string7 = this.fmt == null ? date.toString() : this.fmt.format(date);
        stringBuffer.append("</td><td><a href=\"");
        stringBuffer.append(URLEncoder.encode(string2));
        stringBuffer.append("\">");
        stringBuffer.append(string);
        stringBuffer.append("</a></td>");
        stringBuffer.append("<td align=\"right\">");
        stringBuffer.append(string4);
        stringBuffer.append("</td><td>");
        stringBuffer.append(string3);
        stringBuffer.append("</td><td>");
        stringBuffer.append(string7);
        stringBuffer.append("</td></tr>");
    }

    private String decodeFileName(String string) {
        String string2 = System.getProperty("hotjava.charset");
        try {
            ByteToCharConverter.getConverter((String)string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Charset " + string2 + " is not supported. Use 8859_1");
            string2 = "8859_1";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            boolean bl = false;
            char c = string.charAt(n2);
            if (c == '+') {
                c = ' ';
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while (c == '%') {
                    bl = true;
                    String string3 = string.substring(n2 + 1, n2 + 1 + 2);
                    byteArrayOutputStream.write(Integer.parseInt(string3, 16));
                    if ((n2 += 3) >= n) break;
                    c = string.charAt(n2);
                }
                if (bl) {
                    --n2;
                }
                try {
                    stringBuffer.append(new String(byteArrayOutputStream.toByteArray(), string2));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!bl) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public long getLastModified() {
        return this.lastModified;
    }
}

