/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.security;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.security.AppletSecurityException;
import sunw.hotjava.security.ExtPermissions;
import sunw.hotjava.security.PolicyHigh;
import sunw.hotjava.security.SecurityDialog;

public class PolicyMedium
extends PolicyHigh {
    private static PolicyMedium med;

    public static PolicyMedium getPolicyMedium() {
        if (med == null) {
            med = new PolicyMedium();
        }
        return med;
    }

    protected PolicyMedium() {
    }

    public boolean checkExec(String string) {
        if (super.checkExec(string)) {
            return true;
        }
        ExtPermissions extPermissions = this.findPermissions();
        if (extPermissions != null && extPermissions.execOK()) {
            return true;
        }
        SecurityDialog securityDialog = PolicyMedium.getSecurityDialog();
        int n = securityDialog.getExecAuthorization(string);
        if (n <= 0) {
            return false;
        }
        if (n != 2) {
            return true;
        }
        extPermissions = this.obtainPermissions();
        if (extPermissions != null) {
            extPermissions.allowAllExec();
        }
        return true;
    }

    public boolean checkPropertyAccess(String string) {
        if (super.checkPropertyAccess(string)) {
            return true;
        }
        ExtPermissions extPermissions = this.findPermissions();
        if (extPermissions != null && extPermissions.propOK(string)) {
            return true;
        }
        SecurityDialog securityDialog = PolicyMedium.getSecurityDialog();
        int n = securityDialog.getPropAuthorization(string);
        if (n <= 0) {
            return false;
        }
        extPermissions = this.obtainPermissions();
        if (extPermissions != null) {
            if (n == 2) {
                extPermissions.allowAllProps();
            } else {
                extPermissions.allowProp(string);
            }
        }
        return true;
    }

    private boolean checkFile(String string, URL uRL, boolean bl) {
        Object object;
        if (uRL == null) {
            return true;
        }
        String string2 = this.getRealPath(string);
        ExtPermissions extPermissions = this.findPermissions();
        if (extPermissions != null && (bl ? extPermissions.writeOK(string2) : extPermissions.readOK(string2))) {
            return true;
        }
        String string3 = uRL.getHost();
        if (!bl && uRL.getProtocol().equals("file") && (string3 == null || string3.equals("") || string3.equals("~") || string3.equals("localhost"))) {
            object = null;
            try {
                object = new File(uRL.getFile()).getCanonicalPath();
            }
            catch (IOException iOException) {
                return false;
            }
            if (string2.startsWith((String)object)) {
                System.out.println(" %%%% PolicyMedium : checkFile : ACTION_ALLOWED ");
                return true;
            }
        }
        if ((object = PolicyMedium.getSecurityDialog()) == null) {
            return false;
        }
        int n = bl ? ((SecurityDialog)object).getWriteAuthorization(string2) : ((SecurityDialog)object).getReadAuthorization(string2);
        if (n <= 0) {
            return false;
        }
        extPermissions = this.obtainPermissions();
        if (bl) {
            if (n == 2) {
                extPermissions.allowAllWrite();
            } else {
                extPermissions.allowWrite(string2);
            }
        } else if (n == 2) {
            extPermissions.allowAllRead();
        } else {
            extPermissions.allowRead(string2);
        }
        return true;
    }

    public boolean checkRead(String string, URL uRL) {
        if (super.checkRead(string, uRL)) {
            return true;
        }
        return this.checkFile(string, uRL, false);
    }

    public boolean checkWrite(String string) {
        if (super.checkWrite(string)) {
            return true;
        }
        return this.checkFile(string, this.getCSM().getAppletURL(), true);
    }

    public synchronized boolean checkRead(FileDescriptor fileDescriptor) {
        if (this.getCSM().policyInClass("java.lang.Runtime")) {
            return true;
        }
        return super.checkRead(fileDescriptor);
    }

    public synchronized boolean checkWrite(FileDescriptor fileDescriptor) {
        if (this.getCSM().policyInClass("java.lang.Runtime")) {
            return true;
        }
        return super.checkWrite(fileDescriptor);
    }

    public boolean checkDelete(String string) {
        if (super.checkDelete(string)) {
            return true;
        }
        String string2 = this.getRealPath(string);
        ExtPermissions extPermissions = this.findPermissions();
        if (extPermissions != null && extPermissions.deleteOK(string2)) {
            return true;
        }
        SecurityDialog securityDialog = PolicyMedium.getSecurityDialog();
        if (securityDialog == null) {
            return false;
        }
        int n = securityDialog.getDeleteAuthorization(string2);
        if (n <= 0) {
            return false;
        }
        extPermissions = this.obtainPermissions();
        if (n == 2) {
            extPermissions.allowAllDelete();
        } else {
            extPermissions.allowDelete(string2);
        }
        return true;
    }

    public boolean checkListen(int n) {
        if (super.checkListen(n)) {
            return true;
        }
        ExtPermissions extPermissions = this.findPermissions();
        if (extPermissions != null && extPermissions.listenOK(n)) {
            return true;
        }
        SecurityDialog securityDialog = PolicyMedium.getSecurityDialog();
        int n2 = securityDialog.getListenAuthorization(Integer.toString(n));
        if (n2 <= 0) {
            return false;
        }
        extPermissions = this.obtainPermissions();
        if (extPermissions != null) {
            if (n2 == 2) {
                extPermissions.allowAllListen();
            } else {
                extPermissions.allowListen(n);
            }
        }
        return true;
    }

    public boolean checkAccept(String string, int n) {
        if (super.checkAccept(string, n)) {
            return true;
        }
        ExtPermissions extPermissions = this.findPermissions();
        if (extPermissions != null && extPermissions.acceptOK(string, n)) {
            return true;
        }
        SecurityDialog securityDialog = PolicyMedium.getSecurityDialog();
        int n2 = securityDialog.getAcceptAuthorization(string);
        if (n2 <= 0) {
            return false;
        }
        extPermissions = this.obtainPermissions();
        if (extPermissions != null) {
            if (n2 == 2) {
                extPermissions.allowAllAccept();
            } else {
                extPermissions.allowAccept(string, n);
            }
        }
        return true;
    }

    public boolean checkConnect(String string, String string2, boolean bl) {
        if (super.checkConnect(string, string2, bl)) {
            return true;
        }
        ExtPermissions extPermissions = this.findPermissions();
        if (extPermissions != null && extPermissions.connectOK(string2, 0)) {
            return true;
        }
        if (this.testConnect(string, string2, bl)) {
            return true;
        }
        SecurityDialog securityDialog = PolicyMedium.getSecurityDialog();
        int n = securityDialog.getConnectAuthorization(string2);
        if (n <= 0) {
            return false;
        }
        extPermissions = this.obtainPermissions();
        if (extPermissions != null) {
            if (n == 2) {
                extPermissions.allowAllConnect();
            } else {
                extPermissions.allowConnect(string2, 0);
            }
        }
        return true;
    }

    public boolean checkMulticast(InetAddress inetAddress) {
        if (super.checkMulticast(inetAddress)) {
            return true;
        }
        ExtPermissions extPermissions = this.findPermissions();
        if (extPermissions != null && extPermissions.multicastOK(inetAddress)) {
            return true;
        }
        SecurityDialog securityDialog = PolicyMedium.getSecurityDialog();
        int n = securityDialog.getConnectAuthorization("<multicast>");
        if (n <= 0) {
            return false;
        }
        extPermissions = this.obtainPermissions();
        if (extPermissions != null) {
            if (n == 2) {
                extPermissions.allowAllConnect();
            } else {
                extPermissions.allowConnect("<multicast>", 0);
            }
        }
        return true;
    }

    static final SecurityDialog getSecurityDialog() {
        SecurityDialog securityDialog = new SecurityDialog(HJBProperties.getLastFocusHolder());
        if (securityDialog == null) {
            throw new AppletSecurityException("feedback.prevented");
        }
        return securityDialog;
    }
}

