/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import sunw.hotjava.HJFrame;
import sunw.hotjava.bean.HTMLBrowsable;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.FindDialogButtonPane;
import sunw.hotjava.ui.FindDialogFormPane;
import sunw.hotjava.ui.FindDialogNotFoundDialog;
import sunw.hotjava.ui.UIHJButton;
import sunw.hotjava.ui.UIHJButtonGroup;
import sunw.hotjava.ui.UserCheckbox;
import sunw.hotjava.ui.UserDialog;
import sunw.hotjava.ui.UserLabel;
import sunw.hotjava.ui.UserTextField;

public class FindStringDialog
extends UserDialog {
    UserCheckbox caseSensitiveCheckbox;
    UserTextField textField;
    UIHJButton findButton;
    UIHJButton clearButton;
    UIHJButton dismissButton;
    ActionListener actionEventsListener;
    KeyListener enterHitListener;
    HTMLBrowsable bean;
    int currentPosition;
    boolean result = false;
    Frame frame;
    HJBProperties props;

    public FindStringDialog(String string, HJFrame hJFrame, HJBProperties hJBProperties) {
        this(string, hJFrame, false, hJBProperties);
    }

    public FindStringDialog(String string, HJFrame hJFrame, boolean bl, HJBProperties hJBProperties) {
        super(string, hJFrame, bl, hJBProperties);
        this.frame = hJFrame;
        this.props = hJBProperties;
        this.actionEventsListener = new ActionEventsListener();
        this.enterHitListener = new EnterHitListener();
        this.bean = hJFrame.getHTMLBrowsable();
        this.init();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.textField.requestFocus();
        }
    }

    public boolean getResult() {
        return this.result;
    }

    public void action(String string) {
        if (string.equals(this.findButton.getActionCommand())) {
            this.result = this.find();
            return;
        }
        if (string.equals(this.clearButton.getActionCommand())) {
            this.clear();
            return;
        }
        if (string.equals(this.dismissButton.getActionCommand())) {
            this.dismiss();
            return;
        }
    }

    private boolean find() {
        boolean bl = false;
        String string = this.textField.getText();
        if (string != null && string.length() > 0) {
            this.currentPosition = this.bean.find(this.currentPosition, string, !this.caseSensitiveCheckbox.getState());
            if (this.currentPosition == -1) {
                FindDialogNotFoundDialog findDialogNotFoundDialog = new FindDialogNotFoundDialog("finddialog.not.found", this.frame, true, this.props);
                Point point = this.frame.getLocationOnScreen();
                Dimension dimension = this.frame.getSize();
                findDialogNotFoundDialog.pack();
                Dimension dimension2 = findDialogNotFoundDialog.getSize();
                int n = (point.x + dimension.width) / 2;
                int n2 = (point.y + dimension.height) / 2;
                int n3 = n - dimension2.width / 4;
                int n4 = n2 - dimension2.height / 4;
                ((Component)findDialogNotFoundDialog).setLocation(n3, n4);
                findDialogNotFoundDialog.show();
                this.currentPosition = 0;
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private boolean clear() {
        this.currentPosition = 0;
        ((TextComponent)this.textField).setText("");
        this.textField.requestFocus();
        return true;
    }

    private boolean dismiss() {
        ((Component)this).hide();
        return true;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.initFormPane();
        this.initButtonsPane();
        this.pack();
        this.centerOnScreen();
        this.currentPosition = 0;
    }

    private void initFormPane() {
        FindDialogFormPane findDialogFormPane = new FindDialogFormPane();
        findDialogFormPane.setLayout(new GridBagLayout());
        this.textField = new UserTextField("finddialog.textfield");
        UserLabel userLabel = new UserLabel("finddialog.label");
        this.caseSensitiveCheckbox = new UserCheckbox("finddialog.casesensitive", HJBProperties.getHJBProperties("hjbrowser"));
        this.constrain(userLabel, 0, 0, 13, 1, findDialogFormPane);
        this.constrain(this.textField, 1, 0, 17, 0, findDialogFormPane);
        this.constrain(this.caseSensitiveCheckbox, 1, 1, 17, 1, findDialogFormPane);
        this.add("Center", findDialogFormPane);
        this.textField.addActionListener(this.actionEventsListener);
    }

    private void initButtonsPane() {
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("hjbrowser");
        FindDialogButtonPane findDialogButtonPane = new FindDialogButtonPane();
        UIHJButtonGroup uIHJButtonGroup = new UIHJButtonGroup(hJBProperties);
        findDialogButtonPane.setLayout(new FlowLayout(2));
        this.findButton = new UIHJButton("finddialog.findbutton", hJBProperties);
        findDialogButtonPane.add(this.findButton);
        this.findButton.addActionListener(this.actionEventsListener);
        this.findButton.addKeyListener(this.enterHitListener);
        uIHJButtonGroup.addButtonToGroup(this.findButton);
        this.clearButton = new UIHJButton("finddialog.clearbutton", hJBProperties);
        findDialogButtonPane.add(this.clearButton);
        this.clearButton.addActionListener(this.actionEventsListener);
        this.clearButton.addKeyListener(this.enterHitListener);
        uIHJButtonGroup.addButtonToGroup(this.clearButton);
        this.dismissButton = new UIHJButton("finddialog.dismissbutton", hJBProperties);
        findDialogButtonPane.add(this.dismissButton);
        this.dismissButton.addActionListener(this.actionEventsListener);
        this.dismissButton.addKeyListener(this.enterHitListener);
        uIHJButtonGroup.addButtonToGroup(this.clearButton);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("Center", findDialogButtonPane);
        this.add("South", panel);
    }

    private void constrain(Component component, int n, int n2, int n3, int n4, Container container) {
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n4;
        gridBagConstraints.anchor = n3;
        container.add(component);
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private final class ActionEventsListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == FindStringDialog.this.textField) {
                FindStringDialog.this.find();
                return;
            }
            FindStringDialog.this.action(actionEvent.getActionCommand());
        }

        ActionEventsListener() {
            FindStringDialog.this = FindStringDialog.this;
        }
    }

    private final class EnterHitListener
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\r') {
                FindStringDialog.this.action(((UIHJButton)keyEvent.getSource()).getActionCommand());
            }
        }

        EnterHitListener() {
            FindStringDialog.this = FindStringDialog.this;
        }
    }
}

