/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.io.ByteToCharConverter;
import sunw.hotjava.HJFrame;
import sunw.hotjava.HJWindowManager;
import sunw.hotjava.misc.Compare;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.misc.RequestProcessor;
import sunw.hotjava.misc.SortVector;
import sunw.hotjava.ui.AlphabeticalCompare;
import sunw.hotjava.ui.ConfirmDialog;
import sunw.hotjava.ui.DateVisitedCompare;
import sunw.hotjava.ui.HotListEntry;
import sunw.hotjava.ui.HotListEvent;
import sunw.hotjava.ui.HotListEventMulticaster;
import sunw.hotjava.ui.HotListFrame;
import sunw.hotjava.ui.HotListHTMLParser;
import sunw.hotjava.ui.HotListListener;
import sunw.hotjava.ui.HotListReader;
import sunw.hotjava.ui.HotListWriter;
import sunw.hotjava.ui.PageFolder;
import sunw.hotjava.ui.Separator;
import sunw.hotjava.ui.UserFileDialog;
import sunw.hotjava.ui.UserMenu;
import sunw.hotjava.ui.UserMenuItem;
import sunw.hotjava.ui.VisitFrequencyCompare;
import sunw.hotjava.ui.Webmark;
import sunw.html.DTD;

public class HotList {
    private static HotList hotList = null;
    static final String officialVersionNumber = "hotjava-hotlist-version-2";
    static final String inMenuTag = " inMenu";
    static final String propName = "hotlist";
    String untitledTitle;
    String newPlaces;
    String coolPlaces;
    String menuPlaces;
    UserMenu rememberToMenu;
    UserMenu listsMenu;
    String hotListsMenu;
    String rememberMenu;
    private static int gotoMenuCount;
    private long fileTimeStamp;
    static final int ADD_TO_END = -5;
    String hotlistName;
    File hotlistFile;
    DTD dtd;
    String fileDialogDirectory;
    String exportFile;
    String importFile;
    static final boolean debug = false;
    PageFolder regularFolder;
    PageFolder currentRegularFolder;
    Stack folderStack;
    boolean importingOurType = false;
    boolean menusOn = false;
    String doctype;
    HotListWriter writer;
    HotListReader threadReader;
    public static final int SORTATOZ = 70;
    public static final int SORTDATES = 71;
    public static final int SORTFREQ = 72;
    public static final int SORTREVERSE = 73;
    protected HotListListener listeners;
    private HJBProperties properties = HJBProperties.getHJBProperties("hjbrowser");
    private HJBProperties beanProps = HJBProperties.getHJBProperties("beanPropertiesKey");

    public synchronized void addHotListListener(HotListListener hotListListener) {
        this.listeners = HotListEventMulticaster.add(this.listeners, hotListListener);
    }

    public synchronized void removeHotListListener(HotListListener hotListListener) {
        this.listeners = HotListEventMulticaster.remove(this.listeners, hotListListener);
    }

    protected void dispatchHotListEvent(int n, Object object) {
        if (this.listeners != null) {
            HotListEvent hotListEvent = new HotListEvent(this, n, object);
            this.listeners.hotlistChanged(hotListEvent);
        }
    }

    void dbg(String string) {
    }

    public static HotList getHotList() {
        if (hotList == null) {
            hotList = new HotList();
        }
        return hotList;
    }

    private HotList() {
        Object object;
        Object object2;
        this.untitledTitle = this.properties.getProperty("hotlist.untitled");
        this.newPlaces = this.properties.getProperty("hotlist.newplaces");
        this.coolPlaces = this.properties.getProperty("hotlist.coolplaces");
        this.menuPlaces = this.properties.getProperty("hotlist.menuplaces", "");
        this.hotListsMenu = this.properties.getProperty("hotlist.lists.menu");
        this.rememberMenu = this.properties.getProperty("hotlist.remember.menu");
        boolean bl = false;
        this.writer = new HotListWriter(this);
        this.threadReader = new HotListReader(this);
        this.hotlistName = this.properties.getProperty("hotlist.listname");
        this.listsMenu = new UserMenu(this.hotListsMenu, null);
        this.rememberToMenu = new UserMenu(this.rememberMenu, null);
        this.regularFolder = new PageFolder(null, this.hotlistName, true);
        this.regularFolder.setUserMenu(this.listsMenu);
        this.currentRegularFolder = this.regularFolder;
        this.folderStack = new Stack();
        String string = this.beanProps.getProperty("dtd");
        try {
            this.dtd = DTD.getDTD(string);
        }
        catch (IOException iOException) {
            throw new Error("could not get default dtd: " + string);
        }
        this.dtd = HotList.createDTD(this.dtd, string);
        String string2 = this.properties.getProperty("user.home");
        if (string2 != null && !string2.endsWith(File.separator)) {
            string2 = String.valueOf(string2) + File.separator;
        }
        this.importFile = this.exportFile = String.valueOf(string2) + ".hotjava" + File.separator + "hotlist.html";
        try {
            object2 = new File(this.importFile);
            bl = ((File)object2).exists();
        }
        catch (Exception exception) {}
        if (!bl) {
            this.addGotoFolder(this.newPlaces, true, -5);
            this.addGotoFolder(this.coolPlaces, true, -5);
            if (!this.menuPlaces.equals("")) {
                this.addGotoFolder(this.menuPlaces, true, -5);
            }
            object2 = this.regularFolder.getChildFolder(this.coolPlaces);
            object = this.currentRegularFolder;
            this.currentRegularFolder = object2;
            this.addPlaces(this.properties.getProperty("hotlist.coolplaceslist"));
            if (!this.menuPlaces.equals("")) {
                PageFolder pageFolder;
                this.currentRegularFolder = pageFolder = this.regularFolder.getChildFolder(this.menuPlaces);
            }
            this.addPlaces(this.properties.getProperty("hotlist.menuplaceslist", ""));
            this.currentRegularFolder = object;
        }
        object2 = "";
        try {
            object2 = String.valueOf(string2) + ".netscape" + File.separator + "bookmarks.html";
            object = new File((String)object2);
            bl = ((File)object).exists();
            if (!bl) {
                object2 = String.valueOf(string2) + ".netscape" + File.separator + "bookmarks.htm";
                object = new File((String)object2);
                bl = ((File)object).exists();
            }
        }
        catch (Exception exception) {}
        this.importHTMLFile(this.importFile, true, (String)object2);
    }

    public long getFileTimeStamp() {
        return this.fileTimeStamp;
    }

    public void setFileTimeStamp(long l) {
        this.fileTimeStamp = l;
    }

    public boolean processDoctype(String string) {
        boolean bl = true;
        this.doctype = string;
        String string2 = this.properties.getProperty("hotlist.netscapeVersion");
        if (this.doctype.toLowerCase().indexOf(string2) != -1) {
            String string3 = this.properties.getProperty("hotlist.netscape");
            string3 = this.getUniqueName(string3);
            this.addGotoFolder(string3, true, -5);
            this.importingOurType = false;
            this.folderPush();
            bl = false;
        } else if (this.doctype.toLowerCase().indexOf(officialVersionNumber) != -1) {
            bl = false;
        }
        return bl;
    }

    public boolean importOurType() {
        return this.importingOurType;
    }

    public String getHotListName() {
        return this.hotlistName;
    }

    public boolean canHandleHTML() {
        return this.dtd != null;
    }

    String normalizeTitle(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            string2 = String.valueOf(this.untitledTitle) + "(" + string + ")";
        }
        return string2;
    }

    public void addCurrent(URL uRL, String string, String string2) {
        this.addCurrentItem(uRL.toString(), string, string2);
    }

    public synchronized void addItemToFolder(String string, String string2, PageFolder pageFolder, int n) {
        HotListEntry hotListEntry;
        string2 = this.normalizeTitle(string, string2);
        String string3 = this.properties.getPropertyReplace("hotlist.addtogo.msg", string2, pageFolder.title);
        Vector vector = pageFolder.getContents();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            hotListEntry = (HotListEntry)vector.elementAt(n3);
            if (hotListEntry.url.equals(string)) {
                string3 = this.properties.getPropertyReplace("hotlist.entryexists.msg", string2, pageFolder.title);
                HotListFrame hotListFrame = HotListFrame.getHotListFrame();
                if (HotListFrame.frameVisible() && !HotListFrame.isIconified()) {
                    hotListFrame.setMessage(string3);
                    return;
                }
                HJFrame hJFrame = HJWindowManager.getHJWindowManager().getLastFocusHolder();
                hJFrame.showStatus(string3);
                return;
            }
            ++n3;
        }
        int n4 = (int)(System.currentTimeMillis() / 1000L);
        hotListEntry = new Webmark(pageFolder, string, string2, 0, n4);
        if (n == -5) {
            pageFolder.addElement(hotListEntry);
        } else {
            pageFolder.addElement(hotListEntry, n);
        }
        this.addToMenus(hotListEntry, -5);
        this.dispatchHotListEvent(50, hotListEntry);
        HotListFrame hotListFrame = HotListFrame.getHotListFrame();
        if (HotListFrame.frameVisible() && !HotListFrame.isIconified()) {
            hotListFrame.setMessage(string3);
            return;
        }
        HJFrame hJFrame = HJWindowManager.getHJWindowManager().getLastFocusHolder();
        hJFrame.showStatus(string3);
    }

    public synchronized void addCurrentItem(String string, String string2, String string3) {
        PageFolder pageFolder;
        if (string3 == null || string3.startsWith("addgoto")) {
            pageFolder = this.regularFolder.getChildFolder(this.newPlaces);
            if (pageFolder == null) {
                PageFolder pageFolder2 = this.currentRegularFolder;
                this.currentRegularFolder = this.regularFolder;
                this.addGotoFolder(this.newPlaces, true, 0);
                this.currentRegularFolder = pageFolder2;
                pageFolder = this.regularFolder.getChildFolder(this.newPlaces);
            }
        } else {
            pageFolder = this.regularFolder.getChildFolder(string3);
            if (pageFolder == null) {
                return;
            }
        }
        this.addItemToFolder(string, string2, pageFolder, -5);
    }

    public boolean addFolder(PageFolder pageFolder, String string, boolean bl, int n) {
        this.currentRegularFolder = pageFolder;
        boolean bl2 = this.addGotoFolder(string, bl, n);
        if (bl2) {
            HotListFrame hotListFrame;
            String string2 = this.properties.getPropertyReplace("hotlist.addtogo.msg", string, this.currentRegularFolder.title);
            if (pageFolder.getParent() == null) {
                string2 = String.valueOf(this.properties.getProperty("hotlist.added.list.msg", "Added new list")) + " " + string;
            }
            if ((hotListFrame = HotListFrame.getHotListFrame()) != null) {
                hotListFrame.setMessage(string2);
            }
        }
        this.currentRegularFolder = this.regularFolder;
        return bl2;
    }

    public synchronized boolean addGotoFolder(String string, boolean bl, int n) {
        return this.addGotoFolder(string, bl, 0, 0, 0, "false", n);
    }

    public synchronized boolean addGotoFolder(String string, boolean bl, int n, int n2, int n3, String string2, int n4) {
        HotListFrame hotListFrame;
        HotListEntry hotListEntry = null;
        String string3 = this.properties.getPropertyReplace("hotlist.addtogo.msg", string, this.currentRegularFolder.title);
        PageFolder pageFolder = this.currentRegularFolder.parent;
        Vector vector = this.currentRegularFolder.getContents();
        int n5 = vector.size();
        int n6 = 0;
        while (n6 < n5) {
            hotListEntry = (HotListEntry)vector.elementAt(n6);
            if (hotListEntry.title.equals(string)) {
                string3 = pageFolder != null ? this.properties.getPropertyReplace("hotlist.entryexists.msg", string, this.currentRegularFolder.title) : this.properties.getPropertyReplace("hotlist.listexists.msg", string);
                HotListFrame hotListFrame2 = HotListFrame.getHotListFrame();
                if (hotListFrame2 != null) {
                    hotListFrame2.setMessage(string3);
                }
                return false;
            }
            ++n6;
        }
        PageFolder pageFolder2 = this.currentRegularFolder.getParent();
        string3 = this.properties.getPropertyReplace("hotlist.addtogo.msg", string, this.currentRegularFolder.title);
        if (pageFolder2 == null) {
            string3 = String.valueOf(this.properties.getProperty("hotlist.added.list.msg", "Added list")) + " " + string;
        }
        if ((hotListFrame = HotListFrame.getHotListFrame()) != null) {
            hotListFrame.setMessage(string3);
        }
        PageFolder pageFolder3 = new PageFolder(this.currentRegularFolder, string, pageFolder == null ? true : bl, n, n2, n3, string2);
        if (n4 == -5) {
            this.currentRegularFolder.addElement(pageFolder3);
        } else {
            this.currentRegularFolder.addElement(pageFolder3, n4);
        }
        this.addToMenus(pageFolder3, n4);
        if (pageFolder == null) {
            this.dispatchHotListEvent(53, pageFolder3);
        } else {
            this.propagateVisitCountAndLastVisit(pageFolder3, n, n2);
            this.dispatchHotListEvent(50, pageFolder3);
        }
        return true;
    }

    public void folderPop() {
        if (this.folderStack.empty()) {
            this.currentRegularFolder = this.regularFolder;
            return;
        }
        this.folderStack.pop();
        if (this.folderStack.empty()) {
            this.currentRegularFolder = this.regularFolder;
            return;
        }
        this.currentRegularFolder = (PageFolder)this.folderStack.peek();
    }

    public void folderPush() {
        PageFolder pageFolder = this.currentRegularFolder.getLastAddedPageFolder();
        if (pageFolder != null) {
            this.folderStack.push(pageFolder);
            this.currentRegularFolder = pageFolder;
            return;
        }
        this.folderStack.push(this.currentRegularFolder);
    }

    public synchronized boolean pasteFolder(PageFolder pageFolder, PageFolder pageFolder2, boolean bl, int n) {
        PageFolder pageFolder3 = (PageFolder)pageFolder2.clone();
        boolean bl2 = this.addFolder(pageFolder, pageFolder3.getTitle(), bl, n);
        if (!bl2) {
            return bl2;
        }
        Vector vector = pageFolder.getContents();
        if (vector == null) {
            return bl2;
        }
        String string = pageFolder3.title;
        PageFolder pageFolder4 = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            HotListEntry hotListEntry = (HotListEntry)vector.elementAt(n2);
            if (hotListEntry.title.equals(string) && hotListEntry instanceof PageFolder) {
                pageFolder4 = (PageFolder)hotListEntry;
                break;
            }
            ++n2;
        }
        vector = pageFolder3.getContents();
        if (vector == null) {
            return bl2;
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            HotListEntry hotListEntry = (HotListEntry)vector.elementAt(n3);
            if (hotListEntry instanceof PageFolder) {
                this.pasteFolder(pageFolder4, (PageFolder)hotListEntry, ((PageFolder)hotListEntry).closed(), n3);
            } else {
                pageFolder4.addElement(hotListEntry);
                hotListEntry.setParentListContainer(pageFolder4);
                this.addToMenus(hotListEntry, -5);
            }
            ++n3;
        }
        this.printFolder(pageFolder);
        return bl2;
    }

    public synchronized boolean pasteWebmark(PageFolder pageFolder, Webmark webmark, int n) {
        PageFolder pageFolder2 = this.currentRegularFolder;
        this.currentRegularFolder = pageFolder;
        String string = webmark.getURL();
        String string2 = webmark.getTitle();
        int n2 = webmark.getVisitCount();
        int n3 = webmark.getLastVisit();
        boolean bl = this.addGotoItem(string, string2, n2, n3, n);
        this.currentRegularFolder = pageFolder2;
        return bl;
    }

    public synchronized void addGotoItem(URL uRL, String string) {
        this.addGotoItem(uRL.toString(), string);
    }

    public synchronized void addGotoItem(String string, String string2) {
        this.addGotoItem(string, string2, 0, 0, -5);
    }

    public synchronized boolean addGotoItem(String string, String string2, int n, int n2, int n3) {
        HotListEntry hotListEntry;
        string2 = this.normalizeTitle(string, string2);
        Vector vector = this.currentRegularFolder.getContents();
        int n4 = vector.size();
        int n5 = 0;
        while (n5 < n4) {
            hotListEntry = (HotListEntry)vector.elementAt(n5);
            if (hotListEntry.url.equals(string)) {
                String string3 = this.properties.getPropertyReplace("hotlist.entryexists.msg", string2, this.currentRegularFolder.title);
                HotListFrame hotListFrame = HotListFrame.getHotListFrame();
                if (hotListFrame != null) {
                    hotListFrame.setMessage(string3);
                }
                return false;
            }
            ++n5;
        }
        String string4 = this.properties.getPropertyReplace("hotlist.addtogo.msg", string2, this.currentRegularFolder.title);
        HotListFrame hotListFrame = HotListFrame.getHotListFrame();
        if (hotListFrame != null) {
            hotListFrame.setMessage(string4);
        }
        hotListEntry = new Webmark(this.currentRegularFolder, string, string2, n, n2);
        if (n3 == -5) {
            this.currentRegularFolder.addElement(hotListEntry);
        } else {
            this.currentRegularFolder.addElement(hotListEntry, n3);
        }
        this.addToMenus(hotListEntry, n3);
        this.propagateVisitCountAndLastVisit(hotListEntry, n, n2);
        this.dispatchHotListEvent(50, hotListEntry);
        return true;
    }

    public synchronized void addSeparatorItem() {
        this.addSeparatorItem(this.currentRegularFolder, -5);
    }

    public synchronized void addSeparatorItem(PageFolder pageFolder, int n) {
        Separator separator = new Separator(pageFolder, " ", "separator");
        if (n == -5) {
            pageFolder.addElement(separator);
        } else {
            pageFolder.addElement(separator, n);
        }
        String string = this.properties.getPropertyReplace("hotlist.addtogo.msg", separator.getTitle(), this.currentRegularFolder.title);
        HotListFrame hotListFrame = HotListFrame.getHotListFrame();
        if (hotListFrame != null) {
            hotListFrame.setMessage(string);
        }
        this.addToMenus(separator, n);
        this.dispatchHotListEvent(50, separator);
    }

    public synchronized void changeFolderValue(HotListEntry hotListEntry, boolean bl) {
        if (!(hotListEntry instanceof PageFolder)) {
            return;
        }
        PageFolder pageFolder = (PageFolder)hotListEntry;
        this.dbg(" Folder = " + pageFolder);
        pageFolder.setClosedValue(bl);
        this.dispatchHotListEvent(52, hotListEntry);
    }

    public synchronized void deleteGotoItem(HotListEntry hotListEntry) {
        HotListFrame hotListFrame;
        String string = hotListEntry.title;
        if ((string.equals(this.newPlaces) || string.equals(this.coolPlaces) || string.equals(this.menuPlaces)) && hotListEntry.getGrandParent() == null) {
            String string2 = this.properties.getProperty("hotlist.nodelete.msg");
            HotListFrame hotListFrame2 = HotListFrame.getHotListFrame();
            if (hotListFrame2 != null) {
                hotListFrame2.setMessage(string2);
            }
            return;
        }
        PageFolder pageFolder = hotListEntry.parent.parent;
        String string3 = this.properties.getPropertyReplace("hotlist.delete.msg", hotListEntry.title, hotListEntry.parent.title);
        if (pageFolder == null) {
            string3 = String.valueOf(this.properties.getProperty("hotlist.deleted.list.msg", "Deleted list")) + " " + hotListEntry.title;
        }
        if ((hotListFrame = HotListFrame.getHotListFrame()) != null) {
            hotListFrame.setMessage(string3);
        }
        if (pageFolder == null) {
            this.dispatchHotListEvent(54, hotListEntry);
        } else {
            this.dispatchHotListEvent(51, hotListEntry);
        }
        this.removeFromFolder(this.regularFolder, hotListEntry);
    }

    synchronized boolean removeFromFolder(PageFolder pageFolder, HotListEntry hotListEntry) {
        Vector vector = pageFolder.getContents();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            PageFolder pageFolder2;
            HotListEntry hotListEntry2 = (HotListEntry)vector.elementAt(n2);
            if (hotListEntry2 == hotListEntry) {
                this.removeFromMenus(hotListEntry);
                vector.removeElementAt(n2);
                return true;
            }
            if (hotListEntry2 instanceof PageFolder && this.removeFromFolder(pageFolder2 = (PageFolder)hotListEntry2, hotListEntry)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized void addMenusToFrame(HJFrame hJFrame) {
        UserMenu userMenu = hJFrame.getGotoMenu();
        if (userMenu != null) {
            gotoMenuCount = userMenu.getItemCount();
            UserMenu userMenu2 = this.rememberToMenu.clone(hJFrame.getActionListener());
            int n = userMenu.getItemPosition(this.rememberMenu);
            if (n != -1) {
                userMenu.remove(n);
                userMenu.insert(userMenu2, n);
            }
            while (!this.threadReader.isFinishedImporting()) {
                try {
                    this.wait(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            UserMenu userMenu3 = this.listsMenu.clone(hJFrame.getActionListener());
            n = userMenu.getItemPosition(this.hotListsMenu);
            if (n != -1) {
                userMenu.remove(n);
                userMenu.insert(userMenu3, n);
            }
            this.updateMenuPlaces(hJFrame);
        }
    }

    public synchronized void updateMenuPlaces(HJFrame hJFrame) {
        boolean bl = this.properties.getBoolean("hotlistmenucheckbox.state");
        if (bl) {
            this.addMenuPlaces(hJFrame);
            return;
        }
        this.removeMenuPlaces(hJFrame);
    }

    private void addMenuPlaces(HJFrame hJFrame) {
        UserMenu userMenu = hJFrame.getGotoMenu();
        UserMenu userMenu2 = this.listsMenu.clone(hJFrame.getActionListener());
        UserMenu userMenu3 = (UserMenu)userMenu2.getItem(this.menuPlaces);
        if (userMenu3 != null && userMenu.getItemCount() == gotoMenuCount) {
            userMenu2.remove(userMenu3);
            userMenu.addSeparator();
            while (userMenu3.getItemCount() > 0) {
                MenuItem menuItem = userMenu3.getItem(0);
                userMenu.add(menuItem);
            }
        }
    }

    private void removeMenuPlaces(HJFrame hJFrame) {
        UserMenu userMenu = hJFrame.getGotoMenu();
        PageFolder pageFolder = this.regularFolder.getChildFolder(this.menuPlaces);
        if (pageFolder != null && userMenu.getItemCount() > gotoMenuCount) {
            int n = pageFolder.getCount();
            int n2 = userMenu.getItemCount();
            int n3 = 0;
            while (n != 0 && n3 < n + 1) {
                userMenu.remove(--n2);
                ++n3;
            }
        }
    }

    public void reparent(HotListEntry hotListEntry, PageFolder pageFolder, int n) {
        String string = this.properties.getProperty("hotlist.netscape");
        if (pageFolder.title.equals(string)) {
            return;
        }
        HotListFrame.getHotListFrame();
        if (!(hotListEntry instanceof Separator) && pageFolder != hotListEntry.getParent() && pageFolder.isChild(hotListEntry.getTitle())) {
            String string2 = this.properties.getPropertyReplace("hotlist.entryexists.msg", hotListEntry.getTitle(), pageFolder.getTitle());
            HotListFrame hotListFrame = HotListFrame.getHotListFrame();
            if (hotListFrame != null) {
                hotListFrame.setMessage(string2);
            }
            return;
        }
        this.deleteGotoItem(hotListEntry);
        if (hotListEntry instanceof PageFolder) {
            this.pasteFolder(pageFolder, (PageFolder)hotListEntry, ((PageFolder)hotListEntry).closed(), n);
            this.dispatchHotListEvent(50, hotListEntry);
            return;
        }
        if (hotListEntry instanceof Webmark) {
            this.pasteWebmark(pageFolder, (Webmark)hotListEntry, n);
            this.dispatchHotListEvent(50, hotListEntry);
            return;
        }
        if (hotListEntry instanceof Separator) {
            this.addSeparatorItem(pageFolder, n);
            this.dispatchHotListEvent(50, hotListEntry);
        }
    }

    public UserMenu getSpecificMenu(UserMenu userMenu, PageFolder pageFolder, String string) {
        UserMenu userMenu2 = pageFolder.getUserMenu();
        String string2 = userMenu2.getName();
        if (string2.equals(string)) {
            return userMenu;
        }
        UserMenu userMenu3 = this.getSpecificMenu(userMenu, pageFolder.getParent(), string);
        int n = 0;
        while (userMenu3 != null && n < userMenu3.getItemCount()) {
            MenuItem menuItem = userMenu3.getItem(n);
            String string3 = menuItem.getName();
            if (menuItem instanceof UserMenu && string3.equals(pageFolder.getTitle())) {
                return (UserMenu)menuItem;
            }
            ++n;
        }
        return null;
    }

    synchronized void addMenuItem(MenuItem menuItem, UserMenu userMenu, int n) {
        RequestProcessor.getHJBeanQueue().postRequest(new 1(menuItem, userMenu, n));
    }

    synchronized void addToMenus(HotListEntry hotListEntry, int n) {
        HJFrame[] hJFrameArray = HJWindowManager.getHJWindowManager().getAllFrames();
        int n2 = 0;
        while (n2 < hJFrameArray.length) {
            UserMenu userMenu;
            UserMenu userMenu2;
            if (hotListEntry.getParent() == this.regularFolder) {
                userMenu2 = hJFrameArray[n2].getRememberToMenu();
                this.addToRememberToMenu(hotListEntry, userMenu2, hJFrameArray[n2].getActionListener());
            }
            if (hotListEntry.isInMenuPlacesFolder() && hJFrameArray[n2].getListsMenu() != null) {
                userMenu2 = hJFrameArray[n2].getGotoMenu();
                if (hotListEntry.getParent().getTitle().equals(this.menuPlaces) && hotListEntry.getParent().getCount() == 1) {
                    userMenu2.addSeparator();
                }
                userMenu = this.getSpecificMenu(userMenu2, hotListEntry.getParent(), this.menuPlaces);
                this.addToMenu(hotListEntry, userMenu, hJFrameArray[n2].getActionListener(), n);
            } else if (!this.menuPlaces.equals(hotListEntry.getTitle())) {
                userMenu2 = hJFrameArray[n2].getListsMenu();
                userMenu = this.getSpecificMenu(userMenu2, hotListEntry.getParent(), this.hotListsMenu);
                this.addToMenu(hotListEntry, userMenu, hJFrameArray[n2].getActionListener(), n);
            }
            ++n2;
        }
        if (hotListEntry.getParent() == this.regularFolder) {
            this.addToRememberToMenu(hotListEntry, this.rememberToMenu, null);
        }
        MenuItem menuItem = this.addToMenu(hotListEntry, hotListEntry.getParent().getUserMenu(), null, n);
        if (hotListEntry instanceof PageFolder) {
            UserMenu userMenu = (UserMenu)menuItem;
            PageFolder pageFolder = (PageFolder)hotListEntry;
            pageFolder.setUserMenu(userMenu);
        }
    }

    synchronized void addToRememberToMenu(HotListEntry hotListEntry, UserMenu userMenu, ActionListener actionListener) {
        String string = this.properties.getProperty("hotlist.netscape");
        if (hotListEntry.title.equals(string)) {
            return;
        }
        UserMenuItem userMenuItem = new UserMenuItem("addgoto " + hotListEntry.getTitle(), hotListEntry.getTitle(), actionListener);
        this.addMenuItem(userMenuItem, userMenu, -5);
    }

    synchronized MenuItem addToMenu(HotListEntry hotListEntry, UserMenu userMenu, ActionListener actionListener, int n) {
        MenuItem menuItem;
        if (hotListEntry instanceof Separator) {
            menuItem = new UserMenuItem("add separator", "", null);
        } else if (hotListEntry instanceof PageFolder) {
            menuItem = new UserMenu(hotListEntry.title, actionListener);
            menuItem.setActionCommand("");
        } else {
            menuItem = new UserMenuItem("go " + hotListEntry.url, hotListEntry.title, actionListener);
        }
        if (userMenu != null && userMenu.getName().equals("gotomenu") && n != -5) {
            n = n + userMenu.getItemCount() - hotListEntry.getParent().getCount() + 1;
        }
        this.addMenuItem(menuItem, userMenu, n);
        return menuItem;
    }

    synchronized void removeFromMenus(HotListEntry hotListEntry) {
        UserMenu userMenu;
        HJFrame[] hJFrameArray = HJWindowManager.getHJWindowManager().getAllFrames();
        int n = 0;
        while (n < hJFrameArray.length) {
            UserMenu userMenu2;
            if (hotListEntry.getParent() == this.regularFolder) {
                userMenu2 = hJFrameArray[n].getRememberToMenu();
                this.removeFromRememberToMenu(hotListEntry, userMenu2);
            }
            if (hotListEntry.isInMenuPlacesFolder()) {
                userMenu2 = hJFrameArray[n].getGotoMenu();
                if (hotListEntry.getParent().getTitle().equals(this.menuPlaces) && hotListEntry.getParent().getCount() == 1) {
                    int n2 = userMenu2.getItemCount();
                    userMenu2.remove(n2 - 2);
                }
                userMenu = this.getSpecificMenu(userMenu2, hotListEntry.getParent(), this.menuPlaces);
            } else {
                userMenu2 = hJFrameArray[n].getListsMenu();
                userMenu = this.getSpecificMenu(userMenu2, hotListEntry.getParent(), this.hotListsMenu);
            }
            this.removeFromMenu(hotListEntry, userMenu);
            ++n;
        }
        if (hotListEntry.getParent() == this.regularFolder) {
            this.removeFromRememberToMenu(hotListEntry, this.rememberToMenu);
        }
        userMenu = this.getSpecificMenu(this.listsMenu, hotListEntry.getParent(), this.hotListsMenu);
        this.removeFromMenu(hotListEntry, userMenu);
    }

    synchronized void removeFromRememberToMenu(HotListEntry hotListEntry, UserMenu userMenu) {
        MenuItem menuItem;
        if (userMenu != null && (menuItem = userMenu.getItem("addgoto " + hotListEntry.getTitle(), false)) != null) {
            userMenu.remove(menuItem);
        }
    }

    synchronized void removeFromMenu(HotListEntry hotListEntry, UserMenu userMenu) {
        if (userMenu != null) {
            if (hotListEntry instanceof Separator) {
                PageFolder pageFolder = hotListEntry.getParent();
                int n = pageFolder.getItemPos(hotListEntry);
                if (n > -1) {
                    int n2 = userMenu.getItemCount();
                    int n3 = pageFolder.getCount();
                    userMenu.remove(n2 - (n3 - n));
                }
                return;
            }
            String string = hotListEntry instanceof PageFolder ? hotListEntry.title : "go " + hotListEntry.url;
            MenuItem menuItem = userMenu.getItem(string, false);
            if (menuItem != null) {
                userMenu.remove(menuItem);
            }
        }
    }

    public synchronized void renameInMenus(HotListEntry hotListEntry, String string, String string2) {
        UserMenu userMenu;
        HJFrame[] hJFrameArray = HJWindowManager.getHJWindowManager().getAllFrames();
        int n = 0;
        while (n < hJFrameArray.length) {
            UserMenu userMenu2;
            if (hotListEntry.getParent() == this.regularFolder) {
                userMenu2 = hJFrameArray[n].getRememberToMenu();
                this.renameInRememberToMenu(hotListEntry, userMenu2, string);
            }
            if (hotListEntry.isInMenuPlacesFolder()) {
                userMenu2 = hJFrameArray[n].getGotoMenu();
                userMenu = this.getSpecificMenu(userMenu2, hotListEntry.getParent(), this.menuPlaces);
                this.renameInMenu(hotListEntry, userMenu, string, string2);
            } else {
                userMenu2 = hJFrameArray[n].getListsMenu();
                userMenu = this.getSpecificMenu(userMenu2, hotListEntry.getParent(), this.hotListsMenu);
                this.renameInMenu(hotListEntry, userMenu, string, string2);
            }
            ++n;
        }
        if (hotListEntry.getParent() == this.regularFolder) {
            this.renameInRememberToMenu(hotListEntry, this.rememberToMenu, string);
        }
        userMenu = this.getSpecificMenu(this.listsMenu, hotListEntry.getParent(), this.hotListsMenu);
        this.renameInMenu(hotListEntry, userMenu, string, string2);
    }

    synchronized void renameInRememberToMenu(HotListEntry hotListEntry, UserMenu userMenu, String string) {
        MenuItem menuItem = userMenu.getItem("addgoto " + hotListEntry.getTitle(), false);
        if (menuItem != null) {
            menuItem.setLabel(string);
            menuItem.setName("addgoto " + string);
            menuItem.setActionCommand("addgoto " + string);
        }
    }

    synchronized void renameInMenu(HotListEntry hotListEntry, UserMenu userMenu, String string, String string2) {
        if (userMenu != null) {
            String string3;
            String string4;
            if (hotListEntry instanceof PageFolder) {
                string4 = string;
                string3 = hotListEntry.getTitle();
            } else {
                string4 = "go " + string2;
                string3 = "go " + hotListEntry.url;
            }
            MenuItem menuItem = userMenu.getItem(string3, false);
            if (menuItem != null) {
                menuItem.setLabel(string);
                menuItem.setName(string4);
            }
        }
    }

    public void exportHTMLFile(String string) {
        this.exportHTMLFile(this.regularFolder, string);
    }

    public void exportHTMLFile() {
        this.exportHTMLFile(this.regularFolder, this.exportFile, true, false);
    }

    public void exportHTMLFile(PageFolder pageFolder, String string) {
        this.exportHTMLFile(pageFolder, string, false, true);
    }

    public void exportHTMLFile(PageFolder pageFolder, String string, boolean bl, boolean bl2) {
        System.out.println("writing out ... " + pageFolder.title);
        this.writer.export(pageFolder, string, bl, bl2);
    }

    public void writeHTMLFile(PageFolder pageFolder, String string, boolean bl) {
        block8: {
            OutputStreamWriter outputStreamWriter = null;
            pageFolder.getTitle();
            try {
                try {
                    String string2 = File.separator;
                    String string3 = System.getProperty("user.home");
                    if (string3 != null && !string3.endsWith(string2)) {
                        string3 = String.valueOf(string3) + string2;
                    }
                    File file = new File(String.valueOf(string3) + ".hotjava" + string2);
                    file.mkdirs();
                    File file2 = new File(string);
                    outputStreamWriter = new FileWriter(file2);
                    this.writeHTMLFolder(pageFolder, outputStreamWriter, bl);
                }
                catch (IOException iOException) {
                    HJFrame hJFrame = HJWindowManager.getHJWindowManager().getLastFocusHolder();
                    ConfirmDialog confirmDialog = new ConfirmDialog("hotlist.save.failed", (Frame)hJFrame, 1);
                    String string4 = "confirm.hotlist.save.failed.exact.prompt";
                    String string5 = this.properties.getPropertyReplace(string4, this.exportFile);
                    confirmDialog.setPrompt(string5);
                    confirmDialog.show();
                }
                Object var6_13 = null;
                if (outputStreamWriter == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var6_14 = null;
                    if (outputStreamWriter == null) break block9;
                    try {
                        outputStreamWriter.flush();
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                outputStreamWriter.flush();
                outputStreamWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void writeHTMLFolder(PageFolder pageFolder, Writer writer, boolean bl) {
        String string = "\n";
        String string2 = "<DL>";
        String string3 = "</DL>";
        String string4 = "<DT>";
        String string5 = "</DT>";
        Vector vector = pageFolder.getContents();
        try {
            writer.write(String.valueOf(string2) + string);
            int n = 0;
            while (n < vector.size()) {
                String string6;
                Object object;
                writer.write(String.valueOf(string4) + string);
                HotListEntry hotListEntry = (HotListEntry)vector.elementAt(n);
                if (hotListEntry instanceof PageFolder) {
                    object = (PageFolder)hotListEntry;
                    string6 = this.properties.getProperty("hotlist.netscape");
                    if (!((HotListEntry)object).title.equals(string6) || bl) {
                        String string7 = "<H3";
                        if (((PageFolder)object).closed()) {
                            string7 = String.valueOf(string7) + " folded";
                        }
                        string7 = String.valueOf(string7) + " visit_count=";
                        string7 = String.valueOf(string7) + ((HotListEntry)object).getVisitCount();
                        string7 = String.valueOf(string7) + " last_visit=";
                        string7 = String.valueOf(string7) + ((HotListEntry)object).getLastVisit();
                        string7 = String.valueOf(string7) + " sort_type=";
                        string7 = String.valueOf(string7) + ((PageFolder)object).getSortType();
                        String string8 = "false";
                        if (((PageFolder)object).isReverseSorted()) {
                            string8 = "true";
                        }
                        string7 = String.valueOf(string7) + " reverse = ";
                        string7 = String.valueOf(string7) + string8;
                        if (((HotListEntry)object).title.equals(this.newPlaces) && !bl) {
                            string7 = String.valueOf(string7) + " special=personal";
                            string7 = String.valueOf(string7) + ">";
                            string7 = String.valueOf(string7) + this.newPlaces;
                        } else if (((HotListEntry)object).title.equals(this.coolPlaces) && !bl) {
                            string7 = String.valueOf(string7) + " special=cool";
                            string7 = String.valueOf(string7) + ">";
                            string7 = String.valueOf(string7) + this.coolPlaces;
                        } else {
                            string7 = String.valueOf(string7) + ">";
                            string7 = String.valueOf(string7) + ((HotListEntry)object).getTitle();
                        }
                        string7 = String.valueOf(string7) + "</H3>";
                        writer.write(String.valueOf(string7) + string);
                        if (((PageFolder)object).getContents().size() != 0) {
                            this.writeHTMLFolder((PageFolder)object, writer, true);
                        }
                    }
                } else if (hotListEntry instanceof Webmark) {
                    object = (Webmark)hotListEntry;
                    string6 = "<A";
                    string6 = String.valueOf(string6) + " href=";
                    string6 = String.valueOf(string6) + ((Webmark)object).getURL();
                    string6 = String.valueOf(string6) + " visit_count=";
                    string6 = String.valueOf(string6) + ((HotListEntry)object).getVisitCount();
                    string6 = String.valueOf(string6) + " last_visit=";
                    string6 = String.valueOf(string6) + ((HotListEntry)object).getLastVisit();
                    string6 = String.valueOf(string6) + ">";
                    string6 = String.valueOf(string6) + ((HotListEntry)object).getTitle();
                    string6 = String.valueOf(string6) + "</A>";
                    writer.write(String.valueOf(string6) + string);
                } else if (hotListEntry instanceof Separator) {
                    Separator cfr_ignored_0 = (Separator)hotListEntry;
                    object = "<HR>";
                    writer.write(String.valueOf(object) + string);
                }
                writer.write(String.valueOf(string5) + string);
                ++n;
            }
            writer.write(String.valueOf(string3) + string + "<P>" + string);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public PageFolder getRegularFolder() {
        return this.regularFolder;
    }

    private void readLegacyData() {
        BufferedReader bufferedReader;
        String string = this.properties.getProperty("user.home");
        String string2 = File.separator;
        if (string != null && !string.endsWith(string2)) {
            string = String.valueOf(string) + string2;
        }
        String string3 = String.valueOf(string) + ".hotjava" + string2 + "hotlist-default";
        String string4 = this.properties.getProperty("hotlist.altinput");
        String string5 = null;
        if (string4 != null) {
            string5 = String.valueOf(string) + string2 + string4;
        }
        this.properties.getProperty("hotlist.err.altinput");
        this.properties.getProperty("hotlist.err.noinput");
        try {
            this.hotlistFile = new File(string3);
            bufferedReader = new BufferedReader(new FileReader(this.hotlistFile));
        }
        catch (Exception exception) {
            try {
                if (string5 == null) {
                    return;
                }
                this.hotlistFile = new File(string5);
                bufferedReader = new BufferedReader(new FileReader(this.hotlistFile));
            }
            catch (Exception exception2) {
                return;
            }
        }
        String string6 = this.properties.getProperty("hotlist.legacy");
        this.addGotoFolder(string6, true, -5);
        this.folderPush();
        try {
            block15: {
                try {
                    bufferedReader.readLine();
                    bufferedReader.readLine();
                    while (true) {
                        String string7 = bufferedReader.readLine();
                        String string8 = bufferedReader.readLine();
                        boolean bl = false;
                        if (string7 == null || string8 == null) break;
                        int n = string7.indexOf(32);
                        if (n != -1) {
                            if (string7.substring(n).startsWith(inMenuTag)) {
                                bl = true;
                            }
                            string7 = string7.substring(0, n);
                        }
                        this.addGotoItem(string7, string8);
                    }
                    Object var9_12 = null;
                    if (bufferedReader == null) break block15;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    if (bufferedReader != null) {
                        bufferedReader.close();
                        this.folderPop();
                    }
                    throw throwable;
                }
                bufferedReader.close();
                this.folderPop();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void importList(Frame frame) {
        UserFileDialog userFileDialog = new UserFileDialog(frame, "hotlist.import.dialog", 0);
        userFileDialog.setDirectory(this.properties.getProperty("user.home"));
        userFileDialog.show();
        String string = String.valueOf(userFileDialog.getDirectory()) + userFileDialog.getFile();
        if (string == null) {
            return;
        }
        string.length();
        if (string.endsWith(".html") || string.endsWith(".htm")) {
            this.importingOurType = true;
            this.importHTMLFile(string);
            String string2 = this.properties.getPropertyReplace("hotlist.importdone.msg", userFileDialog.getFile());
            HotListFrame hotListFrame = (HotListFrame)frame;
            if (hotListFrame != null) {
                hotListFrame.setMessage(string2);
                return;
            }
        } else {
            String string3 = this.properties.getProperty("hotlist.importerr.msg");
            HotListFrame hotListFrame = (HotListFrame)frame;
            if (hotListFrame != null) {
                hotListFrame.setMessage(string3);
            }
        }
    }

    public void exportList(Frame frame, PageFolder pageFolder) {
        String string;
        int n;
        UserFileDialog userFileDialog = new UserFileDialog(frame, "hotlist.export.dialog", 1);
        if (this.fileDialogDirectory != null) {
            userFileDialog.setDirectory(this.fileDialogDirectory);
        }
        if ((n = this.exportFile.lastIndexOf(File.separator)) >= 0) {
            string = this.exportFile.substring(n + 1);
            userFileDialog.setFile(string);
        }
        userFileDialog.show();
        string = userFileDialog.getFile();
        if (string == null || "".equals(string)) {
            return;
        }
        this.fileDialogDirectory = userFileDialog.getDirectory();
        if (this.fileDialogDirectory != null) {
            string = String.valueOf(userFileDialog.getDirectory()) + string;
        }
        if (new File(string).exists() && !userFileDialog.providesSaveConfirmation()) {
            String string2 = "overwrite.file";
            ConfirmDialog confirmDialog = new ConfirmDialog(string2, frame);
            ((Component)confirmDialog).setVisible(true);
            if (confirmDialog.getAnswer() == 0) {
                return;
            }
        }
        if (pageFolder == null) {
            this.exportHTMLFile(string);
            return;
        }
        this.exportHTMLFile(pageFolder, string);
    }

    public boolean isFinishedImporting() {
        return this.threadReader.isFinishedImporting();
    }

    public void raiseImportPriority() {
        this.threadReader.raiseImportPriority();
    }

    public void importHTMLFile(String string, boolean bl, String string2) {
        this.threadReader.importFromHTML(string, bl, string2);
    }

    public void importHTMLFile() {
        this.importHTMLFile(this.importFile);
    }

    public void importHTMLFile(String string) {
        this.importHTMLFile(string, false);
    }

    public void importHTMLFile(String string, boolean bl) {
        this.threadReader.importFromHTML(string, bl);
    }

    public void readHTMLFile(String string) {
        String string2 = string;
        this.currentRegularFolder = this.regularFolder;
        try {
            InputStreamReader inputStreamReader = null;
            String string3 = this.properties.getProperty("hotjava.charset");
            ByteToCharConverter byteToCharConverter = null;
            try {
                byteToCharConverter = ByteToCharConverter.getConverter((String)string3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Charset " + string3 + " is not supported. Use 8859_1");
                string3 = "8859_1";
                this.properties.put("hotjava.charset", string3);
                this.properties.save();
            }
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string2), string3);
            HotListHTMLParser hotListHTMLParser = new HotListHTMLParser(this);
            hotListHTMLParser.parse(inputStreamReader, this.dtd);
            while (!this.folderStack.empty()) {
                this.folderStack.pop();
            }
        }
        catch (Exception exception) {}
        this.importingOurType = false;
    }

    public void sortMenus(PageFolder pageFolder) {
        UserMenu userMenu;
        HJFrame[] hJFrameArray = HJWindowManager.getHJWindowManager().getAllFrames();
        int n = 0;
        while (n < hJFrameArray.length) {
            UserMenu userMenu2;
            if (pageFolder.isInMenuPlacesFolder() || pageFolder.getTitle().equals(this.menuPlaces)) {
                userMenu2 = hJFrameArray[n].getGotoMenu();
                userMenu = this.getSpecificMenu(userMenu2, pageFolder, this.menuPlaces);
            } else {
                userMenu2 = hJFrameArray[n].getListsMenu();
                userMenu = this.getSpecificMenu(userMenu2, pageFolder, this.hotListsMenu);
            }
            this.sortMenu(userMenu, pageFolder);
            ++n;
        }
        userMenu = this.getSpecificMenu(this.listsMenu, pageFolder, this.hotListsMenu);
        this.sortMenu(userMenu, pageFolder);
    }

    public void sortMenu(UserMenu userMenu, PageFolder pageFolder) {
        if (userMenu == null || pageFolder == null) {
            return;
        }
        Vector vector = pageFolder.getContents();
        int n = 0;
        while (n < vector.size()) {
            HotListEntry hotListEntry = (HotListEntry)vector.elementAt(n);
            if (hotListEntry instanceof Separator) {
                userMenu.removeFirstSeparator();
                userMenu.addSeparator();
            } else {
                String string = hotListEntry instanceof PageFolder ? hotListEntry.getTitle() : "go " + hotListEntry.url;
                MenuItem menuItem = userMenu.getItem(string, false);
                if (menuItem != null) {
                    userMenu.remove(menuItem);
                    this.addMenuItem(menuItem, userMenu, -5);
                }
            }
            ++n;
        }
    }

    public void sort(PageFolder pageFolder) {
        if (pageFolder.isReverseSorted()) {
            this.sort(73, pageFolder);
            return;
        }
        this.sort(pageFolder.getSortType(), pageFolder);
    }

    public void sort(int n, PageFolder pageFolder) {
        boolean bl = false;
        if (n == 73) {
            bl = !pageFolder.isReverseSorted();
            pageFolder.reverseSort();
            n = pageFolder.getSortType();
            if (n == 0) {
                return;
            }
        }
        this.sort(n, pageFolder, bl);
    }

    public void sort(int n, PageFolder pageFolder, boolean bl) {
        if (!bl) {
            pageFolder.setSortType(n);
        }
        switch (n) {
            case 70: {
                this.sortAlphabetical(pageFolder, bl);
                break;
            }
            case 71: {
                this.sortOnDates(pageFolder, bl);
                break;
            }
            case 72: {
                this.sortOnVisitFrequency(pageFolder, bl);
                break;
            }
        }
        this.sortMenus(pageFolder);
    }

    public void sortAlphabetical(PageFolder pageFolder, boolean bl) {
        String string;
        if (bl) {
            string = this.properties.getPropertyReplace("hotlist.sortreversealphabetical.msg", pageFolder.title);
            SortVector.reverse(pageFolder.getContents());
        } else {
            AlphabeticalCompare alphabeticalCompare = new AlphabeticalCompare();
            string = this.properties.getPropertyReplace("hotlist.sortalphabetical.msg", pageFolder.title);
            SortVector.quicksort(pageFolder.getContents(), alphabeticalCompare);
        }
        HotListFrame hotListFrame = HotListFrame.getHotListFrame();
        if (hotListFrame != null) {
            hotListFrame.setMessage(string);
        }
    }

    public void sortOnVisitFrequency(PageFolder pageFolder, boolean bl) {
        String string;
        if (bl) {
            string = this.properties.getPropertyReplace("hotlist.sortreversevisitfrequency.msg", pageFolder.title);
            SortVector.reverse(pageFolder.getContents());
        } else {
            VisitFrequencyCompare visitFrequencyCompare = new VisitFrequencyCompare();
            string = this.properties.getPropertyReplace("hotlist.sortvisitfrequency.msg", pageFolder.title);
            SortVector.quicksort(pageFolder.getContents(), visitFrequencyCompare);
        }
        HotListFrame hotListFrame = HotListFrame.getHotListFrame();
        if (hotListFrame != null) {
            hotListFrame.setMessage(string);
        }
    }

    public void sortOnDates(PageFolder pageFolder, boolean bl) {
        String string;
        if (bl) {
            string = this.properties.getPropertyReplace("hotlist.sortreversedatevisited.msg", pageFolder.title);
            SortVector.reverse(pageFolder.getContents());
        } else {
            DateVisitedCompare dateVisitedCompare = new DateVisitedCompare();
            string = this.properties.getPropertyReplace("hotlist.sortdatevisited.msg", pageFolder.title);
            SortVector.quicksort(pageFolder.getContents(), dateVisitedCompare);
        }
        HotListFrame hotListFrame = HotListFrame.getHotListFrame();
        if (hotListFrame != null) {
            hotListFrame.setMessage(string);
        }
    }

    public void sortAlphabeticalRecursive(PageFolder pageFolder, Compare compare, boolean bl) {
        Vector vector = pageFolder.getContents();
        int n = 0;
        while (n < vector.size()) {
            HotListEntry hotListEntry = (HotListEntry)vector.elementAt(n);
            if (hotListEntry instanceof PageFolder) {
                PageFolder pageFolder2 = (PageFolder)hotListEntry;
                pageFolder2.setSortType(pageFolder.getSortType());
                if (bl) {
                    pageFolder2.reverseSort();
                }
                this.sortAlphabeticalRecursive((PageFolder)hotListEntry, compare, bl);
            }
            ++n;
        }
        SortVector.quicksort(vector, compare);
    }

    public void sortOnVisitFrequencyRecursive(PageFolder pageFolder, Compare compare, boolean bl) {
        HotListEntry hotListEntry;
        Vector vector = pageFolder.getContents();
        int n = 0;
        while (n < vector.size()) {
            hotListEntry = (HotListEntry)vector.elementAt(n);
            if (hotListEntry instanceof PageFolder) {
                PageFolder pageFolder2 = (PageFolder)hotListEntry;
                pageFolder2.setSortType(pageFolder.getSortType());
                if (bl) {
                    pageFolder2.reverseSort();
                }
                this.sortOnVisitFrequencyRecursive((PageFolder)hotListEntry, compare, bl);
            }
            ++n;
        }
        SortVector.quicksort(vector, compare);
        if (vector.size() > 0) {
            hotListEntry = (HotListEntry)vector.elementAt(0);
            int n2 = hotListEntry.getVisitCount();
            pageFolder.setVisitCount(n2);
        }
    }

    public void sortOnDatesRecursive(PageFolder pageFolder, Compare compare, boolean bl) {
        HotListEntry hotListEntry;
        Vector vector = pageFolder.getContents();
        int n = 0;
        while (n < vector.size()) {
            hotListEntry = (HotListEntry)vector.elementAt(n);
            if (hotListEntry instanceof PageFolder) {
                PageFolder pageFolder2 = (PageFolder)hotListEntry;
                pageFolder2.setSortType(pageFolder.getSortType());
                if (bl) {
                    pageFolder2.reverseSort();
                }
                this.sortOnDatesRecursive((PageFolder)hotListEntry, compare, bl);
            }
            ++n;
        }
        SortVector.quicksort(vector, compare);
        if (vector.size() > 0) {
            hotListEntry = (HotListEntry)vector.elementAt(0);
            int n2 = hotListEntry.getLastVisit();
            pageFolder.setLastVisit(n2);
        }
    }

    public void printFolder(PageFolder pageFolder) {
        Vector vector = pageFolder.getContents();
        int n = 0;
        while (n < vector.size()) {
            HotListEntry hotListEntry = (HotListEntry)vector.elementAt(n);
            if (hotListEntry instanceof PageFolder) {
                this.printFolder((PageFolder)hotListEntry);
            }
            ++n;
        }
    }

    public void propagateVisitCountAndLastVisit(HotListEntry hotListEntry, int n, int n2) {
        PageFolder pageFolder = hotListEntry.getParent();
        if (pageFolder == null) {
            return;
        }
        if (n > pageFolder.getVisitCount() || n2 > pageFolder.getLastVisit()) {
            pageFolder.setVisitCount(n);
            pageFolder.setLastVisit(n2);
            this.propagateVisitCountAndLastVisit(pageFolder, n, n2);
        }
    }

    private void visitedDocument(PageFolder pageFolder, URL uRL) {
        Vector vector = pageFolder.getContents();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            HotListEntry hotListEntry = (HotListEntry)vector.elementAt(n2);
            if (hotListEntry instanceof PageFolder) {
                object = this.properties.getProperty("hotlist.netscape");
                if (!hotListEntry.title.equals(object)) {
                    this.visitedDocument((PageFolder)hotListEntry, uRL);
                }
            } else if (hotListEntry instanceof Webmark) {
                try {
                    if (hotListEntry.url.equals(uRL.toString())) {
                        object = (Webmark)hotListEntry;
                        int n3 = ((HotListEntry)object).getVisitCount();
                        ((HotListEntry)object).setVisitCount(++n3);
                        int n4 = (int)(System.currentTimeMillis() / 1000L);
                        ((HotListEntry)object).setLastVisit(n4);
                        this.propagateVisitCountAndLastVisit((HotListEntry)object, n3, n4);
                        this.dispatchHotListEvent(52, object);
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    public void markVisited(URL uRL) {
        this.visitedDocument(this.regularFolder, uRL);
    }

    public HotListEntry getEntry(PageFolder pageFolder, HotListEntry hotListEntry) {
        return this.getEntry(pageFolder, hotListEntry.title);
    }

    public HotListEntry getEntry(PageFolder pageFolder, String string) {
        Vector vector = pageFolder.getContents();
        if (vector == null) {
            return null;
        }
        int n = 0;
        while (n < vector.size()) {
            HotListEntry hotListEntry = (HotListEntry)vector.elementAt(n);
            if (hotListEntry.title.equals(string)) {
                return hotListEntry;
            }
            ++n;
        }
        return null;
    }

    public void addPlaces(String string) {
        if (string == null) {
            return;
        }
        int n = string.indexOf(124);
        if (n < 0) {
            return;
        }
        string = string.substring(n + 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = string2 = stringTokenizer.nextToken();
            String string4 = string2;
            n = string2.indexOf(61);
            if (n < 0) continue;
            string3 = string2.substring(0, n);
            string4 = string2.substring(n + 1);
            this.addGotoItem(string4, string3);
        }
    }

    public String getUniqueName(String string) {
        return this.getUniqueName(string, this.currentRegularFolder);
    }

    public String getUniqueName(String string, PageFolder pageFolder) {
        Vector vector = pageFolder.getContents();
        if (vector == null) {
            return string;
        }
        HotListEntry hotListEntry = this.getEntry(pageFolder, string);
        if (hotListEntry == null) {
            return string;
        }
        int n = 1;
        while (n < vector.size()) {
            hotListEntry = this.getEntry(pageFolder, String.valueOf(string) + String.valueOf(n));
            if (hotListEntry == null) {
                return String.valueOf(string) + String.valueOf(n);
            }
            ++n;
        }
        return String.valueOf(string) + String.valueOf(vector.size());
    }

    private static DTD createDTD(DTD dTD, String string) {
        String string2 = "/";
        String string3 = "lib" + string2 + string + ".bdtd";
        InputStream inputStream = null;
        try {
            try {
                inputStream = ClassLoader.getSystemResourceAsStream(string3);
                if (inputStream == null) {
                    throw new Error("Unable to find a .bdtd file :" + string3);
                }
                dTD.read(new DataInputStream(new BufferedInputStream(inputStream)));
                DTD.putDTDHash(string, dTD);
            }
            finally {
                Object var6_5 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return dTD;
    }

    private static final class 1
    extends RequestProcessor.Request {
        private final /* synthetic */ int val$pos;
        private final /* synthetic */ MenuItem val$itemToAdd;
        private final /* synthetic */ UserMenu val$menuToAddTo;

        public void execute() {
            if (this.val$menuToAddTo != null && this.val$menuToAddTo.getItem(this.val$itemToAdd.getName(), false) == null) {
                int n;
                int n2 = n = this.val$pos == -5 ? this.val$menuToAddTo.getItemCount() : this.val$pos;
                if (this.val$itemToAdd.getActionCommand().equals("add separator")) {
                    this.val$menuToAddTo.insertSeparator(n);
                    return;
                }
                this.val$menuToAddTo.insert(this.val$itemToAdd, n);
            }
        }

        /* synthetic */ 1(MenuItem menuItem, UserMenu userMenu, int n) {
            this.val$itemToAdd = menuItem;
            this.val$menuToAddTo = userMenu;
            this.val$pos = n;
        }
    }
}

